/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.sdk.handler;

import com.adm.utils.uft.SSEException;
import com.adm.utils.uft.sdk.Logger;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.io.FileInputStream;
import net.minidev.json.JSONArray;
import org.apache.commons.io.IOUtils;

public class JsonHandler {
    private Logger logger;

    public JsonHandler(Logger logger) {
        this.logger = logger;
    }

    public Object load(String path) {
        Object parsedJson;
        this.logger.log(String.format("Loading JSON file from: [%s]", path));
        try {
            FileInputStream is = new FileInputStream(path);
            String jsonTxt = IOUtils.toString(is, "UTF-8");
            parsedJson = Configuration.defaultConfiguration().addOptions(Option.ALWAYS_RETURN_LIST).jsonProvider().parse(jsonTxt);
        }
        catch (Throwable e) {
            throw new SSEException(String.format("Failed to load JSON from: [%s]", path), e);
        }
        return parsedJson;
    }

    public String getValueFromJsonAsString(Object jsonObject, String pathToRead, boolean shouldGetSingleValueOnly) {
        String value = "";
        try {
            Object extractedObject = JsonPath.read(jsonObject, pathToRead, new Predicate[0]);
            while (extractedObject instanceof JSONArray && shouldGetSingleValueOnly) {
                extractedObject = ((JSONArray)extractedObject).get(0);
            }
            value = extractedObject.toString();
        }
        catch (Throwable e) {
            this.logger.log(String.format("Failed to get the value of [%s] from the JSON file.\n\tError was: %s", pathToRead, e.getMessage()));
        }
        return value;
    }
}

