/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.model;

import com.adm.utils.uft.StringUtils;
import com.adm.utils.uft.model.EnumDescription;
import java.util.Arrays;
import java.util.List;

public class CdaDetails {
    private final String _deploymentAction;
    private final String _deployedEnvironmentName;
    private final String _deprovisioningAction;
    private static final EnumDescription _deploymentActionUseDeployed = new EnumDescription("", "Use Deployed");
    private static final EnumDescription _deploymentActionProvisionDeploy = new EnumDescription("Provision;Deploy", "Provision and Deploy");
    private static final EnumDescription _deploymentActionRedeploy = new EnumDescription("Deploy", "Redeploy");
    private static final List<EnumDescription> _deploymentActions = Arrays.asList(_deploymentActionUseDeployed, _deploymentActionProvisionDeploy, _deploymentActionRedeploy);
    private static final EnumDescription _deprovisioningActionLeaveDeployed = new EnumDescription("", "Leave environment deployed");
    private static final EnumDescription _deprovisioningActionDeprovision = new EnumDescription("Deprovision", "Deprovision at end");
    private static final List<EnumDescription> _deprovisioningActions = Arrays.asList(_deprovisioningActionLeaveDeployed, _deprovisioningActionDeprovision);

    public CdaDetails(String deploymentAction, String deployedEnvironmentName, String deprovisioningAction) {
        this._deploymentAction = deploymentAction;
        this._deployedEnvironmentName = deployedEnvironmentName;
        this._deprovisioningAction = deprovisioningAction;
    }

    public static List<EnumDescription> getDeploymentActions() {
        return _deploymentActions;
    }

    public static List<EnumDescription> getDeprovisioningActions() {
        return _deprovisioningActions;
    }

    public String getTopologyAction() {
        String ret = this._deploymentAction;
        if (!StringUtils.isNullOrEmpty(this._deprovisioningAction)) {
            ret = String.format("%s;%s", ret, this._deprovisioningAction);
        }
        return ret;
    }

    public String getDeploymentAction() {
        return this._deploymentAction;
    }

    public String getDeployedEnvironmentName() {
        return this._deployedEnvironmentName;
    }

    public String getDeprovisioningAction() {
        return this._deprovisioningAction;
    }
}

