/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.integration;

import com.adm.utils.uft.integration.CommonUtils;
import com.adm.utils.uft.integration.HttpConnectionException;
import com.adm.utils.uft.integration.HttpResponse;
import com.adm.utils.uft.integration.HttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;

public class JobOperation {
    public static final String LOGIN_SECRET = "x-hp4msecret";
    public static final String SPLIT_COMMA = ",";
    public static final String JSESSIONID = "JSESSIONID";
    public static final String ACCEPT = "Accept";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String COOKIE = "Cookie";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String EQUAL = "=";
    public static final String STATUS = "status";
    public static final String ERROR = "error";
    private static final String CONTENT_TYPE_DOWNLOAD_VALUE = "multipart/form-data; boundary=----";
    private static final String BOUNDARYSTR = "randomstring";
    public static final String LOGIN_URL = "/rest/client/login";
    public static final String CREATE_JOB_URL = "/rest/job/createTempJob";
    public static final String GET_JOB_URL = "/rest/job/";
    public static final String UPLOAD_APP_URL = "/rest/apps/upload";
    private String _serverUrl;
    private String _userName;
    private String _password;
    private String proxyHost;
    private String proxyPort;
    private String proxyUserName;
    private String proxyPassword;

    public JobOperation() {
    }

    public JobOperation(String serverUrl, String userName, String password) {
        this._userName = userName;
        this._password = password;
        this._serverUrl = this.checkUrl(serverUrl);
    }

    public JobOperation(String serverUrl, String userName, String password, String address, String proxyUserName, String proxyPassword) {
        this._userName = userName;
        this._password = password;
        this._serverUrl = this.checkUrl(serverUrl);
        if (address != null) {
            int i = (address = this.checkUrl(address)).lastIndexOf(58);
            if (i > 0) {
                this.proxyHost = address.substring(0, i);
                this.proxyPort = address.substring(i + 1, address.length());
            } else {
                this.proxyHost = address;
                this.proxyPort = "80";
            }
        }
        this.proxyUserName = proxyUserName;
        this.proxyPassword = proxyPassword;
    }

    public String upload(String appPath) throws HttpConnectionException, IOException {
        String json = null;
        String hp4mSecret = null;
        String jsessionId = null;
        SessionInfo info = this.loginToMC();
        try {
            if (info != null) {
                hp4mSecret = info.getHp4MSecret();
                jsessionId = info.getJSessionId();
            }
        }
        catch (Exception e) {
            return null;
        }
        File appFile = new File(appPath);
        String uploadUrl = this._serverUrl + UPLOAD_APP_URL;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(LOGIN_SECRET, hp4mSecret);
        headers.put(COOKIE, "JSESSIONID=" + jsessionId);
        headers.put(CONTENT_TYPE, "multipart/form-data; boundary=----randomstring");
        headers.put("filename", appFile.getName());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StringBuffer content = new StringBuffer();
        content.append("\r\n").append("------").append(BOUNDARYSTR).append("\r\n");
        content.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + appFile.getName() + "\"\r\n");
        content.append("Content-Type: application/octet-stream\r\n\r\n");
        outputStream.write(content.toString().getBytes());
        FileInputStream in = new FileInputStream(appFile);
        byte[] b = new byte[1024];
        int i = 0;
        while ((i = in.read(b)) != -1) {
            outputStream.write(b, 0, i);
        }
        in.close();
        outputStream.write("\r\n------randomstring--\r\n".getBytes());
        byte[] bytes = outputStream.toByteArray();
        outputStream.close();
        HttpUtils.ProxyInfo proxyInfo = HttpUtils.setProxyCfg(this.proxyHost, this.proxyPort, this.proxyUserName, this.proxyPassword);
        HttpResponse response = HttpUtils.post(proxyInfo, uploadUrl, headers, bytes);
        if (response != null && response.getJsonObject() != null) {
            json = response.getJsonObject().toJSONString();
        }
        return json;
    }

    public SessionInfo loginToMC() throws HttpConnectionException {
        HttpResponse response;
        SessionInfo info = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(ACCEPT, "application/json");
        headers.put(CONTENT_TYPE, "application/json;charset=UTF-8");
        JSONObject sendObject = new JSONObject();
        sendObject.put("name", this._userName);
        sendObject.put("password", this._password);
        sendObject.put("accountName", "default");
        HttpUtils.ProxyInfo proxyInfo = null;
        if (this.proxyHost != null && this.proxyPort != null) {
            proxyInfo = HttpUtils.setProxyCfg(this.proxyHost, this.proxyPort, this.proxyUserName, this.proxyPassword);
        }
        if ((response = HttpUtils.post(proxyInfo, this._serverUrl + LOGIN_URL, headers, sendObject.toJSONString().getBytes())) != null) {
            if (response.getHeaders() != null) {
                Map<String, List<String>> headerFields = response.getHeaders();
                List<String> hp4mSecretList = headerFields.get(LOGIN_SECRET);
                String hp4mSecret = null;
                if (hp4mSecretList != null && hp4mSecretList.size() != 0) {
                    hp4mSecret = hp4mSecretList.get(0);
                }
                List<String> setCookieList = headerFields.get(SET_COOKIE);
                String setCookie = null;
                if (setCookieList != null && setCookieList.size() != 0) {
                    setCookie = setCookieList.toString();
                }
                String jsessionId = this.getJSESSIONID(setCookie);
                if (hp4mSecret == null || jsessionId == null) {
                    throw new HttpConnectionException();
                }
                info = new SessionInfo(jsessionId, hp4mSecret, response);
            } else {
                info = new SessionInfo(response);
            }
        }
        return info;
    }

    public String createTempJob() throws HttpConnectionException {
        String json = null;
        String hp4mSecret = null;
        String jsessionId = null;
        SessionInfo info = this.loginToMC();
        try {
            if (info == null) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put(STATUS, -999);
                return jsonObj.toJSONString();
            }
            if (info.getResponse().getResponseCode() != 200) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put(STATUS, info.getResponse().getResponseCode());
                jsonObj.put(ERROR, info.getResponse().getResponseMessage());
                return jsonObj.toJSONString();
            }
            hp4mSecret = info.getHp4MSecret();
            jsessionId = info.getJSessionId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean ok = CommonUtils.doCheck(hp4mSecret, jsessionId);
        if (ok) {
            HttpResponse response;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(LOGIN_SECRET, hp4mSecret);
            headers.put(COOKIE, "JSESSIONID=" + jsessionId);
            HttpUtils.ProxyInfo proxyInfo = null;
            if (this.proxyHost != null && this.proxyPort != null) {
                proxyInfo = HttpUtils.setProxyCfg(this.proxyHost, this.proxyPort, this.proxyUserName, this.proxyPassword);
            }
            if ((response = HttpUtils.get(proxyInfo, this._serverUrl + CREATE_JOB_URL, headers, null)) != null) {
                if (response.getJsonObject() == null) {
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put(STATUS, response.getResponseCode());
                    jsonObj.put(ERROR, response.getResponseMessage());
                    json = jsonObj.toJSONString();
                } else {
                    json = response.getJsonObject().toJSONString();
                }
            }
        }
        return json;
    }

    public JSONObject getJobById(String jobUUID) throws HttpConnectionException {
        String jsessionId;
        String hp4mSecret;
        JSONObject jobJsonObject;
        block6: {
            jobJsonObject = null;
            hp4mSecret = null;
            jsessionId = null;
            SessionInfo info = this.loginToMC();
            try {
                if (info == null) break block6;
                if (info.getResponse().getResponseCode() == 200) {
                    hp4mSecret = info.getHp4MSecret();
                    jsessionId = info.getJSessionId();
                    break block6;
                }
                JSONObject jsonObj = new JSONObject();
                jsonObj.put(STATUS, info.getResponse().getResponseCode());
                jsonObj.put(ERROR, info.getResponse().getResponseMessage());
                return jsonObj;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean ok = CommonUtils.doCheck(jobUUID, hp4mSecret, jsessionId);
        if (ok) {
            HttpResponse response;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(LOGIN_SECRET, hp4mSecret);
            headers.put(COOKIE, "JSESSIONID=" + jsessionId);
            HttpUtils.ProxyInfo proxyInfo = null;
            if (this.proxyHost != null && this.proxyPort != null) {
                proxyInfo = HttpUtils.setProxyCfg(this.proxyHost, this.proxyPort, this.proxyUserName, this.proxyPassword);
            }
            if ((response = HttpUtils.get(proxyInfo, this._serverUrl + GET_JOB_URL + jobUUID, headers, null)) != null && response.getJsonObject() != null) {
                jobJsonObject = response.getJsonObject();
            }
        }
        return jobJsonObject;
    }

    public String getJobJSONData(String jobUUID) throws HttpConnectionException {
        JSONObject jobJSON = this.getJobById(jobUUID);
        JSONObject returnJSON = new JSONObject();
        JSONObject dataJSON = null;
        if (jobJSON != null) {
            dataJSON = (JSONObject)jobJSON.get("data");
        }
        if (dataJSON != null) {
            String headerStr;
            JSONObject headerJSON;
            JSONObject deviceJSON;
            JSONObject returnDeviceCapabilityJSON = new JSONObject();
            JSONObject detailJSON = (JSONObject)dataJSON.get("capableDeviceFilterDetails");
            if (detailJSON != null) {
                String osType = (String)detailJSON.get("platformName");
                String osVersion = (String)detailJSON.get("platformVersion");
                String manufacturerAndModel = (String)detailJSON.get("deviceName");
                String targetLab = (String)detailJSON.get("source");
                returnDeviceCapabilityJSON.put("OS", osType + osVersion);
                returnDeviceCapabilityJSON.put("manufacturerAndModel", manufacturerAndModel);
                returnDeviceCapabilityJSON.put("targetLab", targetLab);
            }
            JSONObject returnDeviceJSON = new JSONObject();
            JSONArray devices = (JSONArray)dataJSON.get("devices");
            if (devices != null && (deviceJSON = (JSONObject)devices.get(0)) != null) {
                String deviceID = deviceJSON.getAsString("deviceID");
                String osType = deviceJSON.getAsString("osType");
                String osVersion = deviceJSON.getAsString("osVersion");
                String manufacturerAndModel = deviceJSON.getAsString("model");
                returnDeviceJSON.put("deviceId", deviceID);
                returnDeviceJSON.put("OS", osType + " " + osVersion);
                returnDeviceJSON.put("manufacturerAndModel", manufacturerAndModel);
            }
            JSONArray returnExtraJSONArray = new JSONArray();
            JSONArray extraAppJSONArray = (JSONArray)dataJSON.get("extraApps");
            if (extraAppJSONArray != null) {
                Iterator iterator = extraAppJSONArray.iterator();
                while (iterator.hasNext()) {
                    JSONObject extraAPPJSON = new JSONObject();
                    JSONObject nextJSONObject = (JSONObject)iterator.next();
                    String extraAppName = (String)nextJSONObject.get("name");
                    Boolean instrumented = (Boolean)nextJSONObject.get("instrumented");
                    extraAPPJSON.put("extraAppName", extraAppName);
                    extraAPPJSON.put("instrumented", instrumented != false ? "Packaged" : "Not Packaged");
                    returnExtraJSONArray.add(extraAPPJSON);
                }
            }
            JSONObject returnDefinitionJSON = new JSONObject();
            JSONObject applicationJSON = (JSONObject)dataJSON.get("application");
            if (applicationJSON != null) {
                String launchApplicationName = (String)applicationJSON.get("name");
                Boolean instrumented = (Boolean)applicationJSON.get("instrumented");
                returnDefinitionJSON.put("launchApplicationName", launchApplicationName);
                returnDefinitionJSON.put("instrumented", instrumented != false ? "Packaged" : "Not Packaged");
            }
            if ((headerJSON = this.parseJSONString(headerStr = (String)dataJSON.get("header"))) != null) {
                JSONObject configurationJSONObject = (JSONObject)headerJSON.get("configuration");
                Boolean restart = (Boolean)configurationJSONObject.get("restartApp");
                Boolean install = (Boolean)configurationJSONObject.get("installAppBeforeExecution");
                Boolean uninstall = (Boolean)configurationJSONObject.get("deleteAppAfterExecution");
                StringBuffer sb = new StringBuffer("");
                if (restart.booleanValue()) {
                    sb.append("Restart;");
                }
                if (install.booleanValue()) {
                    sb.append("Install;");
                }
                if (uninstall.booleanValue()) {
                    sb.append("Uninstall;");
                }
                JSONObject collectJSON = (JSONObject)headerJSON.get("collect");
                StringBuffer deviceMetricsSb = new StringBuffer("");
                if (collectJSON != null) {
                    Boolean useCPU = (Boolean)collectJSON.get("cpu");
                    Boolean useMemory = (Boolean)collectJSON.get("memory");
                    Boolean useLogs = (Boolean)collectJSON.get("logs");
                    Boolean useScreenshot = (Boolean)collectJSON.get("screenshot");
                    Boolean useFreeMemory = (Boolean)collectJSON.get("freeMemory");
                    if (useCPU.booleanValue()) {
                        deviceMetricsSb.append("CPU;");
                    }
                    if (useMemory.booleanValue()) {
                        deviceMetricsSb.append("Memory;");
                    }
                    if (useLogs.booleanValue()) {
                        deviceMetricsSb.append("Log;");
                    }
                    if (useScreenshot.booleanValue()) {
                        deviceMetricsSb.append("Screenshot;");
                    }
                    if (useFreeMemory.booleanValue()) {
                        deviceMetricsSb.append("FreeMomery;");
                    }
                }
                returnDefinitionJSON.put("autActions", this.removeLastSemicolon(sb));
                returnDefinitionJSON.put("deviceMetrics", this.removeLastSemicolon(deviceMetricsSb));
            }
            returnJSON.put("deviceCapability", returnDeviceCapabilityJSON);
            returnJSON.put("extraApps", returnExtraJSONArray);
            returnJSON.put("definitions", returnDefinitionJSON);
            returnJSON.put("jobUUID", jobUUID);
            returnJSON.put("specificDevice", returnDeviceJSON);
        }
        return returnJSON.toJSONString();
    }

    public String removeLastSemicolon(StringBuffer sb) {
        int len = sb.length();
        if (len > 0) {
            sb = sb.delete(len - 1, len);
            return sb.toString();
        }
        return sb.toString();
    }

    public JSONObject parseJSONString(String jsonString) {
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)JSONValue.parseStrict(jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    private String getJSESSIONID(String setCookie) {
        String id = null;
        String[] cookies = setCookie.split(SPLIT_COMMA);
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].contains(JSESSIONID)) continue;
            int index = cookies[i].indexOf(EQUAL);
            int endIndex = cookies[i].indexOf(";");
            id = cookies[i].substring(index + 1, endIndex);
            break;
        }
        return id;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    private String checkUrl(String serverUrl) {
        if (serverUrl != null && serverUrl.endsWith("/")) {
            int index = serverUrl.lastIndexOf("/");
            serverUrl = serverUrl.substring(0, index);
            return serverUrl;
        }
        return serverUrl;
    }

    protected class SessionInfo {
        private String jsessionId;
        private String hp4mSecret;
        private HttpResponse response;

        public SessionInfo(String jsessionId, String hp4mSecret, HttpResponse response) {
            this.jsessionId = jsessionId;
            this.hp4mSecret = hp4mSecret;
            this.response = response;
        }

        public SessionInfo(HttpResponse response) {
            this.response = response;
        }

        public String getJSessionId() {
            return this.jsessionId;
        }

        public String getHp4MSecret() {
            return this.hp4mSecret;
        }

        public HttpResponse getResponse() {
            return this.response;
        }
    }
}

