/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.sv;

import com.adm.bamboo.plugin.sv.model.ServiceInfo;
import com.adm.bamboo.plugin.sv.model.SvServiceSelectionModel;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.microfocus.sv.svconfigurator.build.ProjectBuilder;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.atom.ServiceListAtom;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.impl.CommandExecutorFactory;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SVExecutorUtil {
    public static ICommandExecutor createCommandExecutor(URL url, Credentials credentials) throws Exception {
        return new CommandExecutorFactory().createCommandExecutor(url, true, credentials);
    }

    public static List<ServiceInfo> getServiceList(ICommandExecutor commandExecutor, SvServiceSelectionModel svServiceSelectionModel, boolean ignoreMissingServices, BuildLogger buildLogger) throws Exception {
        String projectPassword = svServiceSelectionModel.getProjectPassword();
        String projectPath = svServiceSelectionModel.getProjectPath();
        ArrayList<ServiceInfo> res = new ArrayList<ServiceInfo>();
        switch (svServiceSelectionModel.getSelectionType()) {
            case SERVICE: {
                SVExecutorUtil.addServiceIfDeployed(svServiceSelectionModel.getService(), res, ignoreMissingServices, commandExecutor, buildLogger);
                break;
            }
            case PROJECT: {
                IProject project = new ProjectBuilder().buildProject(new File(projectPath), projectPassword);
                for (IService svc : project.getServices()) {
                    SVExecutorUtil.addServiceIfDeployed(svc.getId(), res, ignoreMissingServices, commandExecutor, buildLogger);
                }
                break;
            }
            case ALL_DEPLOYED: {
                for (ServiceListAtom.ServiceEntry entry : commandExecutor.getServiceList(null).getEntries()) {
                    res.add(new ServiceInfo(entry.getId(), entry.getTitle()));
                }
                break;
            }
        }
        return res;
    }

    private static void addServiceIfDeployed(String service, ArrayList<ServiceInfo> results, boolean ignoreMissingServices, ICommandExecutor exec, BuildLogger buildLogger) throws CommunicatorException, CommandExecutorException {
        try {
            IService svc = exec.findService(service, null);
            results.add(new ServiceInfo(svc.getId(), svc.getName()));
        }
        catch (CommandExecutorException e) {
            if (!ignoreMissingServices) {
                throw e;
            }
            buildLogger.addBuildLogEntry(String.format("Service '%s' is not deployed, ignoring%n", service));
        }
    }

    public static void logConfig(SvServiceSelectionModel svServiceSelectionModel, BuildLogger buildLogger, String prefix) {
        switch (svServiceSelectionModel.getSelectionType()) {
            case SERVICE: {
                buildLogger.addBuildLogEntry(prefix + "Service name or id: " + svServiceSelectionModel.getService());
                break;
            }
            case PROJECT: {
                buildLogger.addBuildLogEntry(prefix + "Project path: " + svServiceSelectionModel.getProjectPath());
                buildLogger.addBuildLogEntry(prefix + "Project password: " + (StringUtils.isNotBlank(svServiceSelectionModel.getProjectPassword()) ? "*****" : null));
                break;
            }
            case ALL_DEPLOYED: {
                buildLogger.addBuildLogEntry(prefix + "All deployed services");
                break;
            }
            case DEPLOY: {
                buildLogger.addBuildLogEntry(prefix + "Project path: " + svServiceSelectionModel.getProjectPath());
                buildLogger.addBuildLogEntry(prefix + "Project password: " + (StringUtils.isNotBlank(svServiceSelectionModel.getProjectPassword()) ? "*****" : null));
                buildLogger.addBuildLogEntry(prefix + "Service name or id: " + svServiceSelectionModel.getService());
            }
        }
    }

    public static boolean validInput(String input) {
        boolean valid = true;
        if (input == null || StringUtils.isEmpty(input)) {
            valid = false;
        }
        return valid;
    }
}

