/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.loadrunner;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class LoadRunnerExecutor {
    private String tests;
    private String timeout;
    private String pollingInterval;
    private String execTimeout;
    private String ignoreErrors;
    private String workingDirectory;

    public LoadRunnerExecutor(String tests, String timeout, String pollingInterval, String execTimeout, String ignoreErrors, String workingDirectory) {
        this.tests = tests;
        this.timeout = timeout;
        this.pollingInterval = pollingInterval;
        this.execTimeout = execTimeout;
        this.ignoreErrors = ignoreErrors;
        this.workingDirectory = workingDirectory;
    }

    public Process run(String launcher, String paramFileName) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(this.workingDirectory + "\\" + launcher, "-paramfile", this.workingDirectory + "\\" + paramFileName);
        processBuilder.directory(new File(this.workingDirectory));
        processBuilder.redirectErrorStream(true);
        return processBuilder.start();
    }

    public String createParamFile() throws IOException {
        Properties props = new Properties();
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss-SSS");
        String time = formatter.format((Object)now);
        String paramFileName = String.format("props%s.txt", time);
        String resultsFileName = String.format("Results%s.xml", time);
        props.put("runType", "FileSystem");
        String[] testsArr = this.tests.split("\n");
        int i = 1;
        for (String test : testsArr) {
            test.trim();
            props.put("Test" + i, test);
            ++i;
        }
        if (this.timeout != null && !"".equals(this.timeout)) {
            props.put("fsTimeout", this.timeout);
        }
        if (this.pollingInterval != null && !"".equals(this.pollingInterval)) {
            props.put("controllerPollingInterval", this.pollingInterval);
        } else {
            props.put("controllerPollingInterval", "30");
        }
        if (this.execTimeout != null && !"".equals(this.execTimeout)) {
            props.put("PerScenarioTimeOut", this.execTimeout);
        } else {
            props.put("PerScenarioTimeOut", "10");
        }
        if (!"".equals(this.ignoreErrors)) {
            props.put("ignoreErrorStrings", this.ignoreErrors);
        }
        props.put("resultsFilename", this.workingDirectory + "\\" + resultsFileName);
        BufferedWriter buf = new BufferedWriter(new FileWriter(new File(this.workingDirectory + "\\" + paramFileName)));
        props.store(buf, null);
        buf.close();
        return paramFileName;
    }
}

