/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.task;

import com.adm.bamboo.plugin.uft.api.AbstractLauncherTask;
import com.adm.bamboo.plugin.uft.results.TestResultHelper;
import com.adm.bamboo.plugin.uft.ui.UploadApplicationUftTaskConfigurator;
import com.adm.utils.uft.Aes256Encryptor;
import com.adm.utils.uft.StringUtils;
import com.adm.utils.uft.TaskUtils;
import com.adm.utils.uft.enums.UFTConstants;
import com.adm.utils.uft.integration.HttpConnectionException;
import com.adm.utils.uft.integration.JobOperation;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.ParseException;
import org.apache.commons.lang.BooleanUtils;
import org.jetbrains.annotations.NotNull;

public class UploadApplicationUftTask
implements AbstractLauncherTask {
    private final I18nBean i18nBean;
    private final TestCollationService testCollationService;

    public UploadApplicationUftTask(@NotNull TestCollationService testCollationService, @NotNull I18nBeanFactory i18nBeanFactory) {
        this.i18nBean = i18nBeanFactory.getI18nBean();
        this.testCollationService = testCollationService;
    }

    @Override
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        ConfigurationMap map = taskContext.getConfigurationMap();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        String mcServerUrl = (String)map.get((Object)UFTConstants.MC_SERVER_URL.getValue());
        String mcUserName = (String)map.get((Object)UFTConstants.MC_USERNAME.getValue());
        String mcPassword = (String)map.get((Object)UFTConstants.MC_PASSWORD.getValue());
        String proxyAddress = null;
        String proxyUserName = null;
        String proxyPassword = null;
        boolean useProxy = BooleanUtils.toBoolean((String)map.get((Object)UFTConstants.USE_PROXY.getValue()));
        if (useProxy) {
            proxyAddress = (String)map.get((Object)UFTConstants.PROXY_ADDRESS.getValue());
            Boolean specifyAuthentication = BooleanUtils.toBoolean(UFTConstants.SPECIFY_AUTHENTICATION.getValue());
            if (specifyAuthentication.booleanValue()) {
                proxyUserName = (String)map.get((Object)UFTConstants.PROXY_USERNAME.getValue());
                proxyPassword = (String)map.get((Object)UFTConstants.PROXY_PASSWORD.getValue());
            }
        }
        JobOperation operation = new JobOperation(mcServerUrl, mcUserName, mcPassword, proxyAddress, proxyUserName, proxyPassword);
        List<String> applicationsPaths = UploadApplicationUftTaskConfigurator.fetchMCApplicationPathFromContext((Map<String, String>)map);
        if (applicationsPaths == null || applicationsPaths.size() == 0) {
            return TaskUtils.logErrorMessage(this.i18nBean.getText("UploadApplicationTask.error.atLeastOneApp"), buildLogger, taskContext);
        }
        for (String path : applicationsPaths) {
            String appName = new File(path).getName();
            buildLogger.addBuildLogEntry(String.format(this.i18nBean.getText("UploadApplicationTask.msg.startUpload"), appName));
            String info = null;
            try {
                info = operation.upload(path);
            }
            catch (HttpConnectionException e) {
                return TaskUtils.logErrorMessage(this.i18nBean.getText("UploadApplicationTask.error.failToConnectMCServer"), buildLogger, taskContext);
            }
            catch (FileNotFoundException e) {
                return TaskUtils.logErrorMessage(String.format(this.i18nBean.getText("UploadApplicationTask.error.failToFindApp"), appName), buildLogger, taskContext);
            }
            catch (IOException e) {
                return TaskUtils.logErrorMessage(this.i18nBean.getText("UploadApplicationTask.error.uploadApp"), buildLogger, taskContext);
            }
            if (StringUtils.isNullOrEmpty(info)) {
                return TaskUtils.logErrorMessage(this.i18nBean.getText("UploadApplicationTask.error.unknownErr"), buildLogger, taskContext);
            }
            try {
                JSONObject jsonObject = (JSONObject)JSONValue.parseStrict(info);
                if (((Boolean)jsonObject.get("error")).booleanValue()) {
                    return TaskUtils.logErrorMessage((String)jsonObject.get("message"), buildLogger, taskContext);
                }
            }
            catch (ParseException e) {
                return TaskUtils.logErrorMessage(this.i18nBean.getText("UploadApplicationTask.error.unknownErr"), buildLogger, taskContext);
            }
            buildLogger.addBuildLogEntry(this.i18nBean.getText("UploadApplicationTask.msg.uploadSuccessful"));
        }
        if (applicationsPaths.size() > 1) {
            buildLogger.addBuildLogEntry(this.i18nBean.getText("UploadApplicationTask.msg.allUploadSuccessful"));
        }
        return this.collateResults(taskContext, null);
    }

    @Override
    public TaskResult collateResults(@NotNull TaskContext taskContext, Properties mergedProperties) {
        try {
            TestResultHelper.collateTestResults(this.testCollationService, taskContext);
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).build();
        }
        catch (Exception ex) {
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
    }

    @Override
    public Properties getTaskProperties(TaskContext taskContext) {
        return null;
    }

    @Override
    public Aes256Encryptor getAes256Encryptor() {
        return null;
    }

    @Override
    public CustomVariableContext getCustomVariableContext() {
        return null;
    }
}

