/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.task;

import com.adm.bamboo.plugin.uft.api.AbstractLauncherTask;
import com.adm.bamboo.plugin.uft.helpers.AlmConfigParameter;
import com.adm.bamboo.plugin.uft.ui.AlmLabEnvPrepareUftTaskConfigurator;
import com.adm.utils.uft.Aes256Encryptor;
import com.adm.utils.uft.StringUtils;
import com.adm.utils.uft.enums.UFTConstants;
import com.adm.utils.uft.model.AutEnvironmentConfigModel;
import com.adm.utils.uft.model.AutEnvironmentParameterModel;
import com.adm.utils.uft.model.AutEnvironmentParameterType;
import com.adm.utils.uft.rest.RestClient;
import com.adm.utils.uft.sdk.AUTEnvironmentBuilderPerformer;
import com.adm.utils.uft.sdk.Logger;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class AlmLabEnvPrepareUftTask
implements AbstractLauncherTask {
    private final CustomVariableContext customVariableContext;

    public AlmLabEnvPrepareUftTask(@ComponentImport CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    @Override
    public CustomVariableContext getCustomVariableContext() {
        return this.customVariableContext;
    }

    @Override
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        VariableContext variableContext = taskContext.getCommonContext().getVariableContext();
        final BuildLogger buildLogger = taskContext.getBuildLogger();
        ConfigurationMap confMap = taskContext.getConfigurationMap();
        TaskState state = TaskState.SUCCESS;
        String domain = (String)confMap.get((Object)UFTConstants.DOMAIN.getValue());
        String project = (String)confMap.get((Object)UFTConstants.PROJECT_LAB_ENV.getValue());
        String userName = (String)confMap.get((Object)UFTConstants.USER_NAME_LAB_ENV.getValue());
        boolean useExistingAutEnvConf = AlmLabEnvPrepareUftTaskConfigurator.useExistingConfiguration((Map<String, String>)confMap);
        String configuration = useExistingAutEnvConf ? (String)confMap.get((Object)UFTConstants.AUT_ENV_EXIST_CONFIG_ID.getValue()) : (String)confMap.get((Object)UFTConstants.AUT_ENV_NEW_CONFIG_NAME.getValue());
        ArrayList<AutEnvironmentParameterModel> autEnvironmentParameters = new ArrayList<AutEnvironmentParameterModel>();
        for (AlmConfigParameter prm : AlmLabEnvPrepareUftTaskConfigurator.fetchAlmParametersFromContext((Map<String, String>)confMap)) {
            AutEnvironmentParameterType type = this.convertType(prm.getAlmParamSourceType());
            autEnvironmentParameters.add(new AutEnvironmentParameterModel(prm.getAlmParamName(), prm.getAlmParamValue(), type, prm.getAlmParamOnlyFirst()));
        }
        String almServerPath = (String)confMap.get((Object)UFTConstants.ALM_SERVER.getValue());
        RestClient restClient = new RestClient(almServerPath, domain, project, userName);
        AutEnvironmentConfigModel autEnvModel = new AutEnvironmentConfigModel(almServerPath, userName, (String)confMap.get((Object)UFTConstants.PASSWORD_LAB_ENV.getValue()), domain, project, useExistingAutEnvConf, (String)confMap.get((Object)UFTConstants.AUT_ENV_ID.getValue()), configuration, (String)confMap.get((Object)UFTConstants.PATH_TO_JSON_FILE.getValue()), autEnvironmentParameters);
        try {
            Logger logger = new Logger(){

                @Override
                public void log(String message) {
                    buildLogger.addBuildLogEntry(message);
                }
            };
            AUTEnvironmentBuilderPerformer performer = new AUTEnvironmentBuilderPerformer(restClient, logger, autEnvModel);
            performer.start();
            String outputConfig = (String)confMap.get((Object)UFTConstants.OUTPUT_CONFIG_ID.getValue());
            if (!StringUtils.isNullOrEmpty(outputConfig)) {
                String confId = autEnvModel.getCurrentConfigID();
                variableContext.addResultVariable(outputConfig, confId);
            }
        }
        catch (InterruptedException e) {
            state = TaskState.ERROR;
        }
        catch (Throwable cause) {
            state = TaskState.FAILED;
        }
        TaskResultBuilder result = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).setState(state);
        return result.build();
    }

    private AutEnvironmentParameterType convertType(String sourceType) {
        if (sourceType.equals(UFTConstants.ENV_ALM_PARAMETERS_TYPE_ENV.getValue())) {
            return AutEnvironmentParameterType.ENVIRONMENT;
        }
        if (sourceType.equals(UFTConstants.ENV_ALM_PARAMETERS_TYPE_JSON.getValue())) {
            return AutEnvironmentParameterType.EXTERNAL;
        }
        if (sourceType.equals(UFTConstants.ENV_ALM_PARAMETERS_TYPE_MAN.getValue())) {
            return AutEnvironmentParameterType.USER_DEFINED;
        }
        return AutEnvironmentParameterType.UNDEFINED;
    }

    @Override
    public Properties getTaskProperties(TaskContext taskContext) {
        return null;
    }

    @Override
    public TaskResult collateResults(@NotNull TaskContext taskContext, Properties mergedProperties) {
        return null;
    }

    @Override
    public Aes256Encryptor getAes256Encryptor() {
        return null;
    }
}

