/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.results;

import com.adm.utils.uft.result.ResultSerializer;
import com.adm.utils.uft.result.model.junit.Testcase;
import com.adm.utils.uft.result.model.junit.Testsuite;
import com.adm.utils.uft.result.model.junit.Testsuites;
import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class XmlTestResultsReportCollector
implements TestReportCollector {
    @NotNull
    public TestCollectionResult collect(File file) throws Exception {
        TestCollectionResultBuilder builder = new TestCollectionResultBuilder();
        ArrayList<TestResults> successfulTestResults = new ArrayList<TestResults>();
        ArrayList<TestResults> failingTestResults = new ArrayList<TestResults>();
        Testsuites testsuites = ResultSerializer.Deserialize(file);
        for (Testsuite testsuite : testsuites.getTestsuite()) {
            for (Testcase testcase : testsuite.getTestcase()) {
                TestResults testResult = new TestResults(testcase.getClassname(), testcase.getName(), testcase.getTime());
                if (testcase.getStatus().equals("pass") || testcase.getStatus().equals("warning")) {
                    testResult.setState(TestState.SUCCESS);
                    successfulTestResults.add(testResult);
                } else {
                    testResult.setState(TestState.FAILED);
                    failingTestResults.add(testResult);
                }
                testResult.setSystemOut("Test result: " + testcase.getStatus());
            }
        }
        return builder.addSuccessfulTestResults(successfulTestResults).addFailedTestResults(failingTestResults).build();
    }

    @NotNull
    public Set<String> getSupportedFileExtensions() {
        return Sets.newHashSet((Object[])new String[]{"xml"});
    }
}

