/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.results;

import com.adm.bamboo.plugin.uft.results.ResultInfoItem;
import com.adm.utils.uft.FilesHandler;
import com.adm.utils.uft.enums.ResultTypeFilter;
import com.adm.utils.uft.enums.UFTConstants;
import com.adm.utils.uft.result.ResultSerializer;
import com.adm.utils.uft.result.model.junit.Testcase;
import com.adm.utils.uft.result.model.junit.Testsuite;
import com.adm.utils.uft.result.model.junit.Testsuites;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.TaskContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;

public final class TestResultHelperFileSystem {
    public static Collection<ResultInfoItem> getTestResults(@NotNull File results, ResultTypeFilter filter, @NotNull String resultArtifactNameFormat, @NotNull TaskContext taskContext, @NotNull BuildLogger logger) {
        ArrayList<ResultInfoItem> resultItems = new ArrayList<ResultInfoItem>();
        HashMap<String, Integer> testNames = new HashMap<String, Integer>();
        if (!results.exists()) {
            logger.addBuildLogEntry("Test results file (" + results.getName() + ") was not found.");
            return resultItems;
        }
        try {
            Testsuites testsuites = ResultSerializer.Deserialize(results);
            for (Testsuite testsuite : testsuites.getTestsuite()) {
                for (Testcase testcase : testsuite.getTestcase()) {
                    if (!TestResultHelperFileSystem.isInFilter(testcase, filter)) continue;
                    String testName = new File(testcase.getName()).getName();
                    if (!testNames.containsKey(testName)) {
                        testNames.put(testName, 0);
                    }
                    testNames.put(testName, (Integer)testNames.get(testName) + 1);
                    StringBuilder fileNameSuffix = new StringBuilder();
                    Integer fileNameEntriesAmount = (Integer)testNames.get(testName);
                    if (fileNameEntriesAmount > 1) {
                        fileNameSuffix.append("_").append(fileNameEntriesAmount);
                    }
                    File reportDir = new File(testcase.getReport());
                    File zipFileFolder = new File(FilesHandler.getOutputFilePath(taskContext));
                    zipFileFolder.mkdirs();
                    File reportZipFile = new File(zipFileFolder, testName + fileNameSuffix + ".zip");
                    String resultArtifactName = String.format(resultArtifactNameFormat, testName);
                    ResultInfoItem resultItem = new ResultInfoItem(testName, reportDir, reportZipFile, resultArtifactName);
                    resultItems.add(resultItem);
                }
            }
        }
        catch (JAXBException ex) {
            logger.addBuildLogEntry(ex.getMessage());
            logger.addBuildLogEntry("Failed to parse test results file (" + results.getName() + ").");
        }
        return resultItems;
    }

    private static boolean isInFilter(Testcase testcase, ResultTypeFilter filter) {
        if (filter == ResultTypeFilter.All) {
            return true;
        }
        String status = testcase.getStatus();
        return filter == ResultTypeFilter.FAILED && status.equals(UFTConstants.TEST_STATUS_FAIL.getValue());
    }
}

