/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.helpers;

import com.adm.utils.uft.Aes256Encryptor;
import com.adm.utils.uft.StringUtils;
import com.adm.utils.uft.enums.AlmRunMode;
import com.adm.utils.uft.enums.RunType;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class LauncherParamsBuilder {
    private final List<String> requiredParameters = Arrays.asList("almRunHost", "almServerUrl", "almUserName", "almPassword", "almDomain", "almProject", "almRunMode", "almTimeout", "almRunHost");
    private Properties properties = new Properties();
    private final Aes256Encryptor aes256Encryptor;

    public LauncherParamsBuilder(@NotNull Aes256Encryptor aes256Encryptor) {
        this.aes256Encryptor = aes256Encryptor;
    }

    private void setParamValue(String paramName, String paramValue) {
        if (StringUtils.isNullOrEmpty(paramValue)) {
            if (!this.requiredParameters.contains(paramName)) {
                this.properties.remove(paramName);
            } else {
                this.properties.put(paramName, "");
            }
        } else {
            this.properties.put(paramName, paramValue);
        }
    }

    public void setMobileUseSSL(int type) {
        this.setParamValue("MobileUseSSL", String.valueOf(type));
    }

    public void setMobileUseProxy(int proxy) {
        this.setParamValue("MobileUseProxy", String.valueOf(proxy));
    }

    public void setMobileProxyType(int type) {
        this.setParamValue("MobileProxyType", String.valueOf(type));
    }

    public void setMobileProxySetting_Address(String proxyAddress) {
        this.setParamValue("MobileProxySetting_Address", proxyAddress);
    }

    public void setMobileProxySetting_Authentication(int authentication) {
        this.setParamValue("MobileProxySetting_Authentication", String.valueOf(authentication));
    }

    public void setProxyHost(String proxyHost) {
        this.setParamValue("proxyHost", proxyHost);
    }

    public void setProxyPort(String proxyPort) {
        this.setParamValue("proxyPort", proxyPort);
    }

    public void setMobileProxySetting_UserName(String proxyUserName) {
        this.setParamValue("MobileProxySetting_UserName", proxyUserName);
    }

    public void setMobileProxySetting_Password(String proxyPassword) {
        try {
            String proxyPass = this.aes256Encryptor.Encrypt(proxyPassword);
            this.properties.put("MobileProxySetting_Password", proxyPass);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRunType(RunType runType) {
        this.setParamValue("runType", runType.getValue());
    }

    public void setAlmServerUrl(String almServerUrl) {
        this.setParamValue("almServerUrl", almServerUrl);
    }

    public void setAlmSSO(String almSSO) {
        this.setParamValue("almSSO", almSSO);
    }

    public void setAlmClientID(String almClientID) {
        this.setParamValue("clientID", almClientID);
    }

    public void setAlmApiKeySecret(String almApiKeySecret) {
        try {
            this.setParamValue("apiKeySecret", this.aes256Encryptor.Encrypt(almApiKeySecret));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAlmUserName(String almUserName) {
        this.setParamValue("almUserName", almUserName);
    }

    public void setAlmPassword(String almPassword) {
        try {
            String encAlmPass = this.aes256Encryptor.Encrypt(almPassword);
            this.properties.put("almPassword", encAlmPass);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAlmDomain(String almDomain) {
        this.setParamValue("almDomain", almDomain);
    }

    public void setAlmProject(String almProject) {
        this.setParamValue("almProject", almProject);
    }

    public void setAlmRunMode(AlmRunMode almRunMode) {
        this.properties.put("almRunMode", almRunMode != null ? almRunMode.toString() : "");
    }

    public void setAlmTimeout(String almTimeout) {
        this.setParamValue("almTimeout", almTimeout);
    }

    public void setTestSet(int index, String testSet) {
        this.setParamValue("TestSet" + index, testSet);
    }

    public void setAlmTestSet(String testSets) {
        this.setParamValue("almTestSets", testSets);
    }

    public void setAlmRunHost(String host) {
        this.setParamValue("almRunHost", host);
    }

    public void setTest(int index, String test) {
        this.setParamValue("Test" + index, test);
    }

    public void setPerScenarioTimeOut(String perScenarioTimeOut) {
        this.setParamValue("PerScenarioTimeOut", perScenarioTimeOut);
    }

    public void setFsTimeout(String fsTimeout) {
        this.setParamValue("fsTimeout", fsTimeout);
    }

    public void setFileSystemPassword(String oriPass) {
        try {
            String encPass = this.aes256Encryptor.Encrypt(oriPass);
            this.properties.put("MobilePassword", encPass);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMobileInfo(String mobileInfo) {
        this.setParamValue("mobileinfo", mobileInfo);
    }

    public void setServerUrl(String serverUrl) {
        this.setParamValue("MobileHostAddress", serverUrl);
    }

    public void setUserName(String username) {
        this.setParamValue("MobileUserName", username);
    }

    public Properties getProperties() {
        return this.properties;
    }
}

