/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.helpers;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import org.jetbrains.annotations.NotNull;

public class HpTasksArtifactRegistrator {
    private static final String HP_UFT_PREFIX = "UFT_Build_";

    public void registerCommonArtifact(@NotNull Job job, @NotNull I18nBean i18nBean, @NotNull ArtifactDefinitionManager artifactDefinitionManager) {
        if (job == null || i18nBean == null || artifactDefinitionManager == null) {
            return;
        }
        String name = i18nBean.getText("OpenText Tasks Artifact Definition");
        String ARTIFACT_COPY_PATTERN = "UFT_Build_${bamboo.buildNumber}/**";
        if (artifactDefinitionManager.findArtifactDefinition((ImmutablePlan)job, name) == null) {
            ArtifactDefinitionImpl artifactDefinition = new ArtifactDefinitionImpl(name, "", ARTIFACT_COPY_PATTERN);
            artifactDefinition.setProducerJob(job);
            boolean isMutativeKeyWasChanged = false;
            String HTTP_REQUEST_IS_MUTATIVE_KEY = "bamboo.http.request.isMutative";
            if (XsrfUtils.areMutativeGetsForbiddenByConfig() && !XsrfUtils.noRequestOrRequestCanMutateState() && !RequestCacheThreadLocal.canRequestMutateState()) {
                isMutativeKeyWasChanged = true;
                RequestCacheThreadLocal.getRequestCache().put(HTTP_REQUEST_IS_MUTATIVE_KEY, true);
            }
            artifactDefinitionManager.saveArtifactDefinition((ArtifactDefinition)artifactDefinition);
            if (isMutativeKeyWasChanged) {
                RequestCacheThreadLocal.getRequestCache().put(HTTP_REQUEST_IS_MUTATIVE_KEY, false);
            }
        }
    }
}

