/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.sv.ui;

import com.adm.utils.sv.SVExecutorUtil;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.Map;

public class SVDeployTaskConfigurator
extends AbstractTaskConfigurator {
    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("url", params.getString("url"));
        config.put("userName", params.getString("userName"));
        config.put("password", params.getString("password"));
        config.put("serviceNameOrId", params.getString("serviceNameOrId"));
        config.put("projectPath", params.getString("projectPath"));
        config.put("projectPassword", params.getString("projectPassword"));
        config.put("force", params.getString("force"));
        config.put("firstSuitableAgentFallback", params.getString("firstSuitableAgentFallback"));
        return config;
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        String projectPathValue;
        super.validate(params, errorCollection);
        String urlValue = params.getString("url");
        if (!SVExecutorUtil.validInput(urlValue)) {
            errorCollection.addError("url", "Error: Management Endpoint URL cannot be empty");
        }
        if (!SVExecutorUtil.validInput(projectPathValue = params.getString("projectPath"))) {
            errorCollection.addError("projectPath", "Error: Project path cannot be empty");
        }
    }

    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContext(context, taskDefinition);
    }

    private void populateContext(Map<String, Object> context, TaskDefinition taskDefinition) {
        Map configuration = taskDefinition.getConfiguration();
        context.put("url", configuration.get("url"));
        context.put("userName", configuration.get("userName"));
        context.put("password", configuration.get("password"));
        context.put("serviceNameOrId", configuration.get("serviceNameOrId"));
        context.put("projectPath", configuration.get("projectPath"));
        context.put("projectPassword", configuration.get("projectPassword"));
        context.put("force", configuration.get("force"));
        context.put("firstSuitableAgentFallback", configuration.get("firstSuitableAgentFallback"));
    }
}

