/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.sv.ui;

import com.adm.utils.sv.SVExecutorUtil;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import java.util.LinkedHashMap;
import java.util.Map;

public class SVChangeModeTaskConfigurator
extends AbstractTaskConfigurator {
    private static final Map SERVICE_SELECTION = new LinkedHashMap();
    private static final Map DATA_MODEL = new LinkedHashMap();
    private static final Map PERFORMANCE_MODEL = new LinkedHashMap();
    private static final Map SERVICE_MODE = new LinkedHashMap();

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("url", params.getString("url"));
        config.put("userName", params.getString("userName"));
        config.put("password", params.getString("password"));
        config.put("serviceSelection", params.getString("serviceSelection"));
        config.put("serviceNameOrId", params.getString("serviceNameOrId"));
        config.put("projectPath", params.getString("projectPath"));
        config.put("projectPassword", params.getString("projectPassword"));
        config.put("serviceMode", params.getString("serviceMode"));
        config.put("dataModel", params.getString("dataModel"));
        config.put("dmNameOrId", params.getString("dmNameOrId"));
        config.put("performanceModel", params.getString("performanceModel"));
        config.put("pmNameOrId", params.getString("pmNameOrId"));
        config.put("force", params.getString("force"));
        return config;
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        String PMNameOrIdValue;
        String DMNameOrIdValue;
        String projectPathValue;
        super.validate(params, errorCollection);
        String urlValue = params.getString("url");
        if (!SVExecutorUtil.validInput(urlValue)) {
            errorCollection.addError("url", "Error: Management Endpoint URL cannot be empty");
        }
        if ("SERVICE".equals(params.getString("serviceSelection"))) {
            String serviceNameOrIdValue = params.getString("serviceNameOrId");
            if (!SVExecutorUtil.validInput(serviceNameOrIdValue)) {
                errorCollection.addError("serviceNameOrId", "Error: Service name or id must be set");
            }
        } else if ("PROJECT".equals(params.getString("serviceSelection")) && !SVExecutorUtil.validInput(projectPathValue = params.getString("projectPath"))) {
            errorCollection.addError("projectPath", "Error: Project path cannot be empty");
        }
        if ("BY_NAME".equals(params.getString("dataModel")) && !SVExecutorUtil.validInput(DMNameOrIdValue = params.getString("dmNameOrId"))) {
            errorCollection.addError("dmNameOrId", "Error: Data model cannot be empty if 'Specific' model is selected");
        }
        if ("BY_NAME".equals(params.getString("performanceModel")) && !SVExecutorUtil.validInput(PMNameOrIdValue = params.getString("pmNameOrId"))) {
            errorCollection.addError("pmNameOrId", "Error: Performance model cannot be empty if 'Specific' model is selected");
        }
    }

    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateContextForLists(context);
        context.put("serviceSelection", "SERVICE");
        context.put("serviceMode", "STAND_BY");
        context.put("dataModel", "DEFAULT");
        context.put("performanceModel", "NONE");
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContext(context, taskDefinition);
        this.populateContextForLists(context);
    }

    private void populateContextForLists(Map<String, Object> context) {
        I18nBean textProvider = this.getI18nBean();
        if (SERVICE_SELECTION.isEmpty()) {
            SERVICE_SELECTION.put("SERVICE", textProvider.getText("sv.param.label.selectedServiceOnly"));
            SERVICE_SELECTION.put("PROJECT", textProvider.getText("sv.param.label.allServicesFromProject"));
            SERVICE_SELECTION.put("ALL_DEPLOYED", textProvider.getText("sv.param.label.allServicesDeployedOnServer"));
        }
        if (DATA_MODEL.isEmpty()) {
            DATA_MODEL.put("DEFAULT", textProvider.getText("sv.param.label.dmDefault"));
            DATA_MODEL.put("NONE", textProvider.getText("sv.param.label.noneDataModel"));
            DATA_MODEL.put("BY_NAME", textProvider.getText("sv.param.label.dmSpecific"));
        }
        if (PERFORMANCE_MODEL.isEmpty()) {
            PERFORMANCE_MODEL.put("NONE", textProvider.getText("sv.param.label.nonePerformanceModel"));
            PERFORMANCE_MODEL.put("OFFLINE", textProvider.getText("sv.param.label.offline"));
            PERFORMANCE_MODEL.put("DEFAULT", textProvider.getText("sv.param.label.defaultPerformanceModel"));
            PERFORMANCE_MODEL.put("BY_NAME", textProvider.getText("sv.param.label.pmSpecific"));
        }
        if (SERVICE_MODE.isEmpty()) {
            SERVICE_MODE.put("STAND_BY", textProvider.getText("sv.param.label.standBy"));
            SERVICE_MODE.put("SIMULATING", textProvider.getText("sv.param.label.simulate"));
            SERVICE_MODE.put("LEARNING", textProvider.getText("sv.param.label.learn"));
        }
        context.put("SVServiceSelectionMap", SERVICE_SELECTION);
        context.put("SVDataModelMap", DATA_MODEL);
        context.put("SVPerformanceModelMap", PERFORMANCE_MODEL);
        context.put("SVServiceModeMap", SERVICE_MODE);
    }

    private void populateContext(Map<String, Object> context, TaskDefinition taskDefinition) {
        Map configuration = taskDefinition.getConfiguration();
        context.put("url", configuration.get("url"));
        context.put("userName", configuration.get("userName"));
        context.put("password", configuration.get("password"));
        context.put("serviceSelection", configuration.get("serviceSelection"));
        context.put("serviceNameOrId", configuration.get("serviceNameOrId"));
        context.put("projectPath", configuration.get("projectPath"));
        context.put("projectPassword", configuration.get("projectPassword"));
        context.put("serviceMode", configuration.get("serviceMode"));
        context.put("dataModel", configuration.get("dataModel"));
        context.put("dmNameOrId", configuration.get("dmNameOrId"));
        context.put("performanceModel", configuration.get("performanceModel"));
        context.put("pmNameOrId", configuration.get("pmNameOrId"));
        context.put("force", configuration.get("force"));
    }
}

