/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.sv.model;

import org.apache.commons.lang.StringUtils;

public class SvPerformanceModelSelection {
    protected SelectionType selectionType;
    protected String performanceModel;

    public SvPerformanceModelSelection(SelectionType selectionType, String performanceModel) {
        this.selectionType = selectionType;
        this.performanceModel = StringUtils.trim(performanceModel);
    }

    public SelectionType getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(String selectionType) {
        if ("BY_NAME".equals(selectionType)) {
            this.selectionType = SelectionType.BY_NAME;
        } else if ("NONE".equals(selectionType)) {
            this.selectionType = SelectionType.NONE;
        } else if ("DEFAULT".equals(selectionType)) {
            this.selectionType = SelectionType.DEFAULT;
        } else if ("OFFLINE".equals(selectionType)) {
            this.selectionType = SelectionType.OFFLINE;
        }
    }

    public String getPerformanceModel() {
        return StringUtils.isNotBlank(this.performanceModel) ? this.performanceModel : null;
    }

    public boolean isSelected(String type) {
        return SelectionType.valueOf(type) == this.selectionType;
    }

    public boolean isNoneSelected() {
        return this.selectionType == SelectionType.NONE;
    }

    public boolean isDefaultSelected() {
        return this.selectionType == SelectionType.DEFAULT;
    }

    public String toString() {
        switch (this.selectionType) {
            case BY_NAME: {
                return this.performanceModel;
            }
            case NONE: {
                return "<none>";
            }
            case OFFLINE: {
                return "<offline>";
            }
        }
        return "<default>";
    }

    public String getSelectedModelName() {
        switch (this.selectionType) {
            case BY_NAME: {
                return this.performanceModel;
            }
            case OFFLINE: {
                return "Offline";
            }
        }
        return null;
    }

    public static enum SelectionType {
        BY_NAME,
        NONE,
        OFFLINE,
        DEFAULT;

    }
}

