/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.sv.model;

import org.apache.commons.lang.StringUtils;

public class SvDataModelSelection {
    private SelectionType selectionType;
    private String dataModel;

    public SvDataModelSelection(SelectionType selectionType, String dataModel) {
        this.selectionType = selectionType;
        this.dataModel = StringUtils.trim(dataModel);
    }

    public SelectionType getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(String selectionType) {
        if ("BY_NAME".equals(selectionType)) {
            this.selectionType = SelectionType.BY_NAME;
        } else if ("NONE".equals(selectionType)) {
            this.selectionType = SelectionType.NONE;
        } else if ("DEFAULT".equals(selectionType)) {
            this.selectionType = SelectionType.DEFAULT;
        }
    }

    public String getDataModel() {
        return StringUtils.isNotBlank(this.dataModel) ? this.dataModel : null;
    }

    public boolean isSelected(String type) {
        return SelectionType.valueOf(type) == this.selectionType;
    }

    public boolean isNoneSelected() {
        return this.selectionType == SelectionType.NONE;
    }

    public boolean isDefaultSelected() {
        return this.selectionType == SelectionType.DEFAULT;
    }

    public String toString() {
        switch (this.selectionType) {
            case BY_NAME: {
                return this.dataModel;
            }
            case NONE: {
                return "<none>";
            }
        }
        return "<default>";
    }

    public String getSelectedModelName() {
        switch (this.selectionType) {
            case BY_NAME: {
                return this.dataModel;
            }
        }
        return null;
    }

    public static enum SelectionType {
        BY_NAME,
        NONE,
        DEFAULT;

    }
}

