/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.performancecenter.impl;

import com.adm.bamboo.plugin.performancecenter.impl.PcClientBamboo;
import com.adm.bamboo.plugin.performancecenter.impl.PcModelBamboo;
import com.atlassian.bamboo.build.fileserver.DefaultBuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.TaskContext;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcException;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunEventLog;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunEventLogRecord;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunResponse;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PostRunAction;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.RunState;
import java.io.File;
import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class PcComponentsImpl {
    HttpContext context = new BasicHttpContext();
    HttpClient client = null;
    TaskContext taskContext;
    PcModelBamboo pcModel;
    PcClientBamboo pcClient;
    PcRunResponse response = null;
    String pcReportFile;
    BuildLogger buildLogger;

    public PcComponentsImpl(TaskContext taskContext, BuildLogger buildLogger, String pcServerName, String almUserName, String almPassword, String almDomain, String almProject, String testId, String autoTestInstanceID, String testInstanceId, String timeslotDurationHours, String timeslotDurationMinutes, PostRunAction postRunAction, boolean vudsMode, boolean sla, String description, String addRunToTrendReport, String trendReportId, boolean HTTPSProtocol, String proxyOutURL, String proxyUser, String proxyPassword, boolean authenticateWithToken) {
        this.taskContext = taskContext;
        BasicCookieStore cookieStore = new BasicCookieStore();
        this.context.setAttribute("http.cookie-store", cookieStore);
        this.buildLogger = buildLogger;
        PoolingClientConnectionManager cxMgr = new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault());
        cxMgr.setMaxTotal(100);
        cxMgr.setDefaultMaxPerRoute(20);
        this.client = new DefaultHttpClient(cxMgr);
        this.pcModel = new PcModelBamboo(pcServerName, almUserName, almPassword, almDomain, almProject, testId, autoTestInstanceID, testInstanceId, timeslotDurationHours, timeslotDurationMinutes, postRunAction, vudsMode, sla, description, addRunToTrendReport, trendReportId, HTTPSProtocol, proxyOutURL, proxyUser, proxyPassword, authenticateWithToken);
        this.pcClient = new PcClientBamboo(this.pcModel, taskContext, buildLogger);
    }

    public Boolean pcAuthenticate() throws IOException, PcException {
        Boolean loggedIn = false;
        loggedIn = this.pcClient.login();
        return loggedIn;
    }

    public String startRun() throws IOException, PcException, InterruptedException {
        int runId = 0;
        String eventLogString = "";
        boolean trendReportReady = false;
        try {
            runId = this.pcClient.startRun();
            this.response = this.pcClient.waitForRunCompletion(runId);
            RunState runState = RunState.get(this.response.getRunState());
            if (this.response != null && runState == RunState.FINISHED) {
                DefaultBuildDirectoryManager defaultBuildDirectoryManager = new DefaultBuildDirectoryManager();
                this.pcReportFile = this.pcClient.publishRunReport(runId, String.valueOf(this.taskContext.getWorkingDirectory()));
                this.buildLogger.addBuildLogEntry("View analysis report of run: " + runId + ", in the Artifacts Tab.");
                if ("USE_ID".equals(this.pcModel.getAddRunToTrendReport()) && this.pcModel.getTrendReportId() != null && runState != RunState.RUN_FAILURE) {
                    this.pcClient.addRunToTrendReport(runId, this.pcModel.getTrendReportId());
                    this.pcClient.waitForRunToPublishOnTrendReport(runId, this.pcModel.getTrendReportId());
                    this.pcClient.downloadTrendReportAsPdf(this.pcModel.getTrendReportId(), this.getTrendReportsDirectory(runId));
                    trendReportReady = true;
                }
                if ("ASSOCIATED".equals(this.pcModel.getAddRunToTrendReport()) && runState != RunState.RUN_FAILURE) {
                    this.pcClient.addRunToTrendReport(runId, this.pcModel.getTrendReportId());
                    this.pcClient.waitForRunToPublishOnTrendReport(runId, this.pcModel.getTrendReportId());
                    this.pcClient.downloadTrendReportAsPdf(this.pcModel.getTrendReportId(), this.getTrendReportsDirectory(runId));
                    trendReportReady = true;
                }
            } else if (this.response != null && runState.ordinal() > RunState.FINISHED.ordinal()) {
                PcRunEventLog eventLog = this.pcClient.getRunEventLog(runId);
                eventLogString = this.buildEventLogString(eventLog);
            }
        }
        catch (PcException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw e;
        }
        return String.valueOf(runId);
    }

    public Boolean isSlaStatusPassed() {
        if (this.response != null) {
            return this.response.getRunSLAStatus().equalsIgnoreCase("passed");
        }
        return false;
    }

    public String getRunSLAStatus() {
        if (this.response != null) {
            return this.response.getRunSLAStatus();
        }
        return "unknown";
    }

    private String getTrendReportsDirectory(int runId) {
        return String.valueOf(this.taskContext.getWorkingDirectory()) + File.separator + "Reports" + File.separator + "TrendReports";
    }

    private String buildEventLogString(PcRunEventLog eventLog) {
        String logFormat = "%-5s | %-7s | %-19s | %s\n";
        StringBuilder eventLogStr = new StringBuilder("Event Log:\n\n" + String.format(logFormat, "ID", "TYPE", "TIME", "DESCRIPTION"));
        for (PcRunEventLogRecord record : eventLog.getRecordsList()) {
            eventLogStr.append(String.format(logFormat, record.getID(), record.getType(), record.getTime(), record.getDescription()));
        }
        return eventLogStr.toString();
    }
}

