/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.service;

import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.AgentConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.AgentConfigurations;
import com.microfocus.sv.svconfigurator.service.ServiceAgentUpdaterBase;
import java.text.MessageFormat;
import java.util.Map;

class AgentRemappingServiceUpdater
extends ServiceAgentUpdaterBase {
    protected Map<String, String> agentRemapping;

    protected String getMappedAgentId(String sourceAgentId) {
        if (this.agentRemapping != null && this.agentRemapping.containsKey(sourceAgentId)) {
            return this.agentRemapping.get(sourceAgentId);
        }
        return null;
    }

    public AgentRemappingServiceUpdater(AgentConfigurations agentConfigurations, Map<String, String> agentRemapping) {
        super(agentConfigurations);
        this.agentRemapping = agentRemapping;
    }

    @Override
    public String getMappedServerAgentId(String sourceAgentType, String sourceAgentId, String sourceAgentName) throws CommandExecutorException {
        String mappedAgentId = this.getMappedAgentId(sourceAgentId);
        if (mappedAgentId == null) {
            return sourceAgentId;
        }
        if (!this.agentConfigurationsById.containsKey(mappedAgentId) || !((AgentConfiguration)this.agentConfigurationsById.get(mappedAgentId)).getType().equals(sourceAgentType)) {
            throw new CommandExecutorException(MessageFormat.format("No available agent of ID [{0}] and type [{1}] found on the server. Please check the agent has the correct type and also note that Agent ID is case sensitive.", mappedAgentId, sourceAgentType));
        }
        return mappedAgentId;
    }
}

