/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor;

import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.processor.IUndeployProcessor;
import com.microfocus.sv.svconfigurator.processor.UndeployProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutorFactory;

public class UndeployProcessor
implements IUndeployProcessor {
    private ICommandExecutorFactory commandExecutorFactory;

    public UndeployProcessor(ICommandExecutorFactory commandExecutorFactory) {
        this.commandExecutorFactory = commandExecutorFactory;
    }

    @Override
    public ICommandExecutorFactory getCommandExecutorFactory() {
        return this.commandExecutorFactory;
    }

    @Override
    public void process(UndeployProcessorInput input, ICommandExecutor exec) throws CommunicatorException, CommandExecutorException {
        IService svc;
        exec.setForce(input.isForce());
        IProject proj = input.getProject();
        String svcIdent = input.getService();
        IService iService = svc = svcIdent == null ? null : exec.findService(input.getService(), proj);
        if (svc != null) {
            exec.undeployService(svc);
        } else {
            if (proj == null) {
                throw new IllegalArgumentException("No project was specified");
            }
            exec.undeploy(proj);
        }
    }
}

