/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.core.impl.jaxb;

import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.helper.ReferenceElement;
import com.microfocus.sv.svconfigurator.processor.printer.NonPrintable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="virtualServiceRuntimeConfiguration", namespace="http://hp.com/SOAQ/ServiceVirtualization/2010/")
@XmlType(propOrder={"service", "dataModel", "perfModel", "clientId", "runtimeMode", "logMessages", "deploymentErrorMessage", "deploymentState"})
public class ServiceRuntimeConfiguration
implements Cloneable {
    public static final String NAMESPACE = "http://hp.com/SOAQ/ServiceVirtualization/2010/";
    private String id;
    @NonPrintable
    private ReferenceElement service;
    private ReferenceElement dataModel;
    private ReferenceElement perfModel;
    private String clientId;
    private RuntimeMode runtimeMode;
    @NonPrintable
    private LogMessages logMessages;
    private String deploymentErrorMessage;
    private DeploymentState deploymentState;

    public ServiceRuntimeConfiguration() {
    }

    public ServiceRuntimeConfiguration(IService svc, RuntimeMode runtimeMode, boolean logging, DeploymentState deploymentState) {
        this.runtimeMode = runtimeMode;
        this.deploymentState = deploymentState;
        this.setServiceId(svc.getId());
        this.setLogging(logging);
    }

    public String toString() {
        return "ServiceRuntimeConfiguration[\truntimeId: " + this.getId() + "\n\tserviceId: " + (this.service == null ? "" : this.service.getRef()) + "\n\tdataModelId: " + this.getDataModelId() + "\n\tperfModelId: " + this.getPerfModelId() + "\n\tclientId: " + this.getClientId() + "\n\truntimeMode: " + (Object)((Object)this.runtimeMode) + "\n\tlogMessages: " + (Object)((Object)this.logMessages) + "\n\tdeploymentErrorMessage: " + this.deploymentErrorMessage + "\n]\tdeploymentState: " + (Object)((Object)this.deploymentState) + "\n]";
    }

    public ServiceRuntimeConfiguration clone() {
        ServiceRuntimeConfiguration res = new ServiceRuntimeConfiguration();
        res.setId(this.getId());
        res.setServiceId(this.getServiceId());
        res.setDataModelId(this.getDataModelId());
        res.setPerfModelId(this.getPerfModelId());
        res.setClientId(this.getClientId());
        res.setRuntimeMode(this.getRuntimeMode());
        res.setLogging(this.isLogging());
        res.setDeploymentState(this.getDeploymentState());
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceRuntimeConfiguration)) {
            return false;
        }
        ServiceRuntimeConfiguration that = (ServiceRuntimeConfiguration)o;
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        if (this.dataModel != null ? !this.dataModel.equals(that.dataModel) : that.dataModel != null) {
            return false;
        }
        if (this.deploymentState != that.deploymentState) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.logMessages != that.logMessages) {
            return false;
        }
        if (this.perfModel != null ? !this.perfModel.equals(that.perfModel) : that.perfModel != null) {
            return false;
        }
        if (this.runtimeMode != that.runtimeMode) {
            return false;
        }
        if (this.deploymentErrorMessage != null ? !this.deploymentErrorMessage.equals(that.deploymentErrorMessage) : that.deploymentErrorMessage != null) {
            return false;
        }
        return !(this.service == null ? that.service != null : !this.service.equals(that.service));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
        result = 31 * result + (this.dataModel != null ? this.dataModel.hashCode() : 0);
        result = 31 * result + (this.perfModel != null ? this.perfModel.hashCode() : 0);
        result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
        result = 31 * result + (this.runtimeMode != null ? this.runtimeMode.hashCode() : 0);
        result = 31 * result + (this.logMessages != null ? this.logMessages.hashCode() : 0);
        result = 31 * result + (this.deploymentErrorMessage != null ? this.deploymentErrorMessage.hashCode() : 0);
        result = 31 * result + (this.deploymentState != null ? this.deploymentState.hashCode() : 0);
        return result;
    }

    @XmlTransient
    public String getServiceId() {
        return this.service == null ? null : this.service.getRef();
    }

    public void setServiceId(String serviceId) {
        this.service = new ReferenceElement(serviceId);
    }

    @XmlTransient
    public boolean isLogging() {
        return LogMessages.TRUE.equals((Object)this.logMessages);
    }

    public void setLogging(boolean logging) {
        this.logMessages = logging ? LogMessages.TRUE : LogMessages.FALSE;
    }

    @XmlTransient
    public String getDataModelId() {
        return this.dataModel == null ? null : this.dataModel.getRef();
    }

    public void setDataModelId(String id) {
        this.dataModel = id == null ? null : new ReferenceElement(id);
    }

    @XmlTransient
    public String getPerfModelId() {
        return this.perfModel == null ? null : this.perfModel.getRef();
    }

    public void setPerfModelId(String id) {
        this.perfModel = id == null ? null : new ReferenceElement(id);
    }

    public boolean isLocked() {
        return this.clientId != null && !this.clientId.isEmpty();
    }

    public boolean isLockedForMe(String myId) {
        return this.isLocked() && !this.clientId.equals(myId);
    }

    @XmlTransient
    public RuntimeMode getDisplayRuntimeMode() {
        if (this.deploymentState != DeploymentState.READY) {
            return RuntimeMode.OFFLINE;
        }
        return this.runtimeMode == RuntimeMode.STAND_BY && this.getPerfModelId() != null && this.getDataModelId() == null ? RuntimeMode.SIMULATING : this.runtimeMode;
    }

    @XmlAttribute(name="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name="service", namespace="http://hp.com/SOAQ/ServiceVirtualization/2010/")
    public ReferenceElement getService() {
        return this.service;
    }

    public void setService(ReferenceElement service) {
        this.service = service;
    }

    @XmlElement(name="dataModel", namespace="http://hp.com/SOAQ/ServiceVirtualization/2010/", nillable=false, required=false)
    public ReferenceElement getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(ReferenceElement dataModel) {
        this.dataModel = dataModel;
    }

    @XmlElement(name="performanceModel", namespace="http://hp.com/SOAQ/ServiceVirtualization/2010/", nillable=false, required=false)
    public ReferenceElement getPerfModel() {
        return this.perfModel;
    }

    public void setPerfModel(ReferenceElement perfModel) {
        this.perfModel = perfModel;
    }

    @XmlElement(name="clientId", namespace="http://hp.com/SOAQ/ServiceVirtualization/2010/", nillable=false, required=false)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @XmlElement(name="serviceRuntimeMode", namespace="http://hp.com/SOAQ/ServiceVirtualization/2010/")
    public RuntimeMode getRuntimeMode() {
        return this.runtimeMode;
    }

    public void setRuntimeMode(RuntimeMode runtimeMode) {
        this.runtimeMode = runtimeMode;
    }

    @XmlElement(name="logMessages", namespace="http://hp.com/SOAQ/ServiceVirtualization/2010/")
    public LogMessages getLogMessages() {
        return this.logMessages;
    }

    public void setLogMessages(LogMessages logMessages) {
        this.logMessages = logMessages;
    }

    @XmlElement(name="virtualServiceDeploymentState", namespace="http://hp.com/SOAQ/ServiceVirtualization/2010/")
    public DeploymentState getDeploymentState() {
        return this.deploymentState;
    }

    public void setDeploymentState(DeploymentState deploymentState) {
        this.deploymentState = deploymentState;
    }

    @XmlElement(name="deploymentErrorMessage", namespace="http://hp.com/SOAQ/ServiceVirtualization/2010/")
    public String getDeploymentErrorMessage() {
        return this.deploymentErrorMessage;
    }

    public void setDeploymentErrorMessage(String deploymentErrorMessage) {
        this.deploymentErrorMessage = deploymentErrorMessage;
    }

    @XmlEnum
    public static enum LogMessages {
        TRUE,
        FALSE;

    }

    @XmlEnum
    public static enum DeploymentState {
        READY(false),
        DOWN(false),
        DOWNING(true),
        READYING(true);

        private boolean inProgress;

        private DeploymentState(boolean inProgress) {
            this.inProgress = inProgress;
        }

        public boolean isInProgress() {
            return this.inProgress;
        }
    }

    @XmlEnum
    public static enum RuntimeMode {
        OFFLINE,
        SIMULATING,
        STAND_BY,
        LEARNING;

    }

    public static class XmlConstants {
        public static final String RUNTIME_OFFLINE = "Offline";
        public static final String RUNTIME_SIMULATING = "Simulating";
        public static final String RUNTIME_PASS_THROUGH = "PassThrough";
        public static final String RUNTIME_RECORDING = "Recording";
        public static final String STATE_READY = "Ready";
        public static final String STATE_DOWN = "Down";
        public static final String STATE_DOWNING = "Downing";
        public static final String STATE_READYING = "Readying";
    }
}

