/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.token;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.internal.EvaluationContext;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class EvaluationContextImpl
implements EvaluationContext {
    private final Configuration configuration;
    private final Object valueResult;
    private final Object pathResult;
    private final Path path;
    private final Object rootDocument;
    private final HashMap<Path, Object> documentEvalCache = new HashMap();
    private int resultIndex = 0;

    public EvaluationContextImpl(Path path, Object rootDocument, Configuration configuration) {
        Utils.notNull(path, "path can not be null", new Object[0]);
        Utils.notNull(rootDocument, "root can not be null", new Object[0]);
        Utils.notNull(configuration, "configuration can not be null", new Object[0]);
        this.path = path;
        this.rootDocument = rootDocument;
        this.configuration = configuration;
        this.valueResult = configuration.jsonProvider().createArray();
        this.pathResult = configuration.jsonProvider().createArray();
    }

    public HashMap<Path, Object> documentEvalCache() {
        return this.documentEvalCache;
    }

    public void addResult(String path, Object model) {
        this.configuration.jsonProvider().setProperty(this.valueResult, this.resultIndex, model);
        this.configuration.jsonProvider().setProperty(this.pathResult, this.resultIndex, path);
        ++this.resultIndex;
    }

    public JsonProvider jsonProvider() {
        return this.configuration.jsonProvider();
    }

    public Set<Option> options() {
        return this.configuration.getOptions();
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public Object rootDocument() {
        return this.rootDocument;
    }

    @Override
    public <T> T getValue() {
        if (this.path.isDefinite()) {
            if (this.resultIndex == 0) {
                throw new PathNotFoundException("No results for path: " + this.path.toString());
            }
            return (T)this.jsonProvider().getArrayIndex(this.valueResult, 0);
        }
        return (T)this.valueResult;
    }

    @Override
    public <T> T getPath() {
        if (this.resultIndex == 0) {
            throw new PathNotFoundException("No results for path: " + this.path.toString());
        }
        return (T)this.pathResult;
    }

    @Override
    public List<String> getPathList() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.resultIndex > 0) {
            Iterable<?> objects = this.configuration.jsonProvider().toIterable(this.pathResult);
            for (Object o : objects) {
                res.add((String)o);
            }
        }
        return res;
    }
}

