/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.spi.mapper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.internal.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.internal.spi.mapper.MapperBase;
import com.jayway.jsonpath.spi.mapper.MappingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GsonMapper
extends MapperBase {
    public GsonMapper() {
        this.register(JsonPrimitive.class, Integer.class);
        this.register(JsonPrimitive.class, Long.class);
        this.register(JsonPrimitive.class, Float.class);
        this.register(JsonPrimitive.class, Double.class);
        this.register(JsonPrimitive.class, BigDecimal.class);
        this.register(JsonPrimitive.class, BigInteger.class);
        this.register(JsonPrimitive.class, Date.class);
        this.register(JsonPrimitive.class, String.class);
        this.register(JsonPrimitive.class, Boolean.class);
        this.register(JsonArray.class, List.class);
        this.register(JsonObject.class, Map.class);
    }

    @Override
    public Object convert(Object src, Class<?> srcType, Class<?> targetType, Configuration conf) {
        this.assertValidConversion(src, srcType, targetType);
        if (src == null || src.getClass().equals(JsonNull.class)) {
            return null;
        }
        if (JsonPrimitive.class.isAssignableFrom(srcType)) {
            JsonPrimitive primitive = (JsonPrimitive)src;
            if (targetType.equals(Long.class)) {
                return primitive.getAsLong();
            }
            if (targetType.equals(Integer.class)) {
                return primitive.getAsInt();
            }
            if (targetType.equals(BigInteger.class)) {
                return primitive.getAsBigInteger();
            }
            if (targetType.equals(Byte.class)) {
                return primitive.getAsByte();
            }
            if (targetType.equals(BigDecimal.class)) {
                return primitive.getAsBigDecimal();
            }
            if (targetType.equals(Double.class)) {
                return primitive.getAsDouble();
            }
            if (targetType.equals(Float.class)) {
                return Float.valueOf(primitive.getAsFloat());
            }
            if (targetType.equals(String.class)) {
                return primitive.getAsString();
            }
            if (targetType.equals(Boolean.class)) {
                return primitive.getAsBoolean();
            }
            if (targetType.equals(Date.class)) {
                if (primitive.isNumber()) {
                    return new Date(primitive.getAsLong());
                }
                if (primitive.isString()) {
                    try {
                        return DateFormat.getInstance().parse(primitive.getAsString());
                    }
                    catch (ParseException e) {
                        throw new MappingException(e);
                    }
                }
            }
        } else if (JsonObject.class.isAssignableFrom(srcType)) {
            JsonObject srcObject = (JsonObject)src;
            if (targetType.equals(Map.class)) {
                LinkedHashMap<String, Object> targetMap = new LinkedHashMap<String, Object>();
                for (Map.Entry<String, JsonElement> entry : srcObject.entrySet()) {
                    Object val = null;
                    JsonElement element = entry.getValue();
                    if (element.isJsonPrimitive()) {
                        val = GsonJsonProvider.unwrap(element);
                    } else if (element.isJsonArray()) {
                        val = this.convert(element, element.getClass(), List.class, conf);
                    } else if (element.isJsonObject()) {
                        val = this.convert(element, element.getClass(), Map.class, conf);
                    } else if (element.isJsonNull()) {
                        val = null;
                    }
                    targetMap.put(entry.getKey(), val);
                }
                return targetMap;
            }
        } else if (JsonArray.class.isAssignableFrom(srcType)) {
            JsonArray srcArray = (JsonArray)src;
            if (targetType.equals(List.class)) {
                ArrayList<Object> targetList = new ArrayList<Object>();
                for (JsonElement element : srcArray) {
                    if (element.isJsonPrimitive()) {
                        targetList.add(GsonJsonProvider.unwrap(element));
                        continue;
                    }
                    if (element.isJsonArray()) {
                        targetList.add(this.convert(element, element.getClass(), List.class, conf));
                        continue;
                    }
                    if (element.isJsonObject()) {
                        targetList.add(this.convert(element, element.getClass(), Map.class, conf));
                        continue;
                    }
                    if (!element.isJsonNull()) continue;
                    targetList.add(null);
                }
                return targetList;
            }
        }
        throw new MappingException("Can not map: " + srcType.getName() + " to: " + targetType.getName());
    }
}

