/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.sdk;

import com.adm.utils.uft.SSEException;
import com.adm.utils.uft.StringUtils;
import com.adm.utils.uft.autenvironment.AUTEnvironmentManager;
import com.adm.utils.uft.autenvironment.AUTEnvironmentParametersManager;
import com.adm.utils.uft.autenvironment.request.put.AUTEnvironmnentParameter;
import com.adm.utils.uft.model.AutEnvironmentConfigModel;
import com.adm.utils.uft.model.AutEnvironmentParameterModel;
import com.adm.utils.uft.sdk.Client;
import com.adm.utils.uft.sdk.Logger;
import com.adm.utils.uft.sdk.ResourceAccessLevel;
import com.adm.utils.uft.sdk.Response;
import com.adm.utils.uft.sdk.RestAuthenticator;
import java.util.Collection;
import java.util.List;

public class AUTEnvironmentBuilderPerformer {
    private Client client;
    private Logger logger;
    private AutEnvironmentConfigModel model;

    public AUTEnvironmentBuilderPerformer(Client client, Logger logger, AutEnvironmentConfigModel model) {
        this.client = client;
        this.logger = logger;
        this.model = model;
    }

    public void start() throws Throwable {
        try {
            if (!this.login()) {
                throw new SSEException("Failed to login to ALM");
            }
            this.appendQCSessionCookies();
            this.performAutOperations();
        }
        catch (Throwable cause) {
            this.logger.log(String.format("Failed to update ALM AUT Environment. Cause: %s", cause.getMessage()));
            throw cause;
        }
    }

    private boolean login() {
        boolean ret;
        try {
            ret = new RestAuthenticator().login(this.client, this.model.getAlmUserName(), this.model.getAlmPassword(), this.logger);
        }
        catch (Throwable cause) {
            ret = false;
            this.logger.log(String.format("Failed login to ALM Server URL: %s. Exception: %s", this.model.getAlmServerUrl(), cause.getMessage()));
        }
        return ret;
    }

    private void appendQCSessionCookies() {
        Response response = this.client.httpPost(this.client.build("rest/site-session"), null, null, ResourceAccessLevel.PUBLIC);
        if (!response.isOk()) {
            throw new SSEException("Cannot append QCSession cookies", response.getFailure());
        }
    }

    private void performAutOperations() {
        String autEnvironmentId = this.model.getAutEnvID();
        AUTEnvironmentManager autEnvironmentManager = new AUTEnvironmentManager(this.client, this.logger);
        String parametersRootFolderId = autEnvironmentManager.getParametersRootFolderIdByAutEnvId(autEnvironmentId);
        String autEnvironmentConfigurationId = this.getAutEnvironmentConfigurationId(autEnvironmentManager, autEnvironmentId);
        this.model.setCurrentConfigID(autEnvironmentConfigurationId);
        this.assignValuesToAutParameters(autEnvironmentConfigurationId, parametersRootFolderId);
    }

    private String getAutEnvironmentConfigurationId(AUTEnvironmentManager autEnvironmentManager, String autEnvironmentId) {
        String autEnvironmentConfigurationId;
        String string = autEnvironmentConfigurationId = autEnvironmentManager.shouldUseExistingConfiguration(this.model) ? this.model.getAutEnvConf() : autEnvironmentManager.createNewAutEnvironmentConfiguration(autEnvironmentId, this.model);
        if (StringUtils.isNullOrEmpty(autEnvironmentConfigurationId)) {
            throw new SSEException("There's no AUT Environment Configuration in order to proceed");
        }
        return autEnvironmentConfigurationId;
    }

    private void assignValuesToAutParameters(String autEnvironmentConfigurationId, String parametersRootFolderId) {
        List<AutEnvironmentParameterModel> confParams = this.model.getAutEnvironmentParameters();
        if (confParams == null || confParams.size() == 0) {
            this.logger.log("There's no AUT Environment parameters to assign for this build...");
            return;
        }
        AUTEnvironmentParametersManager parametersManager = new AUTEnvironmentParametersManager(this.client, confParams, parametersRootFolderId, autEnvironmentConfigurationId, this.model.getPathToJsonFile(), this.logger);
        Collection<AUTEnvironmnentParameter> parametersToUpdate = parametersManager.getParametersToUpdate();
        parametersManager.updateParametersValues(parametersToUpdate);
    }
}

