/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.rest;

import com.adm.utils.uft.SSEException;
import com.adm.utils.uft.sdk.Client;
import com.adm.utils.uft.sdk.HttpRequestDecorator;
import com.adm.utils.uft.sdk.ResourceAccessLevel;
import com.adm.utils.uft.sdk.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class RestClient
implements Client {
    private final String _serverUrl;
    protected Map<String, String> _cookies = new HashMap<String, String>();
    private final String _restPrefix;
    private final String _webuiPrefix;
    private final String _username;
    private final String XSRF_TOKEN_VALUE;

    public RestClient(String url, String domain, String project, String username) {
        if (!url.endsWith("/")) {
            url = String.format("%s/", url);
        }
        this._serverUrl = url;
        this._username = username;
        this._restPrefix = this.getPrefixUrl("rest", String.format("domains/%s", domain), String.format("projects/%s", project));
        this._webuiPrefix = this.getPrefixUrl("webui/alm", domain, project);
        this.XSRF_TOKEN_VALUE = UUID.randomUUID().toString();
        this._cookies.put("XSRF-TOKEN", this.XSRF_TOKEN_VALUE);
    }

    @Override
    public String getXsrfTokenValue() {
        return this.XSRF_TOKEN_VALUE;
    }

    @Override
    public String build(String suffix) {
        return String.format("%1$s%2$s", this._serverUrl, suffix);
    }

    @Override
    public String buildRestRequest(String suffix) {
        return String.format("%1$s/%2$s", this._restPrefix, suffix);
    }

    @Override
    public String buildWebUIRequest(String suffix) {
        return String.format("%1$s/%2$s", this._webuiPrefix, suffix);
    }

    @Override
    public Response httpGet(String url, String queryString, Map<String, String> headers, ResourceAccessLevel resourceAccessLevel) {
        Response ret = null;
        try {
            ret = this.doHttp("GET", url, queryString, null, headers, resourceAccessLevel);
        }
        catch (Exception cause) {
            throw new SSEException(cause);
        }
        return ret;
    }

    @Override
    public Response httpPost(String url, byte[] data, Map<String, String> headers, ResourceAccessLevel resourceAccessLevel) {
        Response ret = null;
        try {
            ret = this.doHttp("POST", url, null, data, headers, resourceAccessLevel);
        }
        catch (Exception cause) {
            throw new SSEException(cause);
        }
        return ret;
    }

    @Override
    public Response httpPut(String url, byte[] data, Map<String, String> headers, ResourceAccessLevel resourceAccessLevel) {
        Response ret = null;
        try {
            ret = this.doHttp("PUT", url, null, data, headers, resourceAccessLevel);
        }
        catch (Exception cause) {
            throw new SSEException(cause);
        }
        return ret;
    }

    @Override
    public String getServerUrl() {
        return this._serverUrl;
    }

    private String getPrefixUrl(String protocol, String domain, String project) {
        return String.format("%s%s/%s/%s", this._serverUrl, protocol, domain, project);
    }

    private Response doHttp(String type, String url, String queryString, byte[] data, Map<String, String> headers, ResourceAccessLevel resourceAccessLevel) {
        Response ret;
        if (queryString != null && !queryString.isEmpty()) {
            url = url + "?" + queryString;
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)RestClient.openConnection(url);
            connection.setRequestMethod(type);
            HashMap<String, String> decoratedHeaders = new HashMap<String, String>();
            if (headers != null) {
                decoratedHeaders.putAll(headers);
            }
            HttpRequestDecorator.decorateHeaderWithUserInfo(decoratedHeaders, this.getUsername(), resourceAccessLevel);
            this.prepareHttpRequest(connection, decoratedHeaders, data);
            connection.connect();
            ret = this.retrieveHtmlResponse(connection);
            this.updateCookies(ret);
        }
        catch (Exception cause) {
            throw new SSEException(cause);
        }
        return ret;
    }

    private void prepareHttpRequest(HttpURLConnection connection, Map<String, String> headers, byte[] bytes) {
        connection.setRequestProperty("Cookie", this.getCookies());
        this.setConnectionHeaders(connection, headers);
        this.setConnectionData(connection, bytes);
    }

    private void setConnectionData(HttpURLConnection connection, byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            connection.setDoOutput(true);
            try {
                OutputStream out = connection.getOutputStream();
                out.write(bytes);
                out.flush();
                out.close();
            }
            catch (Exception cause) {
                throw new SSEException(cause);
            }
        }
    }

    private void setConnectionHeaders(HttpURLConnection connection, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
        }
    }

    private Response retrieveHtmlResponse(HttpURLConnection connection) {
        InputStream inputStream;
        Response ret = new Response();
        try {
            ret.setStatusCode(connection.getResponseCode());
            ret.setHeaders(connection.getHeaderFields());
        }
        catch (Exception cause) {
            throw new SSEException(cause);
        }
        try {
            inputStream = connection.getInputStream();
        }
        catch (Exception e) {
            inputStream = connection.getErrorStream();
            ret.setFailure(e);
        }
        ByteArrayOutputStream container = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int read;
            while ((read = inputStream.read(buf, 0, 1024)) > 0) {
                container.write(buf, 0, read);
            }
            ret.setData(container.toByteArray());
        }
        catch (Exception ex) {
            throw new SSEException(ex);
        }
        return ret;
    }

    private void updateCookies(Response response) {
        Iterable newCookies;
        if (response.isOk() && (newCookies = (Iterable)response.getHeaders().get("Set-Cookie")) != null) {
            for (String cookie : newCookies) {
                int equalIndex = cookie.indexOf(61);
                int semicolonIndex = cookie.indexOf(59);
                String cookieKey = cookie.substring(0, equalIndex);
                String cookieValue = cookie.substring(equalIndex + 1, semicolonIndex);
                this._cookies.put(cookieKey, cookieValue);
            }
        }
    }

    private String getCookies() {
        StringBuilder ret = new StringBuilder();
        if (!this._cookies.isEmpty()) {
            for (Map.Entry<String, String> entry : this._cookies.entrySet()) {
                ret.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
            }
        }
        return ret.toString();
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    public static URLConnection openConnection(String urlString) throws IOException {
        URL url = new URL(urlString);
        return url.openConnection();
    }

    public static ProxyInfo setProxyCfg(String host, String port, String userName, String password) {
        return new ProxyInfo(host, port, userName, password);
    }

    public static ProxyInfo setProxyCfg(String host, String port) {
        ProxyInfo proxyInfo = new ProxyInfo();
        proxyInfo._host = host;
        proxyInfo._port = port;
        return proxyInfo;
    }

    public static ProxyInfo setProxyCfg(String address, String userName, String password) {
        ProxyInfo proxyInfo = new ProxyInfo();
        if (address != null) {
            int index;
            String host = address;
            if (address.endsWith("/")) {
                int end = address.lastIndexOf(47);
                host = address.substring(0, end);
            }
            if ((index = host.lastIndexOf(58)) > 0) {
                proxyInfo._host = host.substring(0, index);
                proxyInfo._port = host.substring(index + 1, host.length());
            } else {
                proxyInfo._host = host;
                proxyInfo._port = "80";
            }
        }
        proxyInfo._userName = userName;
        proxyInfo._password = password;
        return proxyInfo;
    }

    static {
        SSLContext sslcontext;
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException e) {
            throw new SSEException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSEException(e);
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return true;
            }
        });
    }

    static class ProxyInfo {
        String _host;
        String _port;
        String _userName;
        String _password;

        public ProxyInfo() {
        }

        public ProxyInfo(String host, String port, String userName, String password) {
            this._host = host;
            this._port = port;
            this._userName = userName;
            this._password = password;
        }
    }
}

