/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft;

import com.adm.utils.uft.SSEException;
import com.adm.utils.uft.StringUtils;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathUtils {
    public static List<Map<String, String>> toEntities(String xml) {
        Document document = XPathUtils.getDocument(xml);
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
        NodeList entities = document.getElementsByTagName("Entity");
        for (int i = 0; i < entities.getLength(); ++i) {
            HashMap<String, String> currEntity = new HashMap<String, String>();
            NodeList fields = ((Element)entities.item(i)).getElementsByTagName("Field");
            for (int j = 0; j < fields.getLength(); ++j) {
                Node item = fields.item(j);
                currEntity.put(item.getAttributes().item(0).getNodeValue(), XPathUtils.getFieldValue(item));
            }
            ret.add(currEntity);
        }
        return ret;
    }

    public static String getAttributeValue(String xml, String attrName) {
        NodeList nodes = XPathUtils.getChildNodes(xml, "Entity/Fields/Field");
        String ret = "";
        for (int i = 0; i < nodes.getLength(); ++i) {
            String attr;
            Node currNode = nodes.item(i);
            try {
                attr = XPathUtils.getNecessaryAttribute(currNode, "Name");
            }
            catch (Throwable cause) {
                throw new SSEException(cause);
            }
            if (!attr.equals(attrName)) continue;
            ret = XPathUtils.getFieldValue(currNode);
            break;
        }
        return ret;
    }

    private static String getFieldValue(Node node) {
        Node child2;
        String ret = null;
        Node child = node.getFirstChild();
        if (child != null && (child2 = child.getFirstChild()) != null) {
            ret = child2.getNodeValue();
        }
        return ret;
    }

    private static NodeList getChildNodes(String xml, String xpath) {
        NodeList ret = null;
        try {
            Document document = XPathUtils.getDocument(xml);
            XPathFactory factory = XPathFactory.newInstance();
            XPathExpression expression = factory.newXPath().compile(xpath);
            ret = (NodeList)expression.evaluate(document, XPathConstants.NODESET);
        }
        catch (Throwable cause) {
            throw new SSEException(cause);
        }
        return ret;
    }

    private static String getNecessaryAttribute(Node node, String attributeName) {
        if (!node.hasAttributes()) {
            return null;
        }
        Node attr = node.getAttributes().getNamedItem(attributeName);
        if (attr == null) {
            throw new SSEException(String.format("Error parsing XML, missing mandatory attribute '%s'", attributeName));
        }
        String ret = attr.getNodeValue();
        if (StringUtils.isNullOrEmpty(ret)) {
            throw new SSEException(String.format("Error parsing XML, mandatory attribute '%s' cannot be empty", attributeName));
        }
        return ret;
    }

    private static Document getDocument(String xml) {
        Document ret = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(xml));
            ret = builder.parse(inputSource);
        }
        catch (Throwable cause) {
            throw new SSEException(cause);
        }
        return ret;
    }
}

