/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft;

import com.adm.utils.uft.Pair;
import com.adm.utils.uft.StringUtils;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class Aes256Encryptor {
    private final String _secretKey;
    private final String _initVector;

    public Aes256Encryptor(Pair<String, String> keyVectorPair) {
        if (keyVectorPair == null) {
            this._secretKey = this.randomAlphanumeric(32);
            this._initVector = this.randomAlphanumeric(16);
        } else {
            String secretKey = keyVectorPair.getFirst();
            String initVector = keyVectorPair.getSecond();
            this._secretKey = StringUtils.isBlank(secretKey) ? this.randomAlphanumeric(32) : secretKey;
            this._initVector = StringUtils.isBlank(initVector) ? this.randomAlphanumeric(16) : initVector;
        }
    }

    public String Decrypt(String text) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(this._secretKey.getBytes("UTF-8"), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(this._initVector.getBytes("UTF-8"));
        cipher.init(2, (Key)keySpec, ivSpec);
        byte[] results = cipher.doFinal(Base64.decodeBase64(text));
        return new String(results, "UTF-8");
    }

    public String Encrypt(String text) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(this._secretKey.getBytes("UTF-8"), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(this._initVector.getBytes("UTF-8"));
        cipher.init(1, (Key)keySpec, ivSpec);
        byte[] results = cipher.doFinal(text.getBytes("UTF-8"));
        return Base64.encodeBase64String(results);
    }

    public String getSecretKey() {
        return this._secretKey;
    }

    public String getInitVector() {
        return this._initVector;
    }

    private String randomAlphanumeric(int count) {
        int end = 123;
        int start = 32;
        char[] buffer = new char[count];
        int gap = end - start;
        SecureRandom random = new SecureRandom();
        while (count-- != 0) {
            char ch = (char)(random.nextInt(gap) + start);
            if (Character.isLetter(ch) || Character.isDigit(ch)) {
                if (ch >= '\udc00' && ch <= '\udfff') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = ch;
                    buffer[--count] = (char)(55296 + random.nextInt(128));
                    continue;
                }
                if (ch >= '\ud800' && ch <= '\udb7f') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = (char)(56320 + random.nextInt(128));
                    buffer[--count] = ch;
                    continue;
                }
                if (ch >= '\udb80' && ch <= '\udbff') {
                    ++count;
                    continue;
                }
                buffer[count] = ch;
                continue;
            }
            ++count;
        }
        return new String(buffer);
    }
}

