/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.ui;

import com.adm.bamboo.plugin.uft.api.AbstractLauncherTaskConfigurator;
import com.adm.bamboo.plugin.uft.helpers.HpTasksArtifactRegistrator;
import com.adm.utils.uft.enums.UFTConstants;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlmUftTaskConfigurator
extends AbstractLauncherTaskConfigurator {
    private ArtifactDefinitionManager artifactDefinitionManager;

    @Override
    public void setArtifactDefinitionManager(ArtifactDefinitionManager artifactDefinitionManager) {
        this.artifactDefinitionManager = artifactDefinitionManager;
    }

    @Override
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put(UFTConstants.ALM_SERVER.getValue(), params.getString(UFTConstants.ALM_SERVER.getValue()));
        config.put(UFTConstants.ALM_SSO.getValue(), params.getString(UFTConstants.ALM_SSO.getValue()));
        config.put(UFTConstants.CLIENT_ID.getValue(), params.getString(UFTConstants.CLIENT_ID.getValue()));
        config.put(UFTConstants.API_KEY_SECRET.getValue(), params.getString(UFTConstants.API_KEY_SECRET.getValue()));
        config.put(UFTConstants.USER_NAME.getValue(), params.getString(UFTConstants.USER_NAME.getValue()));
        config.put(UFTConstants.PASSWORD.getValue(), params.getString(UFTConstants.PASSWORD.getValue()));
        config.put(UFTConstants.DOMAIN.getValue(), params.getString(UFTConstants.DOMAIN.getValue()));
        config.put(UFTConstants.PROJECT.getValue(), params.getString(UFTConstants.PROJECT.getValue()));
        config.put(UFTConstants.TESTS_PATH.getValue(), params.getString(UFTConstants.TESTS_PATH.getValue()));
        config.put(UFTConstants.TIMEOUT.getValue(), params.getString(UFTConstants.TIMEOUT.getValue()));
        config.put(UFTConstants.RUN_MODE.getValue(), params.getString(UFTConstants.RUN_MODE.getValue()));
        config.put(UFTConstants.TESTING_TOOL_HOST.getValue(), params.getString(UFTConstants.TESTING_TOOL_HOST.getValue()));
        config.put(UFTConstants.TASK_NAME.getValue(), this.getI18nBean().getText(UFTConstants.ALM_TASK_NAME.getValue()));
        return config;
    }

    private String trimEnd(String s, char ch) {
        if (s == null || s.length() < 1) {
            return s;
        }
        if (s.length() == 1 && s.charAt(0) == ch) {
            return "";
        }
        for (int i = s.length() - 1; s.charAt(i) == ch && i > 0; --i) {
            s = s.substring(0, i);
        }
        return s;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String timeoutParameter;
        super.validate(params, errorCollection);
        I18nBean textProvider = this.getI18nBean();
        params.put((Object)UFTConstants.ALM_SERVER.getValue(), (Object)this.trimEnd(params.getString(UFTConstants.ALM_SERVER.getValue()), '/'));
        if (StringUtils.isEmpty(params.getString(UFTConstants.ALM_SERVER.getValue()))) {
            errorCollection.addError(UFTConstants.ALM_SERVER.getValue(), textProvider.getText("error.ALMServerIsEmpty"));
        }
        if (Boolean.valueOf(params.getString(UFTConstants.ALM_SSO.getValue())).equals(true)) {
            if (StringUtils.isEmpty(params.getString(UFTConstants.CLIENT_ID.getValue()))) {
                errorCollection.addError(UFTConstants.CLIENT_ID.getValue(), textProvider.getText("error.clientIDIsEmpty"));
            }
            if (StringUtils.isEmpty(params.getString(UFTConstants.API_KEY_SECRET.getValue()))) {
                errorCollection.addError(UFTConstants.API_KEY_SECRET.getValue(), textProvider.getText("error.apiKeySecretIsEmpty"));
            }
        } else if (StringUtils.isEmpty(params.getString(UFTConstants.USER_NAME.getValue()))) {
            errorCollection.addError(UFTConstants.USER_NAME.getValue(), textProvider.getText("error.userNameIsEmpty"));
        }
        if (StringUtils.isEmpty(params.getString(UFTConstants.DOMAIN.getValue()))) {
            errorCollection.addError(UFTConstants.DOMAIN.getValue(), textProvider.getText("error.domainIsEmpty"));
        }
        if (StringUtils.isEmpty(params.getString(UFTConstants.PROJECT.getValue()))) {
            errorCollection.addError(UFTConstants.PROJECT.getValue(), textProvider.getText("RunFromAlmTask.error.projectIsEmpty"));
        }
        if (StringUtils.isEmpty(params.getString(UFTConstants.TESTS_PATH.getValue()))) {
            errorCollection.addError(UFTConstants.TESTS_PATH.getValue(), textProvider.getText("RunFromAlmTask.error.testSetIsEmpty"));
        }
        if (!(StringUtils.isEmpty(timeoutParameter = params.getString(UFTConstants.TIMEOUT.getValue())) || StringUtils.isNumeric(timeoutParameter) && !(Integer.parseInt(timeoutParameter) < 0 | Integer.parseInt(timeoutParameter) > 30))) {
            errorCollection.addError(UFTConstants.TIMEOUT.getValue(), textProvider.getText("error.timeoutIsNotCorrect"));
        }
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        new HpTasksArtifactRegistrator().registerCommonArtifact((Job)context.get("plan"), this.getI18nBean(), this.artifactDefinitionManager);
        super.populateContextForCreate(context);
        this.populateContextForLists(context);
        context.put(UFTConstants.RUN_MODE.getValue(), UFTConstants.RUN_LOCALLY_PARAMETER.getValue());
    }

    private void populateContextForLists(@NotNull Map<String, Object> context) {
        context.put(UFTConstants.RUN_MODE_PARAMETER.getValue(), this.getRunModes());
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        Map configuration = taskDefinition.getConfiguration();
        context.put(UFTConstants.ALM_SERVER.getValue(), configuration.get(UFTConstants.ALM_SERVER.getValue()));
        context.put(UFTConstants.ALM_SSO.getValue(), configuration.get(UFTConstants.ALM_SSO.getValue()));
        context.put(UFTConstants.CLIENT_ID.getValue(), configuration.get(UFTConstants.CLIENT_ID.getValue()));
        context.put(UFTConstants.API_KEY_SECRET.getValue(), configuration.get(UFTConstants.API_KEY_SECRET.getValue()));
        context.put(UFTConstants.USER_NAME.getValue(), configuration.get(UFTConstants.USER_NAME.getValue()));
        context.put(UFTConstants.PASSWORD.getValue(), configuration.get(UFTConstants.PASSWORD.getValue()));
        context.put(UFTConstants.DOMAIN.getValue(), configuration.get(UFTConstants.DOMAIN.getValue()));
        context.put(UFTConstants.PROJECT.getValue(), configuration.get(UFTConstants.PROJECT.getValue()));
        context.put(UFTConstants.TESTS_PATH.getValue(), configuration.get(UFTConstants.TESTS_PATH.getValue()));
        context.put(UFTConstants.TIMEOUT.getValue(), configuration.get(UFTConstants.TIMEOUT.getValue()));
        context.put(UFTConstants.RUN_MODE.getValue(), configuration.get(UFTConstants.RUN_MODE.getValue()));
        context.put(UFTConstants.TESTING_TOOL_HOST.getValue(), configuration.get(UFTConstants.TESTING_TOOL_HOST.getValue()));
        this.populateContextForLists(context);
    }

    private Map<String, String> getRunModes() {
        HashMap<String, String> runTypesMap = new HashMap<String, String>();
        I18nBean textProvider = this.getI18nBean();
        runTypesMap.put(UFTConstants.RUN_LOCALLY_PARAMETER.getValue(), textProvider.getText(UFTConstants.RUN_LOCALLY_LBL.getValue()));
        runTypesMap.put(UFTConstants.RUN_ON_PLANNED_HOST_PARAMETER.getValue(), textProvider.getText(UFTConstants.RUN_ON_PLANNED_HOST_LBL.getValue()));
        runTypesMap.put(UFTConstants.RUN_REMOTELY_PARAMETER.getValue(), textProvider.getText(UFTConstants.RUN_REMOTELY_LBL.getValue()));
        return runTypesMap;
    }
}

