/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.results;

import com.adm.utils.uft.FilesHandler;
import com.adm.utils.uft.StringUtils;
import com.adm.utils.uft.enums.UFTConstants;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.interceptors.StringMatchingInterceptor;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class TestResultHelperAlm {
    private static final String CAN_NOT_SAVE_RUN_LOG_MESSAGE = "RunFromAlmTask.error.canNotSaveTheRunLog";
    private static final String RUN_LOG_FILE_NAME = "RunLog";
    private static final String ALM_RUN_RESULTS_LINK_PARAMETER = "ALM_RUN_RESULTS_LINK_PARAMETER";
    private static final String RUN_LOG_HTML_TEXT = "<!DOCTYPE html>\n<html>\n    <head>\n        <title>Test</title>\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n        <script type=\"text/javascript\">\n        function codeAddress() {\n            window.location = ALM_RUN_RESULTS_LINK_PARAMETER;\n        }\n        window.onload = codeAddress;\n        </script>\n    </head>\n    <body>\n   \n    </body>\n</html>";
    private static List<String> savedALMRunLogPaths = new ArrayList<String>();
    private static int currentBuildNumber;

    public static void AddALMArtifacts(TaskContext taskContext, File resultFile, String linkSearchFilter, I18nBean i18nBean) {
        TestResultHelperAlm.clearSavedALMRunLogPaths(taskContext);
        String taskName = (String)taskContext.getConfigurationMap().get((Object)UFTConstants.TASK_NAME.getValue());
        if (taskName.equals(i18nBean.getText(UFTConstants.ALM_LAB_TASK_NAME.getValue()))) {
            String taskRunLogPath = TestResultHelperAlm.findRequiredStringFromLog(taskContext, linkSearchFilter);
            if (StringUtils.isNullOrEmpty(taskRunLogPath)) {
                taskContext.getBuildLogger().addErrorLogEntry(i18nBean.getText(CAN_NOT_SAVE_RUN_LOG_MESSAGE));
                return;
            }
            if (taskRunLogPath.contains("processRunId")) {
                TestResultHelperAlm.createResultFile(taskContext, taskRunLogPath, ".*processRunId=", i18nBean);
            } else {
                TestResultHelperAlm.createResultFile(taskContext, taskRunLogPath, ".*/", i18nBean);
            }
        } else if (taskName.equals(i18nBean.getText(UFTConstants.ALM_TASK_NAME.getValue()))) {
            Integer linksAmount;
            List<String> links = null;
            if (resultFile != null && resultFile.exists()) {
                links = TestResultHelperAlm.findRequiredStringsFromFile(taskContext.getBuildLogger(), resultFile);
            }
            if (links == null || links.size() < 1) {
                links = TestResultHelperAlm.findRequiredStringsFromLog(taskContext.getBuildLogger(), linkSearchFilter);
                taskContext.getBuildLogger().addBuildLogEntry("link is: " + links.get(0));
            }
            if ((linksAmount = Integer.valueOf(links.size())).equals(0)) {
                taskContext.getBuildLogger().addErrorLogEntry(i18nBean.getText("ERROR ****** RunFromAlmTask.error.canNotSaveTheRunLog"));
                return;
            }
            for (String link : links) {
                TestResultHelperAlm.createResultFile(taskContext, link, ".*EntityID=", i18nBean);
            }
        }
    }

    private static void clearSavedALMRunLogPaths(TaskContext taskContext) {
        int taskBuildNumber = taskContext.getBuildContext().getBuildNumber();
        if (savedALMRunLogPaths.size() > 0 && taskBuildNumber != currentBuildNumber) {
            savedALMRunLogPaths.clear();
        }
        currentBuildNumber = taskBuildNumber;
    }

    private static String findRequiredStringFromLog(TaskContext taskContext, String searchFilter) {
        BuildLogger logger = taskContext.getBuildLogger();
        StringMatchingInterceptor interceptor = new StringMatchingInterceptor(searchFilter, true);
        List buildLog = Lists.reverse((List)logger.getLastNLogEntries(100));
        for (LogEntry logEntry : buildLog) {
            String log;
            int pathBegin;
            interceptor.intercept(logEntry);
            if (!interceptor.hasMatched() || (pathBegin = (log = logEntry.getLog()).indexOf("http")) <= -1 || savedALMRunLogPaths.contains(log = log.substring(pathBegin))) continue;
            return log;
        }
        return null;
    }

    private static List<String> findRequiredStringsFromLog(BuildLogger logger, String searchFilter) {
        StringMatchingInterceptor interceptor = new StringMatchingInterceptor(searchFilter, true);
        List buildLog = Lists.reverse((List)logger.getLastNLogEntries(100));
        ArrayList<String> results = new ArrayList<String>();
        for (LogEntry logEntry : buildLog) {
            String result;
            String log;
            int pathBegin;
            interceptor.intercept(logEntry);
            if (!interceptor.hasMatched() || (pathBegin = (log = logEntry.getLog()).indexOf("td:")) <= -1 || results.contains(result = log.substring(pathBegin)) || savedALMRunLogPaths.contains(result)) continue;
            results.add(result);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> findRequiredStringsFromFile(BuildLogger logger, File resultFile) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new FileReader(resultFile.getAbsoluteFile()));){
                String s;
                while ((s = in.readLine()) != null) {
                    sb.append(s);
                }
            }
            String sp = "td://.+?;EntityID=[0-9]+";
            Pattern p = Pattern.compile(sp);
            Matcher m = p.matcher(sb.toString());
            while (m.find()) {
                results.add(m.group());
            }
        }
        catch (Exception e) {
            logger.addBuildLogEntry(e.getMessage());
        }
        return results;
    }

    private static void createResultFile(TaskContext taskContext, String link, String idFilter, I18nBean i18nBean) {
        savedALMRunLogPaths.add(link);
        String RunReportFileId = link.replaceAll(idFilter, "");
        if (StringUtils.isNullOrEmpty(RunReportFileId)) {
            return;
        }
        String RunReportFileName = RUN_LOG_FILE_NAME + RunReportFileId + ".html";
        String workingDirectory = FilesHandler.getOutputFilePath(taskContext);
        File resultFile = new File(workingDirectory + "/" + RunReportFileName);
        link = "\"" + link + "\"";
        String parameterizedResultsHtmlText = RUN_LOG_HTML_TEXT.replaceAll(ALM_RUN_RESULTS_LINK_PARAMETER, link);
        try {
            FileUtils.writeStringToFile(resultFile, parameterizedResultsHtmlText);
        }
        catch (Exception ex) {
            taskContext.getBuildLogger().addErrorLogEntry(i18nBean.getText(CAN_NOT_SAVE_RUN_LOG_MESSAGE));
        }
    }
}

