/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.api;

import com.adm.utils.uft.Aes256Encryptor;
import com.adm.utils.uft.FilesHandler;
import com.adm.utils.uft.Pair;
import com.adm.utils.uft.StringUtils;
import com.adm.utils.uft.TaskUtils;
import com.adm.utils.uft.model.UftRunAsUser;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public interface AbstractLauncherTask
extends TaskType {
    public static final String BUILD_KEY = "buildTimeStamp";
    public static final String AES_256_SECRET_KEY = "AES_256_SECRET_KEY";
    public static final String AES_256_SECRET_INIT_VECTOR = "AES_256_SECRET_INIT_VECTOR";
    public static final String KEY_VALUE_FORMAT = "%s = %s";
    public static final String UFT_RUN_AS_USER_NAME = "UFT_RUN_AS_USER_NAME";
    public static final String UFT_RUN_AS_USER_ENCODED_PWD = "UFT_RUN_AS_USER_ENCODED_PASSWORD";
    public static final String UFT_RUN_AS_USER_PWD = "UFT_RUN_AS_USER_PASSWORD";

    public CustomVariableContext getCustomVariableContext();

    public Properties getTaskProperties(TaskContext var1) throws Exception;

    public Aes256Encryptor getAes256Encryptor();

    public TaskResult collateResults(@NotNull TaskContext var1, Properties var2);

    default public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        Properties mergedProperties = new Properties();
        try {
            Properties customTaskProperties = this.getTaskProperties(taskContext);
            if (customTaskProperties != null) {
                mergedProperties.putAll((Map<?, ?>)customTaskProperties);
            }
        }
        catch (Exception e) {
            TaskUtils.logErrorMessage(e, buildLogger, taskContext);
        }
        String buildTimeStamp = this.getBuildTimeStamp();
        try {
            UftRunAsUser uftRunAsUser = this.getUftRunAsUser(buildLogger);
            if (uftRunAsUser != null) {
                mergedProperties.put("uftRunAsUserName", uftRunAsUser.getUsername());
                if (!StringUtils.isBlank(uftRunAsUser.getEncodedPassword())) {
                    mergedProperties.put("uftRunAsUserEncodedPassword", uftRunAsUser.getEncodedPasswordAsEncrypted());
                } else if (!StringUtils.isBlank(uftRunAsUser.getPassword())) {
                    mergedProperties.put("uftRunAsUserPassword", uftRunAsUser.getPasswordAsEncrypted());
                }
            }
        }
        catch (Exception e) {
            buildLogger.addErrorLogEntry(String.format("Build parameters check failed: %s.", e.getMessage()));
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
        File workingDirectory = taskContext.getWorkingDirectory();
        File paramsFile = FilesHandler.buildPropertiesFile(taskContext, workingDirectory, mergedProperties, buildTimeStamp, buildLogger);
        String launcherPath = null;
        String aborterPath = null;
        try {
            launcherPath = FilesHandler.getToolPath(taskContext, workingDirectory, true);
            aborterPath = FilesHandler.getToolPath(taskContext, workingDirectory, false);
        }
        catch (IOException ioe) {
            TaskUtils.logErrorMessage(ioe, buildLogger, taskContext);
        }
        try {
            Integer returnCode = this.runTask(workingDirectory, launcherPath, paramsFile.getAbsolutePath(), buildLogger);
            if (returnCode.equals(3)) {
                throw new InterruptedException();
            }
            if (returnCode.equals(0)) {
                return this.collateResults(taskContext, mergedProperties);
            }
        }
        catch (IOException ioe) {
            TaskUtils.logErrorMessage(ioe, buildLogger, taskContext);
        }
        catch (InterruptedException e) {
            buildLogger.addErrorLogEntry("Aborted by user. Aborting process.");
            try {
                this.runTask(workingDirectory, aborterPath, paramsFile.getAbsolutePath(), buildLogger);
            }
            catch (IOException ioe) {
                TaskUtils.logErrorMessage(ioe, buildLogger, taskContext);
            }
            catch (InterruptedException ie) {
                TaskUtils.logErrorMessage(ie, buildLogger, taskContext);
            }
        }
        return this.collateResults(taskContext, mergedProperties);
    }

    default public Integer runTask(File workingDirectory, String launcherPath, String paramFile, BuildLogger logger) throws IOException, InterruptedException {
        try {
            String line;
            ProcessBuilder builder = new ProcessBuilder(launcherPath, "-paramfile", paramFile);
            builder.directory(workingDirectory);
            Aes256Encryptor encryptor = this.getAes256Encryptor();
            builder.environment().put(AES_256_SECRET_KEY, encryptor.getSecretKey());
            builder.environment().put(AES_256_SECRET_INIT_VECTOR, encryptor.getInitVector());
            logger.addBuildLogEntry(launcherPath + " -paramfile " + paramFile);
            Process process = builder.start();
            BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = output.readLine()) != null) {
                logger.addBuildLogEntry(line);
            }
            output.close();
            return process.waitFor();
        }
        catch (Throwable t) {
            if (t.getMessage() != null) {
                logger.addBuildLogEntry(t.getMessage());
            }
            return -1;
        }
    }

    default public String getBuildTimeStamp() {
        Map variables = this.getCustomVariableContext().getVariableContexts();
        String buildTimeStamp = "";
        if (variables.containsKey(BUILD_KEY)) {
            buildTimeStamp = ((VariableDefinitionContext)variables.get(BUILD_KEY)).getValue();
        }
        return buildTimeStamp;
    }

    default public UftRunAsUser getUftRunAsUser(BuildLogger logger) throws IllegalArgumentException {
        String username;
        Map vars = this.getCustomVariableContext().getVariableContexts();
        if (vars != null && !vars.isEmpty() && vars.keySet().contains(UFT_RUN_AS_USER_NAME) && !StringUtils.isBlank(username = ((VariableDefinitionContext)vars.get(UFT_RUN_AS_USER_NAME)).getValue())) {
            logger.addBuildLogEntry(String.format(KEY_VALUE_FORMAT, UFT_RUN_AS_USER_NAME, username));
            String password = null;
            boolean isEncoded = false;
            if (vars.keySet().contains(UFT_RUN_AS_USER_ENCODED_PWD)) {
                password = ((VariableDefinitionContext)vars.get(UFT_RUN_AS_USER_ENCODED_PWD)).getValue();
                isEncoded = true;
            } else if (vars.keySet().contains(UFT_RUN_AS_USER_PWD)) {
                password = ((VariableDefinitionContext)vars.get(UFT_RUN_AS_USER_PWD)).getValue();
                return new UftRunAsUser(username, password, false, this.getAes256Encryptor());
            }
            if (StringUtils.isBlank(password)) {
                throw new IllegalArgumentException(String.format("Either %s or %s is required.", UFT_RUN_AS_USER_PWD, UFT_RUN_AS_USER_ENCODED_PWD));
            }
            return new UftRunAsUser(username, password, isEncoded, this.getAes256Encryptor());
        }
        return null;
    }

    default public Pair<String, String> getEncryptionKeyVectorPair() {
        Map variables = this.getCustomVariableContext().getVariableContexts();
        String privateKey = null;
        String initVect = null;
        if (variables.containsKey(AES_256_SECRET_KEY)) {
            privateKey = ((VariableDefinitionContext)variables.get(AES_256_SECRET_KEY)).getValue();
        }
        if (variables.containsKey(AES_256_SECRET_INIT_VECTOR)) {
            initVect = ((VariableDefinitionContext)variables.get(AES_256_SECRET_INIT_VECTOR)).getValue();
        }
        return new Pair<String, Object>(privateKey, initVect);
    }
}

