/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.sv.task;

import com.adm.bamboo.plugin.sv.model.ServiceInfo;
import com.adm.bamboo.plugin.sv.model.SvServerSettingsModel;
import com.adm.bamboo.plugin.sv.model.SvServiceSelectionModel;
import com.adm.bamboo.plugin.sv.model.SvUnDeployModel;
import com.adm.utils.sv.SVExecutorUtil;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.processor.UndeployProcessor;
import com.microfocus.sv.svconfigurator.processor.UndeployProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;

public class SVUndeployTask
implements TaskType {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult execute(TaskContext taskContext) throws TaskException {
        Date startDate = new Date();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        ConfigurationMap map = taskContext.getConfigurationMap();
        String serverURL = (String)map.get((Object)"url");
        String userName = (String)map.get((Object)"userName");
        String userPassword = (String)map.get((Object)"password");
        String projectPath = (String)map.get((Object)"projectPath");
        String projectPassword = (String)map.get((Object)"projectPassword");
        String serviceName = (String)map.get((Object)"serviceNameOrId");
        serviceName = serviceName == null || serviceName.isEmpty() ? null : serviceName;
        boolean force = BooleanUtils.toBoolean((String)map.get((Object)"force"));
        boolean continueIfNotDeployed = BooleanUtils.toBoolean((String)map.get((Object)"continue"));
        String serviceSelection = (String)map.get((Object)"serviceSelection");
        SvServerSettingsModel svServerSettingsModel = new SvServerSettingsModel(serverURL, userName, userPassword);
        SvServiceSelectionModel svServiceSelectionModel = new SvServiceSelectionModel(serviceName, projectPath, projectPassword);
        svServiceSelectionModel.setSelectionType(serviceSelection);
        SvUnDeployModel svUnDeployModel = new SvUnDeployModel(svServerSettingsModel, svServiceSelectionModel, force, continueIfNotDeployed);
        this.logConfig(buildLogger, svUnDeployModel, startDate, "    ");
        try {
            this.unDeployServiceFromProject(svUnDeployModel, buildLogger);
        }
        catch (Exception e) {
            TaskResult taskResult;
            try {
                buildLogger.addErrorLogEntry("Build failed: " + e.getMessage(), (Throwable)e);
                taskResult = TaskResultBuilder.create((TaskContext)taskContext).failedWithError().build();
            }
            catch (Throwable throwable) {
                double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
                buildLogger.addBuildLogEntry(String.format("Finished: UnDeploy Virtual Service in %.3f seconds%n%n", duration));
                throw throwable;
            }
            double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
            buildLogger.addBuildLogEntry(String.format("Finished: UnDeploy Virtual Service in %.3f seconds%n%n", duration));
            return taskResult;
        }
        double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
        buildLogger.addBuildLogEntry(String.format("Finished: UnDeploy Virtual Service in %.3f seconds%n%n", duration));
        return TaskResultBuilder.create((TaskContext)taskContext).success().build();
    }

    private void unDeployServiceFromProject(SvUnDeployModel svUnDeployModel, BuildLogger buildLogger) throws Exception {
        UndeployProcessor processor = new UndeployProcessor(null);
        ICommandExecutor commandExecutor = SVExecutorUtil.createCommandExecutor(new URL(svUnDeployModel.getServerSettingsModel().getUrl()), new Credentials(svUnDeployModel.getServerSettingsModel().getUsername(), svUnDeployModel.getServerSettingsModel().getPassword()));
        List<ServiceInfo> serviceInfoList = SVExecutorUtil.getServiceList(commandExecutor, svUnDeployModel.getServiceSelectionModel(), svUnDeployModel.isContinueIfNotDeployed(), buildLogger);
        for (ServiceInfo service : serviceInfoList) {
            buildLogger.addBuildLogEntry(String.format("  Undeploying service '%s' [%s] %n", service.getName(), service.getId()));
            UndeployProcessorInput undeployProcessorInput = new UndeployProcessorInput(svUnDeployModel.isForce(), null, service.getId());
            processor.process(undeployProcessorInput, commandExecutor);
        }
    }

    private void logConfig(BuildLogger buildLogger, SvUnDeployModel svUnDeployModel, Date startDate, String prefix) {
        buildLogger.addBuildLogEntry(String.format("%nStarting UnDeploy Virtual Service for SV Server '%s' as %s on %s%n", svUnDeployModel.getServerSettingsModel().getUrl(), svUnDeployModel.getServerSettingsModel().getUsername(), startDate));
        SVExecutorUtil.logConfig(svUnDeployModel.getServiceSelectionModel(), buildLogger, prefix);
        buildLogger.addBuildLogEntry(prefix + "Force: " + svUnDeployModel.isForce());
        buildLogger.addBuildLogEntry(prefix + "Continue if not deployed: " + svUnDeployModel.isContinueIfNotDeployed());
    }
}

