/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.sv.task;

import com.adm.bamboo.plugin.sv.model.ServiceInfo;
import com.adm.bamboo.plugin.sv.model.SvChangeModeModel;
import com.adm.bamboo.plugin.sv.model.SvDataModelSelection;
import com.adm.bamboo.plugin.sv.model.SvPerformanceModelSelection;
import com.adm.bamboo.plugin.sv.model.SvServerSettingsModel;
import com.adm.bamboo.plugin.sv.model.SvServiceSelectionModel;
import com.adm.utils.sv.SVExecutorUtil;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.processor.ChmodeProcessor;
import com.microfocus.sv.svconfigurator.processor.ChmodeProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;

public class SVChangeModeTask
implements TaskType {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult execute(TaskContext taskContext) throws TaskException {
        Date startDate = new Date();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        ConfigurationMap map = taskContext.getConfigurationMap();
        String serverURL = (String)map.get((Object)"url");
        String userName = (String)map.get((Object)"userName");
        String userPassword = (String)map.get((Object)"password");
        String projectPath = (String)map.get((Object)"projectPath");
        String projectPassword = (String)map.get((Object)"projectPassword");
        String serviceName = (String)map.get((Object)"serviceNameOrId");
        serviceName = serviceName == null || serviceName.isEmpty() ? null : serviceName;
        String dmNameOrId = (String)map.get((Object)"dmNameOrId");
        String pmNameOrId = (String)map.get((Object)"pmNameOrId");
        String serviceSelection = (String)map.get((Object)"serviceSelection");
        String serviceMode = (String)map.get((Object)"serviceMode");
        String dataModel = (String)map.get((Object)"dataModel");
        String pmModel = (String)map.get((Object)"performanceModel");
        boolean force = BooleanUtils.toBoolean((String)map.get((Object)"force"));
        SvServerSettingsModel svServerSettingsModel = new SvServerSettingsModel(serverURL, userName, userPassword);
        SvServiceSelectionModel svServiceSelectionModel = new SvServiceSelectionModel(serviceName, projectPath, projectPassword);
        svServiceSelectionModel.setSelectionType(serviceSelection);
        ServiceRuntimeConfiguration.RuntimeMode runtimeMode = ServiceRuntimeConfiguration.RuntimeMode.valueOf(serviceMode);
        SvDataModelSelection svDataModelSelection = new SvDataModelSelection(null, dmNameOrId);
        svDataModelSelection.setSelectionType(dataModel);
        SvPerformanceModelSelection svPerformanceModelSelection = new SvPerformanceModelSelection(null, pmNameOrId);
        svPerformanceModelSelection.setSelectionType(pmModel);
        SvChangeModeModel svChangeModeModel = new SvChangeModeModel(svServerSettingsModel, svServiceSelectionModel, runtimeMode, svDataModelSelection, svPerformanceModelSelection, force);
        this.logConfig(buildLogger, svChangeModeModel, startDate, "    ");
        ICommandExecutor commandExecutor = null;
        try {
            commandExecutor = SVExecutorUtil.createCommandExecutor(new URL(svServerSettingsModel.getUrl()), new Credentials(svServerSettingsModel.getUsername(), svServerSettingsModel.getPassword()));
            List<ServiceInfo> serviceInfoList = SVExecutorUtil.getServiceList(commandExecutor, svServiceSelectionModel, false, buildLogger);
            for (ServiceInfo service : serviceInfoList) {
                this.changeServiceMode(svChangeModeModel, service, buildLogger, commandExecutor);
            }
        }
        catch (Exception e) {
            TaskResult taskResult;
            try {
                buildLogger.addErrorLogEntry("Build failed: " + e.getMessage(), (Throwable)e);
                taskResult = TaskResultBuilder.create((TaskContext)taskContext).failedWithError().build();
            }
            catch (Throwable throwable) {
                double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
                buildLogger.addBuildLogEntry(String.format("Finished: Change Mode of Virtual Service in %.3f seconds%n%n", duration));
                throw throwable;
            }
            double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
            buildLogger.addBuildLogEntry(String.format("Finished: Change Mode of Virtual Service in %.3f seconds%n%n", duration));
            return taskResult;
        }
        double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
        buildLogger.addBuildLogEntry(String.format("Finished: Change Mode of Virtual Service in %.3f seconds%n%n", duration));
        return TaskResultBuilder.create((TaskContext)taskContext).success().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeServiceMode(SvChangeModeModel svChangeModeModel, ServiceInfo serviceInfo, BuildLogger buildLogger, ICommandExecutor commandExecutor) throws Exception {
        String dataModel = svChangeModeModel.getDataModel().getSelectedModelName();
        String performanceModel = svChangeModeModel.getPerformanceModel().getSelectedModelName();
        boolean useDefaultDataModel = svChangeModeModel.getDataModel().isDefaultSelected();
        boolean useDefaultPerformanceModel = svChangeModeModel.getPerformanceModel().isDefaultSelected();
        ServiceRuntimeConfiguration.RuntimeMode targetMode = this.getTargetMode(svChangeModeModel);
        ChmodeProcessorInput chModeInput = new ChmodeProcessorInput(svChangeModeModel.isForce(), null, serviceInfo.getId(), dataModel, performanceModel, targetMode, useDefaultDataModel, useDefaultPerformanceModel);
        buildLogger.addBuildLogEntry(String.format("    Changing mode of service '%s' [%s] to %s mode%n", new Object[]{serviceInfo.getName(), serviceInfo.getId(), svChangeModeModel.getRuntimeMode()}));
        ChmodeProcessor processor = new ChmodeProcessor(null);
        try {
            processor.process(chModeInput, commandExecutor);
        }
        finally {
            this.printServiceStatus(buildLogger, serviceInfo, commandExecutor);
        }
    }

    private ServiceRuntimeConfiguration.RuntimeMode getTargetMode(SvChangeModeModel svChangeModeModel) {
        if (svChangeModeModel.getRuntimeMode() == ServiceRuntimeConfiguration.RuntimeMode.SIMULATING && !svChangeModeModel.getPerformanceModel().isNoneSelected() && svChangeModeModel.getDataModel().isNoneSelected()) {
            return ServiceRuntimeConfiguration.RuntimeMode.STAND_BY;
        }
        return svChangeModeModel.getRuntimeMode();
    }

    private void printServiceStatus(BuildLogger buildLogger, ServiceInfo serviceInfo, ICommandExecutor commandExecutor) {
        try {
            IService service = commandExecutor.findService(serviceInfo.getId(), null);
            ServiceRuntimeConfiguration info = commandExecutor.getServiceRuntimeInfo(service);
            ServiceRuntimeConfiguration.RuntimeMode mode = this.getDisplayRuntimeMode(info);
            buildLogger.addBuildLogEntry(String.format("    Service '%s' [%s] is in %s mode%n", new Object[]{service.getName(), service.getId(), mode}));
            if (mode == ServiceRuntimeConfiguration.RuntimeMode.LEARNING || mode == ServiceRuntimeConfiguration.RuntimeMode.SIMULATING) {
                buildLogger.addBuildLogEntry("      Data model: " + this.getModelName(service.getDataModels(), info.getDataModelId()));
                buildLogger.addBuildLogEntry("      Performance model: " + this.getModelName(service.getPerfModels(), info.getPerfModelId()));
            }
            if (info.getDeploymentErrorMessage() != null) {
                buildLogger.addBuildLogEntry("      Error message: " + info.getDeploymentErrorMessage());
            }
        }
        catch (Exception e) {
            String msg = String.format("Failed to get detail of service '%s' [%s]", serviceInfo.getName(), serviceInfo.getId());
            buildLogger.addBuildLogEntry(String.format("      %s: %s%n", msg, e.getMessage()));
        }
    }

    private ServiceRuntimeConfiguration.RuntimeMode getDisplayRuntimeMode(ServiceRuntimeConfiguration info) {
        return info.getRuntimeMode() == ServiceRuntimeConfiguration.RuntimeMode.STAND_BY && info.getPerfModelId() != null ? ServiceRuntimeConfiguration.RuntimeMode.SIMULATING : info.getRuntimeMode();
    }

    private String getModelName(Collection<? extends IProjectElement> models, String modelId) {
        for (IProjectElement iProjectElement : models) {
            if (!iProjectElement.getId().equals(modelId)) continue;
            return String.format("'%s' [%s]", iProjectElement.getName(), modelId);
        }
        return null;
    }

    protected void logConfig(BuildLogger buildLogger, SvChangeModeModel svChangeModeModel, Date startDate, String prefix) {
        buildLogger.addBuildLogEntry(String.format("%nStarting Change Mode of Virtual Service for SV Server '%s' as %s on %s%n", svChangeModeModel.getServerSettingsModel().getUrl(), svChangeModeModel.getServerSettingsModel().getUsername(), startDate));
        SVExecutorUtil.logConfig(svChangeModeModel.getServiceSelectionModel(), buildLogger, prefix);
        buildLogger.addBuildLogEntry(prefix + "Mode: " + svChangeModeModel.getRuntimeMode().toString());
        buildLogger.addBuildLogEntry(prefix + "Data model: " + svChangeModeModel.getDataModel().toString());
        buildLogger.addBuildLogEntry(prefix + "Performance model: " + svChangeModeModel.getPerformanceModel().toString());
        buildLogger.addBuildLogEntry(prefix + "Force: " + svChangeModeModel.isForce());
    }
}

