/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.performancecenter.impl;

import com.adm.bamboo.plugin.performancecenter.impl.PcModelBamboo;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.task.TaskContext;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcException;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunEventLog;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunResponse;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunResult;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunResults;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestInstance;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestInstances;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestSet;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestSets;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTrendedRun;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.RunState;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TrendReportRequest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TrendReportTransactionDataRoot;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TrendReportTypes;
import com.microfocus.adm.performancecenter.plugins.common.rest.PcRestProxy;
import java.beans.IntrospectionException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.ClientProtocolException;

public class PcClientBamboo {
    public static final String artifactsResourceName = "artifact";
    public static final String runReportStructure = "%s/%s/performanceTestsReports/pcRun";
    public static final String trendReportStructure = "%s/%s/performanceTestsReports/TrendReports";
    public static final String pcReportArchiveName = "Reports.zip";
    public static final String pcReportFileName = "Report.html";
    public static final String TRENDED = "Trended";
    public static final String PENDING = "Pending";
    public static final String PUBLISHING = "Publishing";
    public static final String ERROR = "Error";
    public static final String COLLATE = "COLLATE";
    public static final String COLLATE_ANALYZE = "COLLATE_AND_ANALYZE";
    public static final String DO_NOTHING = "DO_NOTHING";
    private static final String artifactsDirectoryName = "archive";
    private static final String RUNID_BUILD_VARIABLE = "HP_RUN_ID";
    private static final int BUFFER_SIZE = 4096;
    private PcModelBamboo model;
    private TaskContext taskContext;
    private PcRestProxy restProxy;
    private boolean loggedIn;
    private BuildLogger buildLogger;
    private PrintStream ps;

    public PcClientBamboo(PcModelBamboo pcModel, TaskContext taskContext, BuildLogger buildLogger) {
        try {
            this.model = pcModel;
            this.taskContext = taskContext;
            if (this.model.getProxyOutURL() != null && !this.model.getProxyOutURL().isEmpty()) {
                buildLogger.addBuildLogEntry("Using proxy: " + this.model.getProxyOutURL());
            }
            this.restProxy = new PcRestProxy(this.model.isHTTPSProtocol(), this.model.getPcServerName(), this.model.isAuthenticateWithToken(), this.model.getAlmDomain(), this.model.getAlmProject(), this.model.getProxyOutURL(), this.model.getProxyOutUser(), this.model.getProxyOutPassword());
            this.buildLogger = buildLogger;
        }
        catch (PcException e) {
            buildLogger.addBuildLogEntry(e.getMessage());
        }
    }

    public boolean login() {
        try {
            String user = this.model.getAlmUserName();
            this.buildLogger.addBuildLogEntry(String.format("Trying to login LRE Server '%s://%s/%s' with credentials of %s '%s']", this.model.isHTTPSProtocol(), this.restProxy.GetPcServer(), this.restProxy.GetTenant(), this.model.isAuthenticateWithToken() ? "ClientIdKey" : "User", user));
            this.loggedIn = this.restProxy.authenticate(user, this.model.getAlmPassword());
        }
        catch (PcException e) {
            this.buildLogger.addBuildLogEntry(e.getMessage());
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry(String.valueOf(e));
        }
        this.buildLogger.addBuildLogEntry(String.format("Login %s", this.loggedIn ? "succeeded" : "failed"));
        return this.loggedIn;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public int startRun() throws NumberFormatException, ClientProtocolException, PcException, IOException {
        int testID = Integer.parseInt(this.model.getTestId());
        int testInstance = this.getCorrectTestInstanceID(testID);
        this.setCorrectTrendReportID();
        PcRunResponse response = this.restProxy.startRun(testID, testInstance, this.model.getTimeslotDuration(), this.model.getPostRunAction().getValue(), this.model.isVudsMode(), 0);
        this.buildLogger.addBuildLogEntry(String.format("\nRun started (TestID: %s, RunID: %s, TimeslotID: %s)\n", response.getTestID(), response.getID(), response.getTimeslotID()));
        return response.getID();
    }

    private int getCorrectTestInstanceID(int testID) throws IOException, PcException {
        if ("AUTO".equals(this.model.getAutoTestInstanceID())) {
            try {
                this.buildLogger.addBuildLogEntry("Searching for available Test Instance");
                PcTestInstances pcTestInstances = this.restProxy.getTestInstancesByTestId(testID);
                int testInstanceID = 0;
                if (pcTestInstances != null && pcTestInstances.getTestInstancesList() != null) {
                    PcTestInstance pcTestInstance = pcTestInstances.getTestInstancesList().get(pcTestInstances.getTestInstancesList().size() - 1);
                    testInstanceID = pcTestInstance.getInstanceId();
                    this.buildLogger.addBuildLogEntry("Found testInstanceId: " + testInstanceID);
                } else {
                    this.buildLogger.addBuildLogEntry("Could not find available TestInstanceID, Creating Test Instance.");
                    this.buildLogger.addBuildLogEntry("Searching for available TestSet");
                    PcTestSets pcTestSets = this.restProxy.GetAllTestSets();
                    if (pcTestSets != null && pcTestSets.getPcTestSetsList() != null) {
                        PcTestSet pcTestSet = pcTestSets.getPcTestSetsList().get(pcTestSets.getPcTestSetsList().size() - 1);
                        int testSetID = pcTestSet.getTestSetID();
                        this.buildLogger.addBuildLogEntry(String.format("Creating Test Instance with testID: %s and TestSetID: %s", testID, testSetID));
                        testInstanceID = this.restProxy.createTestInstance(testID, testSetID);
                        this.buildLogger.addBuildLogEntry(String.format("Test Instance with ID : %s has been created successfully.", testInstanceID));
                    } else {
                        String msg = "No TestSetID available in project, please create a TestSet from LoadRunner Enterprise UI";
                        this.buildLogger.addBuildLogEntry(msg);
                        throw new PcException(msg);
                    }
                }
                return testInstanceID;
            }
            catch (Exception e) {
                throw new PcException(String.format("getCorrectTestInstanceID failed, reason: %s", e));
            }
        }
        return Integer.parseInt(this.model.getTestInstanceId());
    }

    private void setCorrectTrendReportID() throws IOException, PcException {
        if ("ASSOCIATED".equals(this.model.getAddRunToTrendReport())) {
            PcTest pcTest = this.restProxy.getTestData(Integer.parseInt(this.model.getTestId()));
            if (pcTest.getTrendReportId() > -1) {
                this.model.setTrendReportId(String.valueOf(pcTest.getTrendReportId()));
            } else {
                String msg = "No trend report ID is associated with the test.\nPlease turn Automatic Trending on for the test through LoadRunner Enterprise UI.\nAlternatively you can check 'Add run to trend report with ID' on configuration dialog.";
                throw new PcException(msg);
            }
        }
    }

    public String getTestName() throws IOException, PcException {
        PcTest pcTest = this.restProxy.getTestData(Integer.parseInt(this.model.getTestId()));
        return pcTest.getTestName();
    }

    public PcRunResponse waitForRunCompletion(int runId) throws InterruptedException, ClientProtocolException, PcException, IOException {
        return this.waitForRunCompletion(runId, 5000);
    }

    public PcRunResponse waitForRunCompletion(int runId, int interval) throws InterruptedException, ClientProtocolException, PcException, IOException {
        RunState state = RunState.UNDEFINED;
        if (this.model.getPostRunAction().toString().equals(DO_NOTHING)) {
            state = RunState.BEFORE_COLLATING_RESULTS;
        } else if (this.model.getPostRunAction().toString().equals(COLLATE)) {
            state = RunState.BEFORE_CREATING_ANALYSIS_DATA;
        } else if (this.model.getPostRunAction().toString().equals(COLLATE_ANALYZE)) {
            state = RunState.FINISHED;
        }
        return this.waitForRunState(runId, state, interval);
    }

    private PcRunResponse waitForRunState(int runId, RunState completionState, int interval) throws InterruptedException, ClientProtocolException, PcException, IOException {
        int counter = 0;
        RunState[] states = new RunState[]{RunState.BEFORE_COLLATING_RESULTS, RunState.BEFORE_CREATING_ANALYSIS_DATA};
        PcRunResponse response = null;
        RunState lastState = RunState.UNDEFINED;
        do {
            response = this.restProxy.getRunData(runId);
            RunState currentState = RunState.get(response.getRunState());
            if (lastState.ordinal() < currentState.ordinal()) {
                lastState = currentState;
                this.buildLogger.addBuildLogEntry(String.format("RunID: %s - State = %s", runId, currentState.value()));
            }
            if (Arrays.asList(states).contains((Object)currentState)) {
                Thread.sleep(1000L);
                if (++counter <= 60) continue;
                this.buildLogger.addBuildLogEntry(String.format("RunID: %s  - Stopped from LoadRunner Enterprise side with state = %s", runId, currentState.value()));
                break;
            }
            counter = 0;
            Thread.sleep(interval);
        } while (lastState.ordinal() < completionState.ordinal());
        return response;
    }

    public String publishRunReport(int runId, String reportDirectory) throws IOException, PcException, InterruptedException {
        PcRunResults runResultsList = this.restProxy.getRunResults(runId);
        if (runResultsList.getResultsList() != null) {
            for (PcRunResult result : runResultsList.getResultsList()) {
                if (!result.getName().equals(pcReportArchiveName)) continue;
                File dir = new File(reportDirectory + File.separator + "Reports");
                dir.mkdirs();
                String reportArchiveFullPath = dir.getCanonicalPath() + IOUtils.DIR_SEPARATOR + pcReportArchiveName;
                this.buildLogger.addBuildLogEntry("Publishing analysis report");
                this.restProxy.GetRunResultData(runId, result.getID(), reportArchiveFullPath);
                File fp = new File(reportArchiveFullPath);
                this.unzip(reportArchiveFullPath, fp.getParent().toString());
                String reportFile = dir.getPath() + File.separator + pcReportFileName;
                this.publishHTMLReportToArtifact();
                return reportFile;
            }
        }
        this.buildLogger.addBuildLogEntry("Failed to get run report");
        return null;
    }

    public void publishHTMLReportToArtifact() {
        HashMap config = new HashMap();
        ArtifactDefinitionContextImpl artifact = new ArtifactDefinitionContextImpl("Build_" + String.valueOf(this.taskContext.getBuildContext().getBuildNumber()) + "_reports", false, null);
        artifact.setCopyPattern("**/*");
        this.taskContext.getBuildContext().getArtifactContext().getDefinitionContexts().add(artifact);
    }

    public boolean logout() {
        if (!this.loggedIn) {
            return true;
        }
        boolean logoutSucceeded = false;
        try {
            logoutSucceeded = this.restProxy.logout();
            this.loggedIn = !logoutSucceeded;
        }
        catch (PcException e) {
            this.buildLogger.addBuildLogEntry(e.getMessage());
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry(String.valueOf(e));
        }
        this.buildLogger.addBuildLogEntry(String.format("Logout %s", logoutSucceeded ? "succeeded" : "failed"));
        return logoutSucceeded;
    }

    public boolean stopRun(int runId) {
        boolean stopRunSucceeded = false;
        try {
            this.buildLogger.addBuildLogEntry("Stopping run");
            stopRunSucceeded = this.restProxy.stopRun(runId, "stop");
        }
        catch (PcException e) {
            this.buildLogger.addBuildLogEntry(e.getMessage());
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry(String.valueOf(e));
        }
        this.buildLogger.addBuildLogEntry(String.format("Stop run %s", stopRunSucceeded ? "succeeded" : "failed"));
        return stopRunSucceeded;
    }

    public PcRunEventLog getRunEventLog(int runId) {
        try {
            return this.restProxy.getRunEventLog(runId);
        }
        catch (PcException e) {
            this.buildLogger.addBuildLogEntry(e.getMessage());
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry(String.valueOf(e));
        }
        return null;
    }

    public void addRunToTrendReport(int runId, String trendReportId) {
        TrendReportRequest trRequest = new TrendReportRequest(this.model.getAlmProject(), runId, null);
        this.buildLogger.addBuildLogEntry("Adding run: " + runId + " to trend report: " + trendReportId);
        try {
            this.restProxy.updateTrendReport(trendReportId, trRequest);
            this.buildLogger.addBuildLogEntry("Publishing run: " + runId + " on trend report: " + trendReportId);
        }
        catch (PcException e) {
            this.buildLogger.addBuildLogEntry("Failed to add run to trend report: " + e.getMessage());
        }
        catch (IOException e) {
            this.buildLogger.addBuildLogEntry("Failed to add run to trend report: Problem connecting to PC Server");
        }
    }

    public void waitForRunToPublishOnTrendReport(int runId, String trendReportId) throws PcException, IOException, InterruptedException {
        ArrayList<PcTrendedRun> trendReportMetaDataResultsList;
        boolean publishEnded = false;
        int counter = 0;
        while (!(trendReportMetaDataResultsList = this.restProxy.getTrendReportMetaData(trendReportId)).isEmpty()) {
            for (PcTrendedRun result : trendReportMetaDataResultsList) {
                if (result.getRunID() != runId) continue;
                if (result.getState().equals(TRENDED) || result.getState().equals(ERROR)) {
                    publishEnded = true;
                    this.buildLogger.addBuildLogEntry("Run: " + runId + " publishing status: " + result.getState());
                    break;
                }
                Thread.sleep(5000L);
                if (++counter < 120) continue;
                String msg = "Error: Publishing didn't ended after 10 minutes, aborting...";
                throw new PcException(msg);
            }
            if (!publishEnded && counter < 120) continue;
        }
    }

    public void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                this.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    public boolean downloadTrendReportAsPdf(String trendReportId, String directory) throws PcException {
        try {
            this.buildLogger.addBuildLogEntry("Downloading trend report: " + trendReportId + " in PDF format");
            InputStream in = this.restProxy.getTrendingPDF(trendReportId);
            File dir = new File(directory);
            if (!dir.exists()) {
                dir.mkdirs();
            } else {
                FileUtils.deleteDirectory(dir);
                dir.mkdirs();
            }
            String filePath = directory + IOUtils.DIR_SEPARATOR + "trendReport" + trendReportId + ".pdf";
            Path destination = Paths.get(filePath, new String[0]);
            Files.copy(in, destination, StandardCopyOption.REPLACE_EXISTING);
            this.buildLogger.addBuildLogEntry("Trend report: " + trendReportId + " was successfully downloaded");
            this.buildLogger.addBuildLogEntry("View trend report in the Artifacts Tab.");
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry("Failed to download trend report: " + e.getMessage());
            throw new PcException(e.getMessage());
        }
        return true;
    }

    public Map<String, String> getTrendReportByXML(String trendReportId, int runId, TrendReportTypes.DataType dataType, TrendReportTypes.PctType pctType, TrendReportTypes.Measurement measurement) throws IOException, PcException, IntrospectionException, NoSuchMethodException {
        LinkedHashMap<String, String> measurmentsMap = new LinkedHashMap<String, String>();
        measurmentsMap.put("RunId", "_" + runId + "_");
        measurmentsMap.put("Trend Measurement Type", measurement.toString() + "_" + pctType.toString());
        TrendReportTransactionDataRoot res = this.restProxy.getTrendReportByXML(trendReportId, runId);
        List RowsListObj = res.getTrendReportRoot();
        for (int i = 0; i < RowsListObj.size(); ++i) {
            try {
                Method rowListMethod = RowsListObj.get(i).getClass().getMethod("getTrendReport" + dataType.toString() + "DataRowList", new Class[0]);
                for (Object DataRowObj : (ArrayList)rowListMethod.invoke(RowsListObj.get(i), new Object[0])) {
                    if (!DataRowObj.getClass().getMethod("getPCT_TYPE", new Class[0]).invoke(DataRowObj, new Object[0]).equals(pctType.toString())) continue;
                    Method method = DataRowObj.getClass().getMethod("get" + measurement.toString(), new Class[0]);
                    measurmentsMap.put(DataRowObj.getClass().getMethod("getPCT_NAME", new Class[0]).invoke(DataRowObj, new Object[0]).toString(), method.invoke(DataRowObj, new Object[0]) == null ? "" : method.invoke(DataRowObj, new Object[0]).toString());
                }
                continue;
            }
            catch (NoSuchMethodException rowListMethod) {
                continue;
            }
            catch (Exception e) {
                this.buildLogger.addBuildLogEntry("Error on getTrendReportByXML: " + e);
            }
        }
        return measurmentsMap;
    }
}

