/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.loadrunner.ui;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskRequirementSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class LoadRunnerTaskConfigurator
extends AbstractTaskConfigurator
implements TaskRequirementSupport {
    private static final String INT_REGEX = "[0-9]*";

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("tests", params.getString("tests"));
        config.put("timeout", params.getString("timeout"));
        config.put("pollingInterval", params.getString("pollingInterval"));
        config.put("execTimeout", params.getString("execTimeout"));
        config.put("ignoreErrors", params.getString("ignoreErrors"));
        return config;
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        String execTimeoutValue;
        String pollingValue;
        String timeoutValue;
        super.validate(params, errorCollection);
        String testsValue = params.getString("tests");
        if (!this.goodInput("tests", testsValue)) {
            errorCollection.addError("tests", "Error: Please add the paths of the tests you would like to run");
        }
        if (!this.goodInput("timeout", timeoutValue = params.getString("timeout"))) {
            errorCollection.addError("timeout", "Error: Please add the timeout in full seconds");
        }
        if (!this.goodInput("pollingInterval", pollingValue = params.getString("pollingInterval"))) {
            errorCollection.addError("pollingInterval", "Error: Please add the polling interval of the controller in full seconds");
        }
        if (!this.goodInput("execTimeout", execTimeoutValue = params.getString("execTimeout"))) {
            errorCollection.addError("execTimeout", "Error: Please add the scenario execution timeout in full seconds");
        }
    }

    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        Map conf = taskDefinition.getConfiguration();
        context.put("tests", conf.get("tests"));
        context.put("timeout", conf.get("timeout"));
        context.put("pollingInterval", conf.get("pollingInterval"));
        context.put("execTimeout", conf.get("execTimeout"));
        context.put("ignoreErrors", conf.get("ignoreErrors"));
    }

    public Set<Requirement> calculateRequirements(TaskDefinition taskDefinition) {
        return this.defineLoadRunnerRequirement();
    }

    private Set<Requirement> defineLoadRunnerRequirement() {
        RequirementImpl lrReq = new RequirementImpl("LoadRunner", true, ".*");
        HashSet<Requirement> result = new HashSet<Requirement>();
        result.add((Requirement)lrReq);
        return result;
    }

    private boolean goodInput(String key, String input) {
        boolean good = true;
        if (input != null) {
            if (StringUtils.isEmpty(input) && "tests".equals(key)) {
                good = false;
            } else if (("timeout".equals(key) || "pollingInterval".equals(key) || "execTimeout".equals(key)) && !StringUtils.isEmpty(input) && !input.matches(INT_REGEX)) {
                good = false;
            }
        }
        return good;
    }
}

