/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.loadrunner.task;

import com.adm.utils.loadrunner.LoadRunnerExecutor;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LoadRunnerTestTask
implements TaskType {
    public TaskResult execute(TaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        String workingDirectory = taskContext.getWorkingDirectory().getAbsolutePath();
        int buildNumber = taskContext.getBuildContext().getBuildNumber();
        String jobName = taskContext.getBuildContext().getBuildResultKey();
        String buildDirectoryPath = workingDirectory + "\\" + jobName + "_TR_" + buildNumber;
        File buildDirectory = new File(buildDirectoryPath);
        String tests = (String)taskContext.getConfigurationMap().get((Object)"tests");
        String timeout = (String)taskContext.getConfigurationMap().get((Object)"timeout");
        String pollingInterval = "".equals(taskContext.getConfigurationMap().get((Object)"pollingInterval")) ? "30" : (String)taskContext.getConfigurationMap().get((Object)"pollingInterval");
        String execTimeout = "".equals(taskContext.getConfigurationMap().get((Object)"execTimeout")) ? "10" : (String)taskContext.getConfigurationMap().get((Object)"execTimeout");
        String ignoreErrors = (String)taskContext.getConfigurationMap().get((Object)"ignoreErrors");
        buildLogger.addBuildLogEntry("**************************************************************************\n");
        buildLogger.addBuildLogEntry("**********************  Load Runner Test User Input  *********************\n");
        buildLogger.addBuildLogEntry("**************************************************************************\n");
        buildLogger.addBuildLogEntry("Tests: " + tests);
        buildLogger.addBuildLogEntry("Timeout: " + timeout);
        buildLogger.addBuildLogEntry("Controller Polling Interval: " + pollingInterval);
        buildLogger.addBuildLogEntry("Scenario Execution Timeout: " + execTimeout);
        buildLogger.addBuildLogEntry("Errors to Ignore: " + ignoreErrors);
        buildLogger.addBuildLogEntry("**************************************************************************\n");
        try {
            buildDirectory.mkdir();
            buildLogger.addBuildLogEntry("************ Copying the Load Runner executables to the agent ************\n");
            buildLogger.addBuildLogEntry("**************************************************************************\n");
            this.copyExecutable(buildDirectoryPath, "HpToolsLauncher.exe");
            buildLogger.addBuildLogEntry(String.format("Copied %s to the agent successfully", "HpToolsLauncher.exe"));
            this.copyExecutable(buildDirectoryPath, "HpToolsAborter.exe");
            buildLogger.addBuildLogEntry(String.format("Copied %s to the agent successfully", "HpToolsAborter.exe"));
            this.copyExecutable(buildDirectoryPath, "LRAnalysisLauncher.exe");
            buildLogger.addBuildLogEntry(String.format("Copied %s to the agent successfully", "LRAnalysisLauncher.exe"));
            buildLogger.addBuildLogEntry("**************************************************************************\n");
            buildLogger.addBuildLogEntry("***************  Creating the param file for the launcher  ***************\n");
            buildLogger.addBuildLogEntry("**************************************************************************\n");
            LoadRunnerExecutor lre = new LoadRunnerExecutor(tests, timeout, pollingInterval, execTimeout, ignoreErrors, buildDirectoryPath);
            String paramFileName = lre.createParamFile();
            buildLogger.addBuildLogEntry(String.format("Param file was created successfully in folder %s", buildDirectoryPath));
            buildLogger.addBuildLogEntry("**************************************************************************\n");
            buildLogger.addBuildLogEntry("*************************  Running the load test  ************************\n");
            buildLogger.addBuildLogEntry("**************************************************************************\n");
            int lrTestExitCode = this.runLoadTest(lre, paramFileName, buildLogger, false);
            buildLogger.addBuildLogEntry("Load Runner Exit code = " + lrTestExitCode);
            if (lrTestExitCode == -1) {
                buildLogger.addBuildLogEntry("Test run aborted by user. Stopping the run.");
                this.runLoadTest(lre, paramFileName, buildLogger, true);
            } else if (lrTestExitCode != 0) {
                throw new Exception("Error: Failed to run load test!");
            }
            buildLogger.addBuildLogEntry("**************************************************************************\n");
            buildLogger.addBuildLogEntry("************************* Preparing test results *************************\n");
            this.zipResultsFolder(buildDirectory);
            buildLogger.addBuildLogEntry("**************************************************************************\n");
        }
        catch (Exception e) {
            buildLogger.addBuildLogEntry(e.toString());
            return TaskResultBuilder.create((TaskContext)taskContext).failed().build();
        }
        return TaskResultBuilder.create((TaskContext)taskContext).success().build();
    }

    private String zipResultsFolder(File buildDirectory) throws Exception {
        String destZipFile = buildDirectory.getAbsolutePath() + "\\" + "Results.zip";
        String srcFolder = buildDirectory.getAbsolutePath() + "\\" + buildDirectory.list()[0] + "\\" + "LRR";
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        fileWriter = new FileOutputStream(destZipFile);
        zip = new ZipOutputStream(fileWriter);
        this.addFolderToZip("", srcFolder, zip);
        zip.flush();
        zip.close();
        return destZipFile;
    }

    private void addFileToZip(String path, String srcFile, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFile);
        if (!folder.exists()) {
            throw new Exception("Error: Results files missing");
        }
        if (folder.isDirectory()) {
            this.addFolderToZip(path, srcFile, zip);
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            zip.putNextEntry(new ZipEntry(path + "/" + folder.getName()));
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
        }
    }

    private void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFolder);
        for (String fileName : folder.list()) {
            if (path.equals("")) {
                this.addFileToZip(folder.getName(), srcFolder + "/" + fileName, zip);
                continue;
            }
            this.addFileToZip(path + "/" + folder.getName(), srcFolder + "/" + fileName, zip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyExecutable(String buildDirectoryPath, String resourceName) throws Exception {
        block8: {
            InputStream stream = null;
            OutputStream resStreamOut = null;
            String error = "";
            try {
                int readBytes;
                String resourcePath = "/Tools/" + resourceName;
                stream = this.getClass().getResourceAsStream(resourcePath);
                if (stream == null) {
                    throw new Exception(String.format("Error: The resource %s could not be found!", resourcePath));
                }
                byte[] buffer = new byte[4096];
                File resultPath = new File(buildDirectoryPath, resourceName);
                resStreamOut = new FileOutputStream(resultPath);
                while ((readBytes = stream.read(buffer)) > 0) {
                    resStreamOut.write(buffer, 0, readBytes);
                }
            }
            catch (Exception e) {
                error = e.toString();
            }
            finally {
                if (stream != null) {
                    stream.close();
                    resStreamOut.close();
                }
                if ("".equals(error)) break block8;
                throw new Exception(error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runLoadTest(LoadRunnerExecutor lre, String paramFileName, BuildLogger buildLogger, boolean abort) throws IOException {
        int result;
        String lrOutput;
        Process lrProcess = lre.run(abort ? "HpToolsAborter.exe" : "HpToolsLauncher.exe", paramFileName);
        InputStream processInputStream = lrProcess.getInputStream();
        BufferedReader buf = new BufferedReader(new InputStreamReader(processInputStream));
        while ((lrOutput = buf.readLine()) != null) {
            buildLogger.addBuildLogEntry(lrOutput);
        }
        try {
            result = lrProcess.waitFor();
        }
        catch (InterruptedException e) {
            result = -1;
        }
        finally {
            buf.close();
        }
        return result;
    }
}

