/*
 * Decompiled with CFR 0.152.
 */
package com.acunetix.tasks;

import com.acunetix.ConfigManager;
import com.acunetix.model.ScanType;
import com.acunetix.model.WebsiteModelRequest;
import com.acunetix.utility.AppCommon;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Acunetix360ScanTaskConfigurator
extends AbstractTaskConfigurator {
    private ConfigManager configManager = new ConfigManager();

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        try {
            this.populateForAll(context);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        Map existingConfiguration = taskDefinition.getConfiguration();
        try {
            this.populateForAll(context);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        context.put("acunetix360ScanType", existingConfiguration.get("acunetix360ScanType"));
        context.put("acunetix360WebsiteID", existingConfiguration.get("acunetix360WebsiteID"));
        context.put("acunetix360ProfileID", existingConfiguration.get("acunetix360ProfileID"));
        ErrorCollection er = this.configManager.getErrorCollection();
        if (er != null && er.getTotalErrors() > 0) {
            context.put("hideErrorDiv", "no");
            Map fieldErrors = er.getFieldErrors();
            if (!fieldErrors.isEmpty()) {
                for (Map.Entry st : fieldErrors.entrySet()) {
                    context.put((String)st.getKey() + "Error", ((List)st.getValue()).iterator().next());
                }
            }
        } else {
            context.put("hideErrorDiv", "");
        }
    }

    private void populateForAll(@NotNull Map<String, Object> context) throws MalformedURLException, URISyntaxException {
        WebsiteModelRequest websiteModelRequest = new WebsiteModelRequest(this.configManager.getApiUrl(), this.configManager.getApiToken());
        if (websiteModelRequest.HasError()) {
            if (!this.configManager.hasCredentials()) {
                context.put("acunetix360ErrorMessage", "Please, validate your credentials from Acunetix 360 global settings.");
            } else {
                context.put("acunetix360ErrorMessage", websiteModelRequest.getErrorMessage());
            }
        } else {
            String websitesJsonModel = websiteModelRequest.getWebsitesJsonModel();
            if (websiteModelRequest.HasError()) {
                String errorMessage = websiteModelRequest.getErrorMessage() == null ? "Unable to retrieve scan settins." : websiteModelRequest.getErrorMessage();
                context.put("acunetix360ErrorMessage", errorMessage);
            } else {
                context.put("acunetix360WebsitesJsonModel", websitesJsonModel);
                context.put("acunetix360HideWebsiteList", this.configManager.getHideWebsiteList());
            }
        }
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String websiteIDString;
        super.validate(params, errorCollection);
        if (!AppCommon.IsUrlValid(this.configManager.getApiUrl())) {
            errorCollection.addError("acunetix360ServerURL", "Server URL is not valid.");
        }
        if (AppCommon.IsNullOrEmpty(this.configManager.getApiToken())) {
            errorCollection.addError("acunetix360ApiToken", "Api token is not valid.");
        }
        String scanTypeString = params.getString("acunetix360ScanType");
        boolean isScanTypeValid = true;
        ScanType scanType = ScanType.FullWithPrimaryProfile;
        try {
            scanType = ScanType.valueOf(scanTypeString);
        }
        catch (Exception ex) {
            isScanTypeValid = false;
        }
        if (!isScanTypeValid) {
            errorCollection.addError("acunetix360ScanType", "Scan type is not valid.");
        }
        if (!AppCommon.IsGUIDValid(websiteIDString = params.getString("acunetix360WebsiteID"))) {
            errorCollection.addError("acunetix360WebsiteID", "Website is not valid.");
        }
        boolean isProfileRequired = scanType != ScanType.FullWithPrimaryProfile;
        String profileIDString = params.getString("acunetix360ProfileID");
        if (isProfileRequired && !AppCommon.IsGUIDValid(profileIDString)) {
            errorCollection.addError("acunetix360ProfileID", "Scan profile is not valid.");
        }
        this.configManager.setErrorCollection(errorCollection);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("acunetix360ScanType", params.getString("acunetix360ScanType"));
        config.put("acunetix360WebsiteID", params.getString("acunetix360WebsiteID"));
        config.put("acunetix360ProfileID", params.getString("acunetix360ProfileID"));
        config.put("acunetix360HideWebsiteList", params.getString("acunetix360HideWebsiteList"));
        return config;
    }
}

