/*
 * Decompiled with CFR 0.152.
 */
package com.acunetix.rest;

import com.acunetix.model.ScanReport;
import com.acunetix.tasks.Acunetix360ScanHelper;
import com.acunetix.utility.AppCommon;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/report/{scantaskid}")
public class Report {
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response getMessage(@PathParam(value="scantaskid") String scanTaskID) {
        boolean isModelValid = AppCommon.IsGUIDValid(scanTaskID);
        if (!isModelValid) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Acunetix360ScanHelper acunetix360ScanHelper = new Acunetix360ScanHelper();
        try {
            ScanReport scanReport = acunetix360ScanHelper.GetScanReport(scanTaskID);
            return Response.ok((Object)scanReport.getContent()).build();
        }
        catch (Exception ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }
}

