/*
 * Decompiled with CFR 0.152.
 */
package com.acunetix.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class VCSCommit {
    private final String ciBuildServerVersion;
    private final String ciNcPluginVersion;
    private final String buildId;
    private final String buildConfigurationName;
    private final String buildURL;
    private final boolean buildHasChange;
    private final String versionControlName;
    private final String committer;
    private final String vcsVersion;
    private final String ciTimestamp;

    public static VCSCommit Empty() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        String dateString = dateFormat.format(new Date());
        return new VCSCommit("", "", "", "", "", false, "", "", "", dateString);
    }

    public VCSCommit(String bambooVersion, String pluginVersion, String buildId, String buildConfigurationName, String buildURL, boolean buildHasChange, String versionControlName, String Committer, String vcsVersion, String ciTimestamp) {
        this.ciBuildServerVersion = bambooVersion;
        this.ciNcPluginVersion = pluginVersion;
        this.buildId = buildId;
        this.buildConfigurationName = buildConfigurationName;
        this.buildURL = buildURL;
        this.buildHasChange = buildHasChange;
        this.versionControlName = versionControlName;
        this.committer = Committer;
        this.vcsVersion = vcsVersion;
        this.ciTimestamp = ciTimestamp;
    }

    public void setRootURL(String rootURL) {
        if (rootURL == null) {
            return;
        }
    }

    public String getCiBuildServerVersion() {
        return this.ciBuildServerVersion;
    }

    public String getCiNcPluginVersion() {
        return this.ciNcPluginVersion;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getBuildConfigurationName() {
        return this.buildConfigurationName;
    }

    public String getBuildURL() {
        return this.buildURL;
    }

    public boolean BuildHasChange() {
        return this.buildHasChange;
    }

    public String getVersionControlName() {
        return this.versionControlName;
    }

    public String getCommitter() {
        return this.committer;
    }

    public String getVcsVersion() {
        return this.vcsVersion;
    }

    public String getCiTimestamp() {
        return this.ciTimestamp;
    }

    public void addVcsCommitInfo(List<NameValuePair> params) {
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiBuildId", this.buildId));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.IntegrationSystem", "Bamboo"));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiBuildServerVersion", this.ciBuildServerVersion));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiNcPluginVersion", this.ciNcPluginVersion));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiBuildConfigurationName", this.buildConfigurationName));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiBuildUrl", this.buildURL));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiBuildHasChange", String.valueOf(this.buildHasChange)));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiTimestamp", this.ciTimestamp));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.VcsName", this.versionControlName));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.VcsVersion", this.vcsVersion));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.Committer", this.committer));
    }
}

