/*
 * Decompiled with CFR 0.152.
 */
package com.acunetix.model;

import com.acunetix.model.ScanReport;
import com.acunetix.model.ScanRequestBase;
import com.acunetix.utility.AppCommon;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONObject;

public class ScanRequestResult
extends ScanRequestBase {
    private String scanReportEndpoint;
    private final int httpStatusCode;
    private String data;
    private String scanTaskID;
    private boolean isError;
    private String errorMessage;
    private ScanReport report = null;
    private Date previousRequestTime;
    private final String scanReportRelativeUrl = "api/1.0/scans/report/";

    public static ScanRequestResult errorResult(String errorMessage) {
        return new ScanRequestResult(errorMessage);
    }

    private ScanRequestResult(String errorMessage) {
        this.errorMessage = errorMessage;
        this.httpStatusCode = 0;
        this.isError = true;
        this.data = "";
    }

    public ScanRequestResult(HttpResponse response, String apiURL, String apiToken) throws MalformedURLException {
        super(apiURL, apiToken);
        this.httpStatusCode = response.getStatusLine().getStatusCode();
        boolean bl = this.isError = this.httpStatusCode != 201;
        if (!this.isError) {
            try {
                this.data = AppCommon.parseResponseToString(response);
                JSONObject jsonObj = new JSONObject(this.data);
                boolean bl2 = this.isError = !jsonObj.getBoolean("IsValid");
                if (!this.isError) {
                    this.scanTaskID = jsonObj.getString("ScanTaskId");
                } else {
                    this.errorMessage = jsonObj.getString("ErrorMessage");
                }
            }
            catch (Exception ex) {
                this.isError = true;
                this.errorMessage = "Scan request result is not readable::: " + ex.toString();
            }
        }
        this.setScanReportEndpoint();
    }

    public ScanRequestResult(String apiURL, String apiToken, String scanTaskID) throws MalformedURLException {
        super(apiURL, apiToken);
        this.scanTaskID = scanTaskID;
        this.httpStatusCode = 201;
        this.setScanReportEndpoint();
    }

    private void setScanReportEndpoint() throws MalformedURLException {
        HashMap<String, String> queryparams = new HashMap<String, String>();
        queryparams.put("Type", "ExecutiveSummary");
        queryparams.put("Format", "Html");
        queryparams.put("Id", this.scanTaskID);
        this.scanReportEndpoint = new URL(this.ApiURL, "api/1.0/scans/report/").toString() + "?" + AppCommon.mapToQueryString(queryparams);
    }

    public String getScanTaskID() {
        return this.scanTaskID;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isError() {
        return this.isError;
    }

    public ScanReport getReport() {
        if (this.canAskForReportFromNCCloud()) {
            ScanReport reportFromNcCloud = this.getReportFromNcCloud();
            this.previousRequestTime = new Date();
            this.report = reportFromNcCloud;
            return this.report;
        }
        return this.report;
    }

    private boolean canAskForReportFromNCCloud() {
        Date now = new Date();
        boolean isTimeThresholdPassed = this.previousRequestTime == null || now.getTime() - this.previousRequestTime.getTime() >= 60000L;
        return isTimeThresholdPassed || !this.isReportAvailable();
    }

    private boolean isReportAvailable() {
        return this.report != null && this.report.isReportGenerated();
    }

    private ScanReport getReportFromNcCloud() {
        ScanReport reportFromApi;
        if (!this.isError) {
            try {
                HttpClient httpClient = this.getHttpClient();
                HttpGet httpGet = new HttpGet(this.scanReportEndpoint);
                httpGet.setHeader("Authorization", this.getAuthHeader());
                HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                reportFromApi = new ScanReport(response, this.scanReportEndpoint);
            }
            catch (IOException ex) {
                String reportRequestErrorMessage = "Report result is not readable::: " + ex.toString();
                reportFromApi = new ScanReport(false, "", true, reportRequestErrorMessage, this.scanReportEndpoint);
            }
        } else {
            reportFromApi = new ScanReport(true, this.errorMessage, false, "", this.scanReportEndpoint);
        }
        this.report = reportFromApi;
        return reportFromApi;
    }
}

