/*
 * Decompiled with CFR 0.152.
 */
package com.acunetix.model;

import com.acunetix.model.ScanRequestBase;
import com.acunetix.model.ScanType;
import com.acunetix.model.VCSCommit;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;

public class ScanRequest
extends ScanRequestBase {
    public static final String SCAN_TYPE_Literal = "acunetix360ScanType";
    public static final String WEBSITE_ID_Literal = "acunetix360WebsiteID";
    public static final String PROFILE_ID_Literal = "acunetix360ProfileID";
    public final ScanType scanType;
    public final String websiteId;
    public final String profileId;
    public final VCSCommit vcsCommit;
    public final URI scanUri;
    public final URI testUri;
    private final String json = "application/json";

    public ScanRequest(String apiURL, String apiToken, String scanType, String websiteId, String profileId, VCSCommit vcsCommit) throws MalformedURLException, NullPointerException, URISyntaxException {
        super(apiURL, apiToken);
        this.scanType = ScanType.valueOf(scanType);
        this.websiteId = websiteId;
        this.profileId = profileId;
        this.vcsCommit = vcsCommit;
        this.scanUri = this.getRequestEndpoint();
        this.testUri = this.getTestEndpoint();
    }

    public HttpResponse scanRequest() throws IOException {
        HttpClient client = this.getHttpClient();
        HttpPost httpPost = new HttpPost(this.scanUri);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Authorization", this.getAuthHeader());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.setScanParams(params);
        this.vcsCommit.addVcsCommitInfo(params);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        return response;
    }

    private URI getRequestEndpoint() throws MalformedURLException, URISyntaxException {
        String relativePath = "api/1.0/scans/CreateFromPluginScanRequest";
        return new URL(this.ApiURL, relativePath).toURI();
    }

    private URI getTestEndpoint() throws MalformedURLException, URISyntaxException {
        String relativePath = "api/1.0/scans/VerifyPluginScanRequest";
        return new URL(this.ApiURL, relativePath).toURI();
    }

    private void setScanParams(List<NameValuePair> params) {
        switch (this.scanType) {
            case Incremental: {
                params.add((NameValuePair)new BasicNameValuePair("WebsiteId", this.websiteId));
                params.add((NameValuePair)new BasicNameValuePair("ProfileId", this.profileId));
                params.add((NameValuePair)new BasicNameValuePair("ScanType", "Incremental"));
                break;
            }
            case FullWithPrimaryProfile: {
                params.add((NameValuePair)new BasicNameValuePair("WebsiteId", this.websiteId));
                params.add((NameValuePair)new BasicNameValuePair("ScanType", "FullWithPrimaryProfile"));
                break;
            }
            case FullWithSelectedProfile: {
                params.add((NameValuePair)new BasicNameValuePair("WebsiteId", this.websiteId));
                params.add((NameValuePair)new BasicNameValuePair("ProfileId", this.profileId));
                params.add((NameValuePair)new BasicNameValuePair("ScanType", "FullWithSelectedProfile"));
                break;
            }
        }
    }
}

