/*
 * Decompiled with CFR 0.152.
 */
package com.acunetix;

import com.acunetix.utility.AppCommon;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;

public class PluginSettings
extends BambooActionSupport
implements GlobalAdminSecurityAware {
    private String apiUrl;
    private String apiToken;
    private String hideWebsiteList;
    @ComponentImport
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @ComponentImport
    private final AdministrationConfigurationPersister administrationConfigurationPersister;
    @ComponentImport
    private final BandanaManager bandanaManager;

    @Inject
    public PluginSettings(AdministrationConfigurationAccessor administrationConfigurationAccessor, AdministrationConfigurationPersister administrationConfigurationPersister, BandanaManager bandanaManager) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.administrationConfigurationPersister = administrationConfigurationPersister;
        this.bandanaManager = bandanaManager;
        this.setAdministrationConfigurationAccessor(administrationConfigurationAccessor);
        this.setAdministrationConfigurationPersister(administrationConfigurationPersister);
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public String getHideWebsiteList() {
        return this.hideWebsiteList;
    }

    public void setHideWebsiteList(String hideWebsiteList) {
        this.hideWebsiteList = hideWebsiteList;
    }

    public String doEdit() {
        this.setApiUrl(this.getValue("acunetix360ServerURL"));
        this.setApiToken(this.getValue("acunetix360ApiToken"));
        this.setHideWebsiteList(this.getValue("acunetix360HideWebsiteList"));
        return "input";
    }

    public String doSave() {
        boolean hasError = false;
        if (!AppCommon.IsUrlValid(this.getApiUrl())) {
            hasError = true;
            this.addActionError("Please enter valid URL.");
        }
        if (AppCommon.IsNullOrEmpty(this.getApiToken())) {
            hasError = true;
            this.addActionError("API Token can't be empty.");
        }
        if (hasError) {
            return "error";
        }
        this.setValue("acunetix360ServerURL", this.getApiUrl());
        this.setValue("acunetix360ApiToken", this.getApiToken());
        this.setValue("acunetix360HideWebsiteList", this.getHideWebsiteList());
        this.addActionMessage("Global settings updated.");
        return "success";
    }

    private String getValue(String key) {
        Object value = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.acunetix:" + key);
        return (String)value;
    }

    private void setValue(String key, String value) {
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.acunetix:" + key, (Object)value);
    }
}

