/*
 * Decompiled with CFR 0.152.
 */
package com.acunetix;

import com.acunetix.utility.AppCommon;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.spring.container.ContainerManager;

public class ConfigManager {
    private BandanaManager bandanaManager = (BandanaManager)ContainerManager.getComponent((String)"bandanaManager");
    private ErrorCollection errorCollection;
    private final String pluginKey = "com.acunetix:";
    private final String scanTaskKey = "ScanTaskID";

    public ConfigManager() {
        this.bandanaManager.init();
    }

    public boolean hasCredentials() {
        return AppCommon.IsUrlValid(this.get("acunetix360ServerURL")) && AppCommon.IsNullOrEmpty(this.get("acunetix360ApiToken"));
    }

    public String getApiUrl() {
        return this.get("acunetix360ServerURL");
    }

    public String getApiToken() {
        return this.get("acunetix360ApiToken");
    }

    public String getHideWebsiteList() {
        return this.get("acunetix360HideWebsiteList");
    }

    public String getScanTaskID(String planKey, String buildNumber) {
        String buildSpecificKey = planKey + "-" + buildNumber;
        return this.getBuildParameter(buildSpecificKey, "ScanTaskID");
    }

    public void setScanTaskID(String planKey, String buildNumber, String scanTaskID) {
        String buildSpecificKey = planKey + "-" + buildNumber;
        this.setBuildParameter(buildSpecificKey, "ScanTaskID", scanTaskID);
    }

    public ErrorCollection getErrorCollection() {
        return this.errorCollection;
    }

    public void setErrorCollection(ErrorCollection errorCollection) {
        this.errorCollection = errorCollection;
    }

    private String get(String key) {
        return (String)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.acunetix:" + key);
    }

    private void setBuildParameter(String buildSpecificKey, String key, String value) {
        String pluginSpecificBuildKey = "com.acunetix::" + buildSpecificKey;
        String parameterKey = pluginSpecificBuildKey + ":" + key;
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, parameterKey, (Object)value);
    }

    private String getBuildParameter(String buildSpecificKey, String key) {
        String pluginSpecificBuildKey = "com.acunetix::" + buildSpecificKey;
        String parameterKey = pluginSpecificBuildKey + ":" + key;
        Object value = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, parameterKey);
        return (String)value;
    }
}

