/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bitbucket.dc.settings;

import ch.mibex.bitbucket.dc.rest.RestPermissions;
import ch.mibex.bitbucket.dc.rest.RestResource;
import ch.mibex.bitbucket.dc.settings.AppSettings;
import ch.mibex.bitbucket.dc.settings.InheritedToggleConfig;
import ch.mibex.bitbucket.dc.settings.InheritedToggleConfig$;
import ch.mibex.bitbucket.dc.settings.Scope;
import ch.mibex.bitbucket.dc.settings.Scope$Project$;
import ch.mibex.bitbucket.dc.settings.Scope$Repo$;
import ch.mibex.bitbucket.dc.settings.StoredAppSettings;
import ch.mibex.bitbucket.dc.settings.ToggleConfig$;
import ch.mibex.utils.ee.rs.RestResponses;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PathParam;
import java.io.Serializable;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class SettingsResource
implements RestResource {
    private final I18nService ch$mibex$bitbucket$dc$rest$RestResource$$i18nService;
    private final RestResponses ch$mibex$bitbucket$dc$rest$RestResource$$restResponses;
    private final RepositoryService repositoryService;
    private final RestPermissions permissions;

    public SettingsResource(I18nService i18nService, RepositoryService repositoryService, RestPermissions permissions) {
        this.repositoryService = repositoryService;
        this.permissions = permissions;
        this.ch$mibex$bitbucket$dc$rest$RestResource$$i18nService = i18nService;
        this.ch$mibex$bitbucket$dc$rest$RestResource$$restResponses = permissions.restResponses();
        RestResource.$init$(this);
    }

    @Override
    public I18nService ch$mibex$bitbucket$dc$rest$RestResource$$i18nService() {
        return this.ch$mibex$bitbucket$dc$rest$RestResource$$i18nService;
    }

    @Override
    public RestResponses ch$mibex$bitbucket$dc$rest$RestResource$$restResponses() {
        return this.ch$mibex$bitbucket$dc$rest$RestResource$$restResponses;
    }

    public abstract AppSettings settings();

    public abstract StoredAppSettings storageSetting();

    @Path(value="projects/{projectKey}/settings")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/settings")
    @javax.ws.rs.GET
    @GET
    public Object getProjectSettings(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey) {
        scala.collection.immutable.Map result = ((IterableOnceOps)this.settings().allSettingsTyped(SettingsResource::$anonfun$1).map((Function1<AppSettings.Setting, Tuple2> & Serializable)s -> {
            String string2 = Predef$.MODULE$.ArrowAssoc(s.settingName());
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToBoolean(this.storageSetting().retrieveValue(s).apply(projectKey).active($less$colon$less$.MODULE$.refl())));
        })).toMap($less$colon$less$.MODULE$.refl());
        return this.okJ(CollectionConverters$.MODULE$.MapHasAsJava(result).asJava(), this.okJ$default$2(), this.okJ$default$3());
    }

    @Path(value="projects/{projectKey}/settings/{setting}")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/settings/{setting}")
    @javax.ws.rs.GET
    @GET
    public Object getProjectSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName) {
        Option response = this.settings().find(settingName, SettingsResource::$anonfun$3).map((Function1<AppSettings.Setting, Object> & Serializable)setting -> {
            boolean enabled = this.storageSetting().retrieveValue(setting).apply(Scope$Project$.MODULE$.apply(projectKey)).active($less$colon$less$.MODULE$.refl());
            return this.okJ(ToggleConfig$.MODULE$.apply(Predef$.MODULE$.boolean2Boolean(enabled)), this.okJ$default$2(), this.okJ$default$3());
        });
        return response.getOrElse(this::getProjectSetting$$anonfun$1);
    }

    @Path(value="projects/{projectKey}/settings/{setting}/enabled")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/settings/{setting}/enabled")
    @PUT
    @jakarta.ws.rs.PUT
    public Object enableProjectSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String setting) {
        return this.setProjectSetting(projectKey, setting, true);
    }

    @jakarta.ws.rs.Path(value="projects/{projectKey}/settings/{setting}/disabled")
    @PUT
    @jakarta.ws.rs.PUT
    public Object disableAppProjectSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String setting) {
        return this.setProjectSetting(projectKey, setting, false);
    }

    @Path(value="projects/{projectKey}/repos/{repoSlug}/settings")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/repos/{repoSlug}/settings")
    @javax.ws.rs.GET
    @GET
    public Object getRepoSettings(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="repoSlug") @PathParam(value="repoSlug") String repoSlug) {
        return Option$.MODULE$.apply(this.repositoryService.getBySlug(projectKey, repoSlug)).map((Function1<Repository, Object> & Serializable)repo -> {
            java.util.Map projectSetting = CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)this.settings().allSettingsTyped(SettingsResource::$anonfun$5).map((Function1<AppSettings.Setting, Tuple2> & Serializable)s -> {
                String string2 = Predef$.MODULE$.ArrowAssoc(s.settingName());
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToBoolean(this.storageSetting().retrieveValue(s).apply(projectKey).active($less$colon$less$.MODULE$.refl())));
            })).toMap($less$colon$less$.MODULE$.refl())).asJava();
            java.util.Map repoSetting = CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)this.settings().allSettingsTyped(SettingsResource::$anonfun$7).map((Function1<AppSettings.Setting, Tuple2> & Serializable)s -> {
                InheritedToggleConfig toggle = this.inheritedToggle((AppSettings.Setting<Object>)s, (Repository)repo);
                String string2 = Predef$.MODULE$.ArrowAssoc(s.settingName());
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, toggle);
            })).toMap($less$colon$less$.MODULE$.refl())).asJava();
            Tuple2[] tuple2Array = new Tuple2[2];
            String string2 = Predef$.MODULE$.ArrowAssoc("project");
            tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, projectSetting);
            String string3 = Predef$.MODULE$.ArrowAssoc("repo");
            tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, repoSetting);
            return this.okJ(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array))).asJava(), this.okJ$default$2(), this.okJ$default$3());
        }).getOrElse(() -> this.getRepoSettings$$anonfun$2(projectKey, repoSlug));
    }

    @Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}")
    @javax.ws.rs.GET
    @GET
    public Object getRepoSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="repoSlug") @PathParam(value="repoSlug") String repoSlug, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName) {
        Option response = Option$.MODULE$.apply(this.repositoryService.getBySlug(projectKey, repoSlug)).flatMap((Function1<Repository, Option> & Serializable)repo -> this.settings().find(settingName, SettingsResource::$anonfun$9$$anonfun$1).map((Function1<AppSettings.Setting, Object> & Serializable)setting -> {
            InheritedToggleConfig toggle = this.inheritedToggle((AppSettings.Setting<Object>)setting, (Repository)repo);
            return this.okJ(toggle, this.okJ$default$2(), this.okJ$default$3());
        }));
        return response.getOrElse(this::getRepoSetting$$anonfun$1);
    }

    @Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}/enabled")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}/enabled")
    @PUT
    @jakarta.ws.rs.PUT
    public Object enableRepoSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="repoSlug") @PathParam(value="repoSlug") String repoSlug, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName) {
        return this.setRepoSetting(projectKey, repoSlug, settingName, true);
    }

    @Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}/disabled")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}/disabled")
    @PUT
    @jakarta.ws.rs.PUT
    public Object disableRepoSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="repoSlug") @PathParam(value="repoSlug") String repoSlug, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName) {
        return this.setRepoSetting(projectKey, repoSlug, settingName, false);
    }

    @jakarta.ws.rs.Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}")
    @javax.ws.rs.DELETE
    @DELETE
    public Object removeRepoSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="repoSlug") @PathParam(value="repoSlug") String repoSlug, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName) {
        return this.permissions.requiresRepoAdmin(projectKey, repoSlug, (Function1<Repository, Object> & Serializable)repo -> this.settings().find(settingName, SettingsResource::removeRepoSetting$$anonfun$1$$anonfun$1).map((Function1<AppSettings.Setting, Object> & Serializable)setting -> {
            this.storageSetting().retrieveValue(setting).apply(Scope$Repo$.MODULE$.apply(repo.getProject().getKey(), repo.getSlug(), repo.getId())).delete();
            return this.okJ(this.inheritedToggle((AppSettings.Setting<Object>)setting, (Repository)repo), this.okJ$default$2(), this.okJ$default$3());
        }).getOrElse(this::removeRepoSetting$$anonfun$1$$anonfun$3));
    }

    private InheritedToggleConfig inheritedToggle(AppSettings.Setting<Object> setting, Repository repo) {
        Scope.Repo repoScope = Scope$Repo$.MODULE$.apply(repo.getProject().getKey(), repo.getSlug(), repo.getId());
        boolean enabled = this.storageSetting().retrieveValue(setting).apply(repoScope).active($less$colon$less$.MODULE$.refl());
        boolean appActive = this.storageSetting().retrieveValue(this.settings().appEnabled()).apply(repo).active($less$colon$less$.MODULE$.refl());
        boolean inheritedValue = this.storageSetting().retrieveValue(setting).apply(repoScope).scoped().isEmpty();
        return InheritedToggleConfig$.MODULE$.apply(Predef$.MODULE$.boolean2Boolean(enabled), Predef$.MODULE$.boolean2Boolean(inheritedValue), Predef$.MODULE$.boolean2Boolean(appActive));
    }

    private Object setProjectSetting(String projectKey, String settingName, boolean enable) {
        return this.permissions.requiresProjectAdmin(projectKey, (Function1<Project, Object> & Serializable)_$1 -> this.settings().find(settingName, SettingsResource::setProjectSetting$$anonfun$1$$anonfun$1).map((Function1<AppSettings.Setting, StoredAppSettings.GenericSetting> & Serializable)_$2 -> this.storageSetting().retrieveValue(_$2).apply(Scope$Project$.MODULE$.apply(projectKey))).map((Function1<StoredAppSettings.GenericSetting, Object> & Serializable)setting -> {
            setting.enable(enable, $less$colon$less$.MODULE$.refl());
            return this.okJ(ToggleConfig$.MODULE$.apply(Predef$.MODULE$.boolean2Boolean(enable)), this.okJ$default$2(), this.okJ$default$3());
        }).getOrElse(this::setProjectSetting$$anonfun$1$$anonfun$4));
    }

    private Object setRepoSetting(String projectKey, String repoSlug, String settingName, boolean enable) {
        return this.permissions.requiresRepoAdmin(projectKey, repoSlug, (Function1<Repository, Object> & Serializable)repo -> this.settings().find(settingName, SettingsResource::setRepoSetting$$anonfun$1$$anonfun$1).map((Function1<AppSettings.Setting, Object> & Serializable)setting -> {
            this.storageSetting().retrieveValue(setting).apply(Scope$Repo$.MODULE$.apply(repo.getProject().getKey(), repo.getSlug(), repo.getId())).enable(enable, $less$colon$less$.MODULE$.refl());
            return this.okJ(this.inheritedToggle((AppSettings.Setting<Object>)setting, (Repository)repo), this.okJ$default$2(), this.okJ$default$3());
        }).getOrElse(this::setRepoSetting$$anonfun$1$$anonfun$3));
    }

    private static final Option $anonfun$1(Object s) {
        if (s instanceof Boolean) {
            return Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(BoxesRunTime.unboxToBoolean(s)));
        }
        return None$.MODULE$;
    }

    private static final Option $anonfun$3(Object s) {
        if (s instanceof Boolean) {
            return Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(BoxesRunTime.unboxToBoolean(s)));
        }
        return None$.MODULE$;
    }

    private final Object getProjectSetting$$anonfun$1() {
        return this.notFound();
    }

    private static final Option $anonfun$5(Object s) {
        if (s instanceof Boolean) {
            return Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(BoxesRunTime.unboxToBoolean(s)));
        }
        return None$.MODULE$;
    }

    private static final Option $anonfun$7(Object s) {
        if (s instanceof Boolean) {
            return Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(BoxesRunTime.unboxToBoolean(s)));
        }
        return None$.MODULE$;
    }

    private final Object getRepoSettings$$anonfun$2(String projectKey$5, String repoSlug$1) {
        return this.noSuchRepoException(projectKey$5, repoSlug$1).getResponse(this.given_RestResponses());
    }

    private static final Option $anonfun$9$$anonfun$1(Object s) {
        if (s instanceof Boolean) {
            return Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(BoxesRunTime.unboxToBoolean(s)));
        }
        return None$.MODULE$;
    }

    private final Object getRepoSetting$$anonfun$1() {
        return this.notFound();
    }

    private static final Option removeRepoSetting$$anonfun$1$$anonfun$1(Object s) {
        if (s instanceof Boolean) {
            return Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(BoxesRunTime.unboxToBoolean(s)));
        }
        return None$.MODULE$;
    }

    private final Object removeRepoSetting$$anonfun$1$$anonfun$3() {
        return this.notFound();
    }

    private static final Option setProjectSetting$$anonfun$1$$anonfun$1(Object s) {
        if (s instanceof Boolean) {
            return Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(BoxesRunTime.unboxToBoolean(s)));
        }
        return None$.MODULE$;
    }

    private final Object setProjectSetting$$anonfun$1$$anonfun$4() {
        return this.notFound();
    }

    private static final Option setRepoSetting$$anonfun$1$$anonfun$1(Object s) {
        if (s instanceof Boolean) {
            return Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(BoxesRunTime.unboxToBoolean(s)));
        }
        return None$.MODULE$;
    }

    private final Object setRepoSetting$$anonfun$1$$anonfun$3() {
        return this.notFound();
    }
}

