/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bitbucket.dc.settings;

import ch.mibex.atlassian.Logging;
import ch.mibex.bitbucket.dc.rest.RestPermissions;
import ch.mibex.bitbucket.dc.rest.RestResource;
import ch.mibex.bitbucket.dc.settings.AppSettings;
import ch.mibex.bitbucket.dc.settings.ConfigAsString$;
import ch.mibex.bitbucket.dc.settings.InheritedConfigAsString;
import ch.mibex.bitbucket.dc.settings.InheritedConfigAsString$;
import ch.mibex.bitbucket.dc.settings.InheritedValueAsString;
import ch.mibex.bitbucket.dc.settings.InheritedValueAsString$;
import ch.mibex.bitbucket.dc.settings.Scope;
import ch.mibex.bitbucket.dc.settings.Scope$;
import ch.mibex.bitbucket.dc.settings.Scope$Project$;
import ch.mibex.bitbucket.dc.settings.Scope$Repo$;
import ch.mibex.bitbucket.dc.settings.StoredAppSettings;
import ch.mibex.utils.ee.ServletResponse$;
import ch.mibex.utils.ee.rs.CacheInfo;
import ch.mibex.utils.ee.rs.RestResponses;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.circe.Decoder;
import io.circe.Error;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PathParam;
import java.io.Serializable;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NamedTuple$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public abstract class GenericSettingsResource
implements RestResource,
Logging {
    private final I18nService ch$mibex$bitbucket$dc$rest$RestResource$$i18nService;
    private final RestResponses ch$mibex$bitbucket$dc$rest$RestResource$$restResponses;
    private volatile Logger ch$mibex$atlassian$Logging$$logger;
    private final RepositoryService repositoryService;
    private final RestPermissions permissions;
    private final NavBuilder navBuilder;

    public GenericSettingsResource(I18nService i18nService, RepositoryService repositoryService, RestPermissions permissions, NavBuilder navBuilder) {
        this.repositoryService = repositoryService;
        this.permissions = permissions;
        this.navBuilder = navBuilder;
        this.ch$mibex$bitbucket$dc$rest$RestResource$$i18nService = i18nService;
        this.ch$mibex$bitbucket$dc$rest$RestResource$$restResponses = permissions.restResponses();
        RestResource.$init$(this);
        Logging.$init$(this);
    }

    @Override
    public I18nService ch$mibex$bitbucket$dc$rest$RestResource$$i18nService() {
        return this.ch$mibex$bitbucket$dc$rest$RestResource$$i18nService;
    }

    @Override
    public RestResponses ch$mibex$bitbucket$dc$rest$RestResource$$restResponses() {
        return this.ch$mibex$bitbucket$dc$rest$RestResource$$restResponses;
    }

    @Override
    public Logger ch$mibex$atlassian$Logging$$logger() {
        return this.ch$mibex$atlassian$Logging$$logger;
    }

    @Override
    public void ch$mibex$atlassian$Logging$$logger_$eq(Logger x$1) {
        this.ch$mibex$atlassian$Logging$$logger = x$1;
    }

    public abstract AppSettings settings();

    public abstract StoredAppSettings settingStorage();

    private Object responseForScope(String settingName, Scope scope) {
        Option response = this.settings().findUntyped(settingName).map((Function1<AppSettings.Setting, Object> & Serializable)setting -> {
            Option<String> stringValue = this.settingStorage().retrieveValue(setting).apply(scope).scopedAsString();
            return this.okJ(ConfigAsString$.MODULE$.apply((String)stringValue.orNull($less$colon$less$.MODULE$.refl())), this.okJ$default$2(), this.okJ$default$3());
        });
        return response.getOrElse(this::responseForScope$$anonfun$1);
    }

    private Either<Object, InheritedValueAsString> inheritedStatus(String settingName, Scope scope) {
        return this.settings().findUntyped(settingName).toRight(() -> this.inheritedStatus$$anonfun$1(settingName)).map((Function1<AppSettings.Setting, Tuple3> & Serializable)setting -> {
            Tuple3 x$proxy6;
            Tuple3 x$proxy4;
            Tuple3 x$proxy2;
            Tuple3 inheritedStatus = this.settingStorage().retrieveValue(setting).apply(scope).inheritedStatus();
            NamedTuple$ namedTuple$ = NamedTuple$.MODULE$;
            Tuple3 x$proxy1 = inheritedStatus;
            NamedTuple$ namedTuple$2 = namedTuple$;
            Tuple3 Tuple_this = x$proxy2 = x$proxy1;
            Boolean bl = Predef$.MODULE$.boolean2Boolean(BoxesRunTime.unboxToBoolean(Tuple_this._1()));
            NamedTuple$ namedTuple$3 = NamedTuple$.MODULE$;
            Tuple3 x$proxy3 = inheritedStatus;
            NamedTuple$ namedTuple$4 = namedTuple$3;
            Tuple3 Tuple_this2 = x$proxy4 = x$proxy3;
            String string2 = setting.encode(Tuple_this2._2());
            NamedTuple$ namedTuple$5 = NamedTuple$.MODULE$;
            Tuple3 x$proxy5 = inheritedStatus;
            NamedTuple$ namedTuple$6 = namedTuple$5;
            Tuple3 Tuple_this3 = x$proxy6 = x$proxy5;
            String string3 = setting.encode(Tuple_this3._3());
            InheritedValueAsString inheritedValueAsString = InheritedValueAsString$.MODULE$.apply(string2, bl, string3);
            return Tuple3$.MODULE$.apply(setting, inheritedStatus, inheritedValueAsString);
        }).map((Function1<Tuple3, InheritedValueAsString> & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                Tuple3 tuple32 = (Tuple3)tuple3._2();
                AppSettings.Setting setting = (AppSettings.Setting)tuple3._1();
                Tuple3 inheritedStatus = tuple32;
                InheritedValueAsString inheritedValueAsString = (InheritedValueAsString)tuple3._3();
                return inheritedValueAsString;
            }
            throw new MatchError(tuple3);
        });
    }

    @Path(value="settings-with-inheritance/{setting}")
    @jakarta.ws.rs.Path(value="settings-with-inheritance/{setting}")
    @javax.ws.rs.GET
    @GET
    public Object getInheritedStatus(@javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName, @QueryParam(value="scope") @jakarta.ws.rs.QueryParam(value="scope") String scopeStr) {
        return io.circe.parser.package$.MODULE$.decode((String)Option$.MODULE$.apply(scopeStr).getOrElse(GenericSettingsResource::getInheritedStatus$$anonfun$1), (Decoder)Scope$.MODULE$.derived$Codec()).left().map((Function1<Error, Object> & Serializable)err -> this.statusJ(ServletResponse$.MODULE$.SC_BAD_REQUEST(), (Object)new StringBuilder(32).append("Malformed scope query param `").append(scopeStr).append("`: ").append(err.getMessage()).toString(), this.statusJ$default$3(), this.statusJ$default$4())).flatMap((Function1<Scope, Either> & Serializable)scope -> {
            Scope scope2 = scope;
            Scope scope3 = Scope$.Global;
            return package$.MODULE$.Either().cond(scope2 == null ? scope3 != null : !scope2.equals(scope3), (Function0<Object> & Serializable)() -> {
                GenericSettingsResource.getInheritedStatus$$anonfun$3$$anonfun$1();
                return BoxedUnit.UNIT;
            }, () -> this.getInheritedStatus$$anonfun$3$$anonfun$2(settingName)).flatMap((Function1<BoxedUnit, Either> & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.inheritedStatus(settingName, (Scope)scope).map((Function1<InheritedValueAsString, Object> & Serializable)status -> this.okJ(status, this.okJ$default$2(), this.okJ$default$3()));
            });
        }).fold((Function1<Object, Object> & Serializable)x -> Predef$.MODULE$.identity(x), (Function1<Object, Object> & Serializable)x -> Predef$.MODULE$.identity(x));
    }

    @Path(value="global-settings-with-inheritance/{setting}")
    @jakarta.ws.rs.Path(value="global-settings-with-inheritance/{setting}")
    @javax.ws.rs.GET
    @GET
    @WebSudoRequired
    public Object getGlobalSettingWithInheritedStatus(@javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName) {
        return this.inheritedStatus(settingName, Scope$.Global).fold((Function1<Object, Object> & Serializable)x -> Predef$.MODULE$.identity(x), (Function1<InheritedValueAsString, Object> & Serializable)_$1 -> this.okJ(_$1, this.okJ$default$2(), this.okJ$default$3()));
    }

    @Path(value="global/settings/{setting}")
    @jakarta.ws.rs.Path(value="global/settings/{setting}")
    @javax.ws.rs.GET
    @GET
    @WebSudoRequired
    public Object getGlobalSetting(@javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName) {
        return this.responseForScope(settingName, Scope$.Global);
    }

    @Path(value="global/settings/{setting}")
    @jakarta.ws.rs.Path(value="global/settings/{setting}")
    @PUT
    @jakarta.ws.rs.PUT
    @WebSudoRequired
    public Object putGlobalSetting(@javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName, String stringValue) {
        return this.setGlobalSetting(settingName, stringValue);
    }

    @Path(value="global/settings/{setting}")
    @jakarta.ws.rs.Path(value="global/settings/{setting}")
    @javax.ws.rs.DELETE
    @DELETE
    @WebSudoRequired
    public Object deleteGlobalSetting(@javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName) {
        return this.permissions.requiresGlobalAdmin(() -> this.deleteGlobalSetting$$anonfun$1(settingName));
    }

    @Path(value="projects/{projectKey}/settings")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/settings")
    @javax.ws.rs.GET
    @GET
    public Object getProjectSettings(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey) {
        scala.collection.immutable.Map result = ((IterableOnceOps)this.settings().allSettings().map((Function1<AppSettings.Setting, Tuple2> & Serializable)s -> {
            String string2 = Predef$.MODULE$.ArrowAssoc(s.settingName());
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, this.settingStorage().retrieveValue(s).apply(projectKey).valueAsString());
        })).toMap($less$colon$less$.MODULE$.refl());
        return this.okJ(CollectionConverters$.MODULE$.MapHasAsJava(result).asJava(), this.okJ$default$2(), this.okJ$default$3());
    }

    @Path(value="projects/{projectKey}/settings/{setting}")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/settings/{setting}")
    @javax.ws.rs.GET
    @GET
    public Object getProjectSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName) {
        return this.responseForScope(settingName, Scope$Project$.MODULE$.apply(projectKey));
    }

    @Path(value="projects/{projectKey}/settings/{setting}")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/settings/{setting}")
    @PUT
    @jakarta.ws.rs.PUT
    public Object enableProjectSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String setting, String stringValue) {
        return this.setProjectSetting(projectKey, setting, stringValue);
    }

    @Path(value="projects/{projectKey}/settings/{setting}")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/settings/{setting}")
    @javax.ws.rs.DELETE
    @DELETE
    public Object removeProjectSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName) {
        return this.permissions.requiresProjectAdmin(projectKey, (Function1<Project, Object> & Serializable)_$2 -> this.settings().findUntyped(settingName).map((Function1<AppSettings.Setting, Object> & Serializable)setting -> {
            StoredAppSettings.GenericSetting settingAccessor = this.settingStorage().retrieveValue(setting).apply(Scope$Project$.MODULE$.apply(projectKey));
            settingAccessor.delete();
            return this.okJ(ConfigAsString$.MODULE$.apply(settingAccessor.valueAsString()), this.okJ$default$2(), this.okJ$default$3());
        }).getOrElse(this::removeProjectSetting$$anonfun$1$$anonfun$2));
    }

    @Path(value="projects/{projectKey}/repos/{repoSlug}/settings")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/repos/{repoSlug}/settings")
    @javax.ws.rs.GET
    @GET
    public Object getRepoSettings(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="repoSlug") @PathParam(value="repoSlug") String repoSlug) {
        return Option$.MODULE$.apply(this.repositoryService.getBySlug(projectKey, repoSlug)).map((Function1<Repository, Object> & Serializable)repo -> {
            java.util.Map projectSetting = CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)this.settings().allSettings().map((Function1<AppSettings.Setting, Tuple2> & Serializable)s -> {
                String string2 = Predef$.MODULE$.ArrowAssoc(s.settingName());
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, this.settingStorage().retrieveValue(s).apply(projectKey).valueAsString());
            })).toMap($less$colon$less$.MODULE$.refl())).asJava();
            java.util.Map repoSetting = CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)this.settings().allSettings().map((Function1<AppSettings.Setting, Tuple2> & Serializable)s -> {
                InheritedConfigAsString config = this.inheritedConfigAsString((AppSettings.Setting<?>)s, (Repository)repo);
                String string2 = Predef$.MODULE$.ArrowAssoc(s.settingName());
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, config);
            })).toMap($less$colon$less$.MODULE$.refl())).asJava();
            Tuple2[] tuple2Array = new Tuple2[2];
            String string2 = Predef$.MODULE$.ArrowAssoc("project");
            tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, projectSetting);
            String string3 = Predef$.MODULE$.ArrowAssoc("repo");
            tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, repoSetting);
            return this.okJ(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array))).asJava(), this.okJ$default$2(), this.okJ$default$3());
        }).getOrElse(() -> this.getRepoSettings$$anonfun$2(projectKey, repoSlug));
    }

    @Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}")
    @javax.ws.rs.GET
    @GET
    public Object getRepoSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="repoSlug") @PathParam(value="repoSlug") String repoSlug, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName) {
        Option response = Option$.MODULE$.apply(this.repositoryService.getBySlug(projectKey, repoSlug)).flatMap((Function1<Repository, Option> & Serializable)repo -> this.settings().findUntyped(settingName).map((Function1<AppSettings.Setting, Object> & Serializable)setting -> {
            Option<String> value = this.settingStorage().retrieveValue(setting).apply(Scope$Repo$.MODULE$.apply(projectKey, repo.getSlug(), repo.getId())).scopedAsString();
            return this.okJ(ConfigAsString$.MODULE$.apply((String)value.orNull($less$colon$less$.MODULE$.refl())), this.okJ$default$2(), this.okJ$default$3());
        }));
        return response.getOrElse(this::getRepoSetting$$anonfun$1);
    }

    @Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}")
    @PUT
    @jakarta.ws.rs.PUT
    public Object enableRepoSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="repoSlug") @PathParam(value="repoSlug") String repoSlug, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String setting, String stringValue) {
        return this.setRepoSetting(projectKey, repoSlug, setting, stringValue);
    }

    @Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}")
    @jakarta.ws.rs.Path(value="projects/{projectKey}/repos/{repoSlug}/settings/{setting}")
    @javax.ws.rs.DELETE
    @DELETE
    public Object removeRepoSetting(@javax.ws.rs.PathParam(value="projectKey") @PathParam(value="projectKey") String projectKey, @javax.ws.rs.PathParam(value="repoSlug") @PathParam(value="repoSlug") String repoSlug, @javax.ws.rs.PathParam(value="setting") @PathParam(value="setting") String settingName) {
        return this.permissions.requiresRepoAdmin(projectKey, repoSlug, (Function1<Repository, Object> & Serializable)repo -> this.settings().findUntyped(settingName).map((Function1<AppSettings.Setting, Object> & Serializable)setting -> {
            this.settingStorage().retrieveValue(setting).apply(Scope$Repo$.MODULE$.apply(repo.getProject().getKey(), repo.getSlug(), repo.getId())).delete();
            return this.okJ(this.inheritedConfigAsString((AppSettings.Setting<?>)setting, (Repository)repo), this.okJ$default$2(), this.okJ$default$3());
        }).getOrElse(this::removeRepoSetting$$anonfun$1$$anonfun$2));
    }

    private InheritedConfigAsString inheritedConfigAsString(AppSettings.Setting<?> setting, Repository repo) {
        Scope.Repo repoScope = Scope$Repo$.MODULE$.apply(repo.getProject().getKey(), repo.getSlug(), repo.getId());
        String value = this.settingStorage().retrieveValue(setting).apply(repoScope).valueAsString();
        boolean appActive = this.settingStorage().retrieveValue(this.settings().appEnabled()).apply(repo).active($less$colon$less$.MODULE$.refl());
        boolean inheritedValue = this.settingStorage().retrieveValue(setting).apply(repoScope).scoped().isEmpty();
        return InheritedConfigAsString$.MODULE$.apply(value, Predef$.MODULE$.boolean2Boolean(inheritedValue), Predef$.MODULE$.boolean2Boolean(appActive));
    }

    private Object setGlobalSetting(String settingName, String stringValue) {
        return this.permissions.requiresGlobalAdmin(() -> this.setGlobalSetting$$anonfun$1(settingName, stringValue));
    }

    private Object setProjectSetting(String projectKey, String settingName, String stringValue) {
        return this.permissions.requiresProjectAdmin(projectKey, (Function1<Project, Object> & Serializable)_$4 -> this.settings().findUntyped(settingName).map((Function1<AppSettings.Setting, StoredAppSettings.GenericSetting> & Serializable)_$5 -> this.settingStorage().retrieveValue(_$5).apply(Scope$Project$.MODULE$.apply(projectKey))).map((Function1<StoredAppSettings.GenericSetting, Object> & Serializable)setting -> {
            Either<Throwable, BoxedUnit> either = setting.putStringValue(stringValue);
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable throwable = (Throwable)left.value();
                this.warn(new StringBuilder(54).append("The setting ").append(settingName).append(" was not able to process the string value ").append(stringValue).toString(), throwable);
                return this.badRequest("");
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                return this.okJ(ConfigAsString$.MODULE$.apply(stringValue), this.okJ$default$2(), this.okJ$default$3());
            }
            throw new MatchError(either);
        }).getOrElse(this::setProjectSetting$$anonfun$1$$anonfun$3));
    }

    private Object setRepoSetting(String projectKey, String repoSlug, String settingName, String stringValue) {
        return this.permissions.requiresRepoAdmin(projectKey, repoSlug, (Function1<Repository, Object> & Serializable)repo -> this.settings().findUntyped(settingName).map((Function1<AppSettings.Setting, Object> & Serializable)setting -> {
            Object object;
            block4: {
                try {
                    Either<Throwable, BoxedUnit> either = this.settingStorage().retrieveValue(setting).apply(Scope$Repo$.MODULE$.apply(repo.getProject().getKey(), repo.getSlug(), repo.getId())).putStringValue(stringValue);
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Throwable throwable = (Throwable)left.value();
                        this.warn(new StringBuilder(54).append("The setting ").append(settingName).append(" was not able to process the string value ").append(stringValue).toString(), throwable);
                        object = this.badRequest("");
                        break block4;
                    }
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        object = this.okJ(this.inheritedConfigAsString((AppSettings.Setting<?>)setting, (Repository)repo), this.okJ$default$2(), this.okJ$default$3());
                        break block4;
                    }
                    throw new MatchError(either);
                }
                catch (Throwable e) {
                    this.error("There was an error while changing value of repo setting", e);
                    object = this.internalError("");
                }
            }
            return object;
        }).getOrElse(this::setRepoSetting$$anonfun$1$$anonfun$2));
    }

    private final Object responseForScope$$anonfun$1() {
        return this.notFound();
    }

    private final Object inheritedStatus$$anonfun$1(String settingName$1) {
        return this.statusJ(ServletResponse$.MODULE$.SC_NOT_FOUND(), (Object)new StringBuilder(23).append(settingName$1).append(" is not a known setting").toString(), this.statusJ$default$3(), this.statusJ$default$4());
    }

    private static final String getInheritedStatus$$anonfun$1() {
        return "";
    }

    private static final void getInheritedStatus$$anonfun$3$$anonfun$1() {
    }

    private final Object getInheritedStatus$$anonfun$3$$anonfun$2(String settingName$3) {
        String string2 = Predef$.MODULE$.ArrowAssoc("Location");
        Some<Tuple2<String, String>> some = Some$.MODULE$.apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.navBuilder.buildAbsolute()), new StringBuilder(67).append("/rest/codeowners/1.0/app-settings/global-settings-with-inheritance/").append(settingName$3).toString())));
        CacheInfo cacheInfo = this.statusJ$default$3();
        return this.statusJ(ServletResponse$.MODULE$.SC_TEMPORARY_REDIRECT(), (Object)"", cacheInfo, some);
    }

    private final Object deleteGlobalSetting$$anonfun$1$$anonfun$2() {
        return this.notFound();
    }

    private final Object deleteGlobalSetting$$anonfun$1(String settingName$5) {
        return this.settings().findUntyped(settingName$5).map((Function1<AppSettings.Setting, Object> & Serializable)setting -> {
            StoredAppSettings.GenericSetting settingAccessor = this.settingStorage().retrieveValue(setting).apply(Scope$.Global);
            settingAccessor.delete();
            return this.okJ(ConfigAsString$.MODULE$.apply(settingAccessor.valueAsString()), this.okJ$default$2(), this.okJ$default$3());
        }).getOrElse(this::deleteGlobalSetting$$anonfun$1$$anonfun$2);
    }

    private final Object removeProjectSetting$$anonfun$1$$anonfun$2() {
        return this.notFound();
    }

    private final Object getRepoSettings$$anonfun$2(String projectKey$6, String repoSlug$1) {
        return this.noSuchRepoException(projectKey$6, repoSlug$1).getResponse(this.given_RestResponses());
    }

    private final Object getRepoSetting$$anonfun$1() {
        return this.notFound();
    }

    private final Object removeRepoSetting$$anonfun$1$$anonfun$2() {
        return this.notFound();
    }

    private final Object setGlobalSetting$$anonfun$1$$anonfun$3() {
        return this.notFound();
    }

    private final Object setGlobalSetting$$anonfun$1(String settingName$9, String stringValue$1) {
        return this.settings().findUntyped(settingName$9).map((Function1<AppSettings.Setting, StoredAppSettings.GenericSetting> & Serializable)_$3 -> this.settingStorage().retrieveValue(_$3).apply(Scope$.Global)).map((Function1<StoredAppSettings.GenericSetting, Object> & Serializable)setting -> {
            Either<Throwable, BoxedUnit> either = setting.putStringValue(stringValue$1);
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable throwable = (Throwable)left.value();
                this.warn(new StringBuilder(54).append("The setting ").append(settingName$9).append(" was not able to process the string value ").append(stringValue$1).toString(), throwable);
                return this.badRequest("");
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                return this.okJ(ConfigAsString$.MODULE$.apply(stringValue$1), this.okJ$default$2(), this.okJ$default$3());
            }
            throw new MatchError(either);
        }).getOrElse(this::setGlobalSetting$$anonfun$1$$anonfun$3);
    }

    private final Object setProjectSetting$$anonfun$1$$anonfun$3() {
        return this.notFound();
    }

    private final Object setRepoSetting$$anonfun$1$$anonfun$2() {
        return this.notFound();
    }
}

