/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bitbucket.dc.rest;

import ch.mibex.bitbucket.dc.rest.RestResource;
import ch.mibex.utils.ee.rs.NotFoundException;
import ch.mibex.utils.ee.rs.RestResponses;
import ch.mibex.utils.rest.RestErrorMessage$;
import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class RestPermissions
implements RestResource {
    private final I18nService ch$mibex$bitbucket$dc$rest$RestResource$$i18nService;
    private final RestResponses ch$mibex$bitbucket$dc$rest$RestResource$$restResponses;
    private final PermissionValidationService permissionValidationService;
    private final RepositoryService repositoryService;
    private final ProjectService projectService;
    private final I18nService i18nService;
    private final RestResponses restResponses;

    public RestPermissions(PermissionValidationService permissionValidationService, RepositoryService repositoryService, ProjectService projectService, I18nService i18nService, RestResponses restResponses) {
        this.permissionValidationService = permissionValidationService;
        this.repositoryService = repositoryService;
        this.projectService = projectService;
        this.i18nService = i18nService;
        this.restResponses = restResponses;
        this.ch$mibex$bitbucket$dc$rest$RestResource$$i18nService = i18nService;
        this.ch$mibex$bitbucket$dc$rest$RestResource$$restResponses = restResponses;
        RestResource.$init$(this);
    }

    @Override
    public I18nService ch$mibex$bitbucket$dc$rest$RestResource$$i18nService() {
        return this.ch$mibex$bitbucket$dc$rest$RestResource$$i18nService;
    }

    @Override
    public RestResponses ch$mibex$bitbucket$dc$rest$RestResource$$restResponses() {
        return this.ch$mibex$bitbucket$dc$rest$RestResource$$restResponses;
    }

    public RestResponses restResponses() {
        return this.restResponses;
    }

    public Object requiresRepoRead(String projectKey, String repoSlug, Function1<Repository, Object> block) {
        return this.requiresRepoPermission(projectKey, repoSlug, Permission.REPO_READ, block);
    }

    public Object requiresRepoAdmin(String projectKey, String repoSlug, Function1<Repository, Object> block) {
        return this.requiresRepoPermission(projectKey, repoSlug, Permission.REPO_ADMIN, block);
    }

    public Object requiresRepoAdmin(int repoId, Function1<Repository, Object> block) {
        return this.requiresRepoPermission(repoId, Permission.REPO_ADMIN, block);
    }

    public Object requiresRepoPermission(String projectKey, String repoSlug, Permission permission, Function1<Repository, Object> block) {
        return this.requiresRepoPermission((Function0<Option<Repository>>)(Function0<Option> & Serializable)() -> Option$.MODULE$.apply(this.repositoryService.getBySlug(projectKey, repoSlug)), (Function0<NotFoundException> & Serializable)() -> this.noSuchRepoException(projectKey, repoSlug), permission, block);
    }

    public Object requiresRepoPermission(int repoId, Permission permission, Function1<Repository, Object> block) {
        return this.requiresRepoPermission((Function0<Option<Repository>>)(Function0<Option> & Serializable)() -> Option$.MODULE$.apply(this.repositoryService.getById(repoId)), (Function0<NotFoundException> & Serializable)() -> this.noSuchRepoException(repoId), permission, block);
    }

    private Object requiresRepoPermission(Function0<Option<Repository>> repo2, Function0<NotFoundException> notFoundMessage, Permission permission, Function1<Repository, Object> block) {
        Object object;
        try {
            object = repo2.apply().map((Function1<Repository, Object> & Serializable)repo -> {
                this.permissionValidationService.validateForRepository(repo, permission);
                return block.apply((Repository)repo);
            }).getOrElse(() -> this.requiresRepoPermission$$anonfun$6(notFoundMessage));
        }
        catch (AuthorisationException authorisationException) {
            object = this.notAdminResponse("repoAdmin");
        }
        return object;
    }

    public Object requiresProjectAdmin(String projectKey, Function1<Project, Object> block) {
        Object object;
        try {
            object = Option$.MODULE$.apply(this.projectService.getByKey(projectKey)).map((Function1<Project, Object> & Serializable)project -> {
                this.permissionValidationService.validateForProject(project, Permission.PROJECT_ADMIN);
                return block.apply((Project)project);
            }).getOrElse(() -> this.$anonfun$2(projectKey));
        }
        catch (AuthorisationException authorisationException) {
            object = this.notAdminResponse("projectAdmin");
        }
        Object response = object;
        return response;
    }

    public Object requiresGlobalAdmin(Function0<Object> block) {
        Try try_ = Try$.MODULE$.apply((Function0<Object> & Serializable)() -> {
            this.requiresGlobalAdmin$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object t = success.value();
            if (!(boxedUnit != null ? !((Object)boxedUnit).equals(t) : t != null)) {
                return block.apply();
            }
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            return this.notAdminResponse("admin");
        }
        throw new MatchError(try_);
    }

    public Object notAdminResponse(String level) {
        return this.restResponses().forbidden(RestErrorMessage$.MODULE$.apply(this.i18nService.getMessage(new StringBuilder(28).append("mibex.adminconfig.not.").append(level).append(".error").toString(), new Object[0])).asRestEntity());
    }

    private final Object requiresRepoPermission$$anonfun$6(Function0 notFoundMessage$1) {
        return ((NotFoundException)notFoundMessage$1.apply()).getResponse(this.given_RestResponses());
    }

    private final Object $anonfun$2(String projectKey$3) {
        return this.noSuchProjectException(projectKey$3).getResponse(this.given_RestResponses());
    }

    private final void requiresGlobalAdmin$$anonfun$1() {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
    }
}

