/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bitbucket.dc;

import ch.mibex.atlassian.Logging;
import ch.mibex.atlassian.cache.Cache;
import ch.mibex.bitbucket.dc.CachedGit;
import ch.mibex.bitbucket.dc.GitApiFacade$;
import ch.mibex.bitbucket.dc.LsTreeOutputHandler;
import ch.mibex.bitbucket.dc.OutputHandler;
import ch.mibex.bitbucket.dc.RangeDiffParseResult;
import ch.mibex.git.CommitSha;
import ch.mibex.git.globals$package$FullNamePath$;
import ch.mibex.platform.App;
import ch.mibex.telemetry.TelemetryContext;
import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.cache.CacheFactory;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

public class GitApiFacade
implements Logging,
CachedGit {
    private volatile Logger ch$mibex$atlassian$Logging$$logger;
    private final CacheFactory ch$mibex$bitbucket$dc$CachedGit$$cacheFactory;
    private final App ch$mibex$bitbucket$dc$CachedGit$$app;
    private final TelemetryContext ch$mibex$bitbucket$dc$CachedGit$$telemetry;
    private Cache ch$mibex$bitbucket$dc$CachedGit$$listingCache;
    private Cache ch$mibex$bitbucket$dc$CachedGit$$fileCache;
    private final GitCommandBuilderFactory gitCommand;

    public static IndexedSeq<String> parseGitLsTree(LineReader lineReader) {
        return GitApiFacade$.MODULE$.parseGitLsTree(lineReader);
    }

    public static RangeDiffParseResult parseGitRangeDiff(LineReader lineReader) {
        return GitApiFacade$.MODULE$.parseGitRangeDiff(lineReader);
    }

    public GitApiFacade(GitCommandBuilderFactory gitCommand, CacheFactory cacheFactory, App app, TelemetryContext telemetry) {
        this.gitCommand = gitCommand;
        Logging.$init$(this);
        this.ch$mibex$bitbucket$dc$CachedGit$$cacheFactory = cacheFactory;
        this.ch$mibex$bitbucket$dc$CachedGit$$app = app;
        this.ch$mibex$bitbucket$dc$CachedGit$$telemetry = telemetry;
        CachedGit.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public Logger ch$mibex$atlassian$Logging$$logger() {
        return this.ch$mibex$atlassian$Logging$$logger;
    }

    @Override
    public void ch$mibex$atlassian$Logging$$logger_$eq(Logger x$1) {
        this.ch$mibex$atlassian$Logging$$logger = x$1;
    }

    @Override
    public CacheFactory ch$mibex$bitbucket$dc$CachedGit$$cacheFactory() {
        return this.ch$mibex$bitbucket$dc$CachedGit$$cacheFactory;
    }

    @Override
    public App ch$mibex$bitbucket$dc$CachedGit$$app() {
        return this.ch$mibex$bitbucket$dc$CachedGit$$app;
    }

    @Override
    public TelemetryContext ch$mibex$bitbucket$dc$CachedGit$$telemetry() {
        return this.ch$mibex$bitbucket$dc$CachedGit$$telemetry;
    }

    public Cache ch$mibex$bitbucket$dc$CachedGit$$listingCache() {
        return this.ch$mibex$bitbucket$dc$CachedGit$$listingCache;
    }

    public Cache ch$mibex$bitbucket$dc$CachedGit$$fileCache() {
        return this.ch$mibex$bitbucket$dc$CachedGit$$fileCache;
    }

    @Override
    public void ch$mibex$bitbucket$dc$CachedGit$_setter_$ch$mibex$bitbucket$dc$CachedGit$$listingCache_$eq(Cache x$0) {
        this.ch$mibex$bitbucket$dc$CachedGit$$listingCache = x$0;
    }

    @Override
    public void ch$mibex$bitbucket$dc$CachedGit$_setter_$ch$mibex$bitbucket$dc$CachedGit$$fileCache_$eq(Cache x$0) {
        this.ch$mibex$bitbucket$dc$CachedGit$$fileCache = x$0;
    }

    public Seq<String> listFilesAtCommit(CommitSha<Repository> commit) {
        return (Seq)((IterableOps)this.gitCommand.builder(commit.repo()).lsTree().tree(commit.id()).build((CommandOutputHandler)new LsTreeOutputHandler()).call()).map((Function1<String, String> & Serializable)_$1 -> globals$package$FullNamePath$.MODULE$.apply((String)_$1));
    }

    public Seq<String> listFilesUncached(CommitSha<Repository> commit, Iterable<String> paths) {
        Seq seq;
        try {
            Seq result = (Seq)this.gitCommand.builder(commit.repo()).lsTree().recursive(false).tree(commit.id()).paths(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)paths.map((Function1<String, String> & Serializable)path -> globals$package$FullNamePath$.MODULE$.valueWithoutLeadingSlash((String)path))).asJava()).build((CommandOutputHandler)new LsTreeOutputHandler()).call();
            seq = (Seq)result.map((Function1<String, String> & Serializable)_$2 -> globals$package$FullNamePath$.MODULE$.apply((String)_$2));
        }
        catch (Exception e) {
            this.warn(new StringBuilder(36).append("Not able to list paths ").append(paths).append(" in repo ").append(commit.repo().getName()).append(" of ").append(commit.id()).toString(), e);
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return seq;
    }

    public Option<String> readFileUncached(CommitSha<Repository> commit, String path) {
        None$ none$;
        try {
            String result = (String)this.gitCommand.builder(commit.repo()).catFile().pretty().object(commit.sha(), globals$package$FullNamePath$.MODULE$.valueWithoutLeadingSlash(path)).build((CommandOutputHandler)new OutputHandler()).call();
            none$ = Option$.MODULE$.apply(result);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = option.get();
                this.debug(() -> GitApiFacade.readFileUncached$$anonfun$1(path, commit), e);
                none$ = None$.MODULE$;
            }
            throw throwable;
        }
        return none$;
    }

    private static final String readFileUncached$$anonfun$1(String path$2, CommitSha commit$3) {
        return new StringBuilder(30).append("Not able to read ").append(path$2).append(" in repo ").append(((Repository)commit$3.repo()).getName()).append(" of ").append(commit$3.id()).toString();
    }
}

