/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bitbucket.common;

import ch.mibex.atlassian.Logging;
import ch.mibex.bitbucket.common.BasicCommit;
import ch.mibex.bitbucket.common.JiraEncodings$;
import ch.mibex.bitbucket.common.JiraGlobals$;
import ch.mibex.bitbucket.common.JiraInfo;
import ch.mibex.bitbucket.common.JiraInfo$;
import ch.mibex.bitbucket.common.JiraIssue;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import io.circe.Error;
import io.circe.Json;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.boundary;
import scala.util.boundary$;
import scala.util.control.NonFatal$;

public class JiraService
implements Logging {
    private volatile Logger ch$mibex$atlassian$Logging$$logger;
    private final ApplicationLinkService linkService;

    public JiraService(ApplicationLinkService linkService) {
        this.linkService = linkService;
        Logging.$init$(this);
    }

    @Override
    public Logger ch$mibex$atlassian$Logging$$logger() {
        return this.ch$mibex$atlassian$Logging$$logger;
    }

    @Override
    public void ch$mibex$atlassian$Logging$$logger_$eq(Logger x$1) {
        this.ch$mibex$atlassian$Logging$$logger = x$1;
    }

    public Either<Seq<String>, JiraIssue> fetchJira(String key) {
        Left<Seq<String>, JiraIssue> left;
        Seq links2 = CollectionConverters$.MODULE$.IterableHasAsScala(this.linkService.getApplicationLinks(JiraApplicationType.class)).asScala().toSeq();
        Builder errors = package$.MODULE$.Seq().newBuilder();
        boundary.Label local = new boundary.Label();
        try {
            links2.foreach((Function1<ApplicationLink, Builder> & Serializable)link -> {
                Either<String, JiraIssue> either = this.fetchJiraIssue(key, (ApplicationLink)link);
                if (either instanceof Right) {
                    Right right = (Right)either;
                    JiraIssue found = (JiraIssue)right.value();
                    throw boundary$.MODULE$.break(package$.MODULE$.Right().apply(found), local);
                }
                if (either instanceof Left) {
                    Left left = (Left)either;
                    String error = (String)left.value();
                    return (Builder)errors.addOne(error);
                }
                throw new MatchError(either);
            });
            left = package$.MODULE$.Left().apply(errors.result());
        }
        catch (boundary.Break ex) {
            if (ex.label() == local) {
                left = (Left<Seq<String>, JiraIssue>)ex.value();
            }
            throw ex;
        }
        return left;
    }

    public JiraInfo fetchJiraIssues(String prTitle, String prMessage, Seq<BasicCommit> commits) {
        Set jiraKeys = (Set)JiraGlobals$.MODULE$.extractJiraKeys(commits).$plus$plus(JiraGlobals$.MODULE$.extractJiraKeys(prTitle)).$plus$plus(JiraGlobals$.MODULE$.extractJiraKeys(prMessage));
        Set jiraIssues = (Set)jiraKeys.map((Function1<String, Either> & Serializable)k -> this.fetchJira((String)k));
        Set errors = (Set)((IterableOps)jiraIssues.collect(new Serializable(){

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Seq error = (Seq)left.value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Seq error = (Seq)left.value();
                    return error;
                }
                return function1.apply(x);
            }
        })).flatten(Predef$.MODULE$.$conforms());
        Set issueInfo = (Set)jiraIssues.collect(new Serializable(){

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Right) {
                    Right right = (Right)either;
                    JiraIssue r = (JiraIssue)right.value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Right) {
                    Right right = (Right)either;
                    JiraIssue r = (JiraIssue)right.value();
                    return r;
                }
                return function1.apply(x);
            }
        });
        return JiraInfo$.MODULE$.apply(errors.toSeq(), issueInfo.toSeq());
    }

    private Either<String, JiraIssue> fetchJiraIssue(String key, ApplicationLink link) {
        ApplicationLinkRequestFactory httpClient = link.createAuthenticatedRequestFactory();
        return Try$.MODULE$.apply(() -> this.fetchJiraIssue$$anonfun$1(httpClient, key, link)).recover(new Serializable(link, key, this){
            private final ApplicationLink link$3;
            private final String key$4;
            private final /* synthetic */ JiraService $outer;
            {
                this.link$3 = link$5;
                this.key$4 = key$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable instanceof CredentialsRequiredException) {
                    CredentialsRequiredException credentialsRequiredException;
                    CredentialsRequiredException e = credentialsRequiredException = (CredentialsRequiredException)throwable;
                    return true;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable instanceof CredentialsRequiredException) {
                    CredentialsRequiredException credentialsRequiredException;
                    CredentialsRequiredException e = credentialsRequiredException = (CredentialsRequiredException)throwable;
                    this.$outer.warn(new StringBuilder(35).append("Failed to contact Jira(").append(this.link$3.getRpcUrl()).append(") for issue ").append(this.key$4).toString(), (Throwable)e);
                    return package$.MODULE$.Left().apply(new StringBuilder(102).append("Failed to authenticate against Jira (").append(this.link$3.getDisplayUrl()).append(") to fetch issue ").append(this.key$4).append(". Please [authenticate](").append(e.getAuthorisationURI()).append(") and ask `/aira` again.").toString());
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = option.get();
                    this.$outer.warn(new StringBuilder(35).append("Failed to contact Jira(").append(this.link$3.getRpcUrl()).append(") for issue ").append(this.key$4).toString(), e);
                    return package$.MODULE$.Left().apply(new StringBuilder(58).append("Unknown error occurred while contacting Jira (").append(this.link$3.getDisplayUrl()).append(") for issue ").append(this.key$4).toString());
                }
                return function1.apply(x);
            }
        }).get();
    }

    public static final /* synthetic */ Either ch$mibex$bitbucket$common$JiraService$$anon$3$$_$_$$anonfun$2(Json _$1) {
        return _$1.as(JiraEncodings$.MODULE$.given_Decoder_JiraIssue());
    }

    private final Either fetchJiraIssue$$anonfun$1(ApplicationLinkRequestFactory httpClient$1, String key$2, ApplicationLink link$1) {
        ApplicationLinkRequest req = httpClient$1.createRequest(Request.MethodType.GET, new StringBuilder(18).append("/rest/api/2/issue/").append(key$2).toString());
        return (Either)req.executeAndReturn((ReturningResponseHandler)new ReturningResponseHandler<Response, Either<String, JiraIssue>>(link$1, key$2, this){
            private final ApplicationLink link$2;
            private final String key$3;
            private final /* synthetic */ JiraService $outer;
            {
                this.link$2 = link$4;
                this.key$3 = key$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Either handle(Response resp) {
                if (resp.isSuccessful()) {
                    Either either;
                    String body = resp.getResponseBodyAsString();
                    Either<A1, B1> either2 = io.circe.parser.package$.MODULE$.parse(body).flatMap(JiraService::ch$mibex$bitbucket$common$JiraService$$anon$3$$_$_$$anonfun$2);
                    if (either2 instanceof Right) {
                        Right right = (Right)either2;
                        JiraIssue info = (JiraIssue)right.value();
                        either = package$.MODULE$.Right().apply(info);
                    } else if (either2 instanceof Left) {
                        Left left = (Left)either2;
                        Error error = (Error)left.value();
                        this.$outer.warn(new StringBuilder(31).append("Failed to parse Jira (").append(this.link$2.getRpcUrl()).append(") answer ").append(error).toString());
                        either = package$.MODULE$.Left().apply(new StringBuilder(31).append("Failed to parse Jira (").append(this.link$2.getDisplayUrl()).append(") issue ").append(this.key$3).append(".").toString());
                    } else {
                        throw new MatchError(either2);
                    }
                    Right<A, JiraIssue> jiraInfo = either;
                    return jiraInfo;
                }
                this.$outer.info(new StringBuilder(39).append("Failed to fetch Jira (").append(this.link$2.getRpcUrl()).append("). Got response ").append(resp.getStatusCode()).append(" ").append(resp.getEntity(String.class)).toString());
                if (resp.getStatusCode() == 404) {
                    return package$.MODULE$.Left().apply(new StringBuilder(59).append("Failed to find Jira (").append(this.link$2.getDisplayUrl()).append(") issue ").append(this.key$3).append(". Double check that it exists.").toString());
                }
                return package$.MODULE$.Left().apply(new StringBuilder(49).append("Failed to fetch Jira (").append(this.link$2.getDisplayUrl()).append(") issue ").append(this.key$3).append(" with HTTP error ").append(resp.getStatusCode()).append(" ").append(resp.getStatusText()).append(".").toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ch$mibex$bitbucket$common$JiraService$$anon$3$$_$_$$anonfun$2(io.circe.Json )}, serializedLambda);
            }
        });
    }
}

