/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.sonar;

import ch.mibex.atlassian.Logging;
import ch.mibex.bamboo.sonar4bamboo.SonarQubeEdition;
import ch.mibex.bamboo.sonar4bamboo.SonarQubeEdition$;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials;
import ch.mibex.bamboo.sonar4bamboo.sonar.HttpClientWrapper;
import ch.mibex.bamboo.sonar4bamboo.sonar.ProjectLink;
import ch.mibex.bamboo.sonar4bamboo.sonar.ProjectLink$;
import ch.mibex.bamboo.sonar4bamboo.sonar.ResponseError;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarBranch;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarBranch$;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarClient;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarUtils$;
import ch.mibex.sonar.SonarServer$;
import java.io.Serializable;
import java.net.URLEncoder;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class SonarClientImpl
implements SonarClient,
Logging,
HttpClientWrapper {
    private volatile Logger ch$mibex$atlassian$Logging$$logger;

    public SonarClientImpl() {
        Logging.$init$(this);
    }

    @Override
    public Logger ch$mibex$atlassian$Logging$$logger() {
        return this.ch$mibex$atlassian$Logging$$logger;
    }

    @Override
    public void ch$mibex$atlassian$Logging$$logger_$eq(Logger x$1) {
        this.ch$mibex$atlassian$Logging$$logger = x$1;
    }

    @Override
    public Either<ResponseError, JSONObject> getAnalysisStatus(String ceTaskUrl, Credentials credentials) {
        return this.doGet(ceTaskUrl, (Function1<String, JSONObject> & Serializable)(T1 response) -> new JSONObject(response).getJSONObject("task"), Some$.MODULE$.apply(credentials), this.doGet$default$4());
    }

    @Override
    public Either<ResponseError, List<String>> getFailingQualityGates(String analysisId, String sonarServerUrl, Credentials credentials) {
        String url = new StringBuilder(44).append(sonarServerUrl).append("/api/qualitygates/project_status?analysisId=").append(analysisId).toString();
        return this.doGet(url, (Function1<String, List> & Serializable)(T1 response) -> {
            String overallStatus;
            ListBuffer failingQualityGates = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[0]));
            JSONObject projectStatus = new JSONObject(response).getJSONObject("projectStatus");
            String string2 = overallStatus = projectStatus.getString("status");
            String string3 = "ERROR";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                JSONArray conditions = projectStatus.getJSONArray("conditions");
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), conditions.length()).foreach(i -> {
                    JSONObject qualityGateStatus = conditions.getJSONObject(i);
                    String string2 = qualityGateStatus.getString("status");
                    String string3 = "ERROR";
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        String alertText = SonarUtils$.MODULE$.formatQualityGateError(qualityGateStatus);
                        failingQualityGates.$plus$eq(alertText);
                        return;
                    }
                });
            }
            return failingQualityGates.toList();
        }, Some$.MODULE$.apply(credentials), this.doGet$default$4());
    }

    @Override
    public Either<ResponseError, Seq<SonarBranch>> getBranches(String projectKey, String sonarServerUrl, Credentials credentials) {
        String url = new StringBuilder(35).append(sonarServerUrl).append("/api/project_branches/list?project=").append(projectKey).toString();
        return this.doGet(url, (Function1<String, IndexedSeq> & Serializable)(T1 response) -> {
            JSONArray branches = new JSONObject(response).getJSONArray("branches");
            return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), branches.length()).map((Function1<Object, SonarBranch> & Serializable)i -> SonarBranch$.MODULE$.apply(branches.getJSONObject(BoxesRunTime.unboxToInt(i)).getString("name")));
        }, Some$.MODULE$.apply(credentials), this.doGet$default$4());
    }

    @Override
    public Either<ResponseError, BoxedUnit> createProjectLink(String projectKey, String bambooBuildResultUrl, String linkName, String sonarServerUrl, Credentials credentials) {
        String linkNameEnc = URLEncoder.encode(linkName, "UTF-8");
        String bambooBuildResultUrlEnc = URLEncoder.encode(bambooBuildResultUrl, "UTF-8");
        String url = new StringBuilder(0).append(sonarServerUrl).append(new StringBuilder(48).append("/api/project_links/create?projectKey=").append(projectKey).append("&name=").append(linkNameEnc).append("&url=").append(bambooBuildResultUrlEnc).toString()).toString();
        return this.doPost(url, (T1 _$1) -> {}, Some$.MODULE$.apply(credentials), this.doPost$default$4());
    }

    @Override
    public Either<ResponseError, Seq<ProjectLink>> searchProjectLinks(String projectKey, String sonarServerUrl, Credentials credentials) {
        String url = new StringBuilder(0).append(sonarServerUrl).append(new StringBuilder(37).append("/api/project_links/search?projectKey=").append(projectKey).toString()).toString();
        return this.doGet(url, (Function1<String, IndexedSeq> & Serializable)(T1 response) -> {
            JSONArray links2 = new JSONObject(response).getJSONArray("links");
            return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), links2.length()).map((Function1<Object, ProjectLink> & Serializable)i -> ProjectLink$.MODULE$.apply(links2.getJSONObject(BoxesRunTime.unboxToInt(i)).getString("id"), links2.getJSONObject(BoxesRunTime.unboxToInt(i)).getString("name")));
        }, Some$.MODULE$.apply(credentials), this.doGet$default$4());
    }

    @Override
    public Either<ResponseError, BoxedUnit> deleteProjectLink(String linkId, String sonarServerUrl, Credentials credentials) {
        String url = new StringBuilder(0).append(sonarServerUrl).append(new StringBuilder(29).append("/api/project_links/delete?id=").append(linkId).toString()).toString();
        return this.doPost(url, (T1 _$2) -> {}, Some$.MODULE$.apply(credentials), this.doPost$default$4());
    }

    @Override
    public Either<ResponseError, Object> authenticate(String sonarServerUrl, Credentials credentials) {
        String url = new StringBuilder(28).append(sonarServerUrl).append("/api/authentication/validate").toString();
        return this.doGet(url, (Function1<String, Boolean> & Serializable)(T1 response) -> new JSONObject(response).getBoolean("valid"), Some$.MODULE$.apply(credentials), this.doGet$default$4());
    }

    @Override
    public Either<ResponseError, ArtifactVersion> getSonarVersion(String sonarServerUrl) {
        String url = new StringBuilder(19).append(sonarServerUrl).append("/api/server/version").toString();
        return this.doGet(url, (Function1<String, DefaultArtifactVersion> & Serializable)(T1 response) -> new DefaultArtifactVersion(response), this.doGet$default$3(), this.doGet$default$4());
    }

    @Override
    public Either<ResponseError, SonarQubeEdition> getSonarQubeEdition(String sonarServerUrl, Credentials credentials, FiniteDuration requestTimeout) {
        if (SonarServer$.MODULE$.isSonarCloud(sonarServerUrl)) {
            return package$.MODULE$.Right().apply(SonarQubeEdition$.COMMERCIAL_EDITION);
        }
        String languageUrl = new StringBuilder(19).append(sonarServerUrl).append("/api/languages/list").toString();
        Function1<String, Boolean> & Serializable callback = (Function1<String, Boolean> & Serializable)response -> {
            JSONArray languages = new JSONObject(response).getJSONArray("languages");
            boolean hasCpp = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), languages.length()).map((Function1<Object, String> & Serializable)_$3 -> SonarClientImpl.$anonfun$2(languages, BoxesRunTime.unboxToInt(_$3))).contains("cpp");
            return hasCpp;
        };
        Either hasCommercialLanguage = this.doGet(languageUrl, callback, Some$.MODULE$.apply(credentials), requestTimeout);
        return hasCommercialLanguage.flatMap((Function1<Object, Either> & Serializable)isCommercial -> this.getSonarQubeEdition$$anonfun$1(sonarServerUrl, credentials, requestTimeout, BoxesRunTime.unboxToBoolean(isCommercial)));
    }

    private Either<ResponseError, Object> hasBranchPluginInstalled(String sonarServerUrl, Credentials credentials, FiniteDuration requestTimeout) {
        String pluginsUrl = new StringBuilder(22).append(sonarServerUrl).append("/api/plugins/installed").toString();
        Function1<String, Boolean> & Serializable callback = (Function1<String, Boolean> & Serializable)response -> {
            JSONArray plugins = new JSONObject(response).getJSONArray("plugins");
            Object pluginKeys = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), plugins.length()).map((Function1<Object, String> & Serializable)_$4 -> SonarClientImpl.$anonfun$4(plugins, BoxesRunTime.unboxToInt(_$4)));
            return pluginKeys.contains("communityBranchPlugin");
        };
        return this.doGet(pluginsUrl, callback, Some$.MODULE$.apply(credentials), requestTimeout);
    }

    private static final /* synthetic */ String $anonfun$2(JSONArray languages$1, int _$3) {
        return languages$1.getJSONObject(_$3).getString("key");
    }

    private final /* synthetic */ Either getSonarQubeEdition$$anonfun$1(String sonarServerUrl$1, Credentials credentials$1, FiniteDuration requestTimeout$1, boolean isCommercial) {
        if (isCommercial) {
            return package$.MODULE$.Right().apply(SonarQubeEdition$.COMMERCIAL_EDITION);
        }
        Either<ResponseError, Object> either = this.hasBranchPluginInstalled(sonarServerUrl$1, credentials$1, requestTimeout$1);
        if (either instanceof Right) {
            Right right = (Right)either;
            boolean installed = BoxesRunTime.unboxToBoolean(right.value());
            return package$.MODULE$.Right().apply(installed ? SonarQubeEdition$.COMMUNITY_EDITION_BRANCH : SonarQubeEdition$.COMMUNITY_EDITION);
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            ResponseError err = (ResponseError)left.value();
            return package$.MODULE$.Left().apply(err);
        }
        throw new MatchError(either);
    }

    private static final /* synthetic */ String $anonfun$4(JSONArray plugins$1, int _$4) {
        return plugins$1.getJSONObject(_$4).getString("key");
    }
}

