/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.sonar;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.Utils$;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.BitbucketClient;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.BitbucketHelper;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.Path;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.PullRequest;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.PullRequestService;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerEntity;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarConstants$;
import ch.mibex.bamboo.sonar4bamboo.tasks.BambooUserSettingsHelper$;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarTaskConfigConstants$;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.logging.log4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.AbstractIterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.Statics;

public class IncrementalAnalysis
implements Logging {
    private Logger log;
    private final CustomVariableContext customVariableContext;
    private final BitbucketHelper bitbucketHelper;
    private final PullRequestService pullRequestService;

    public IncrementalAnalysis(CustomVariableContext customVariableContext, BitbucketHelper bitbucketHelper, PullRequestService pullRequestService) {
        this.customVariableContext = customVariableContext;
        this.bitbucketHelper = bitbucketHelper;
        this.pullRequestService = pullRequestService;
        Logging.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    public void applyIncrementalMode(HashMap<String, String> runtimeTaskData, CommonContext context, TaskDefinition taskDefinition, Option<SonarServerEntity> sonarServerConfig, Map<String, String> repoConfig) {
        Option<String> option = Utils$.MODULE$.getCurrentGitBranch(this.customVariableContext);
        if (option instanceof Some) {
            Some some;
            String branchPattern;
            Some some2 = (Some)option;
            String stashBranch = (String)some2.value();
            java.util.Map taskConfig = taskDefinition.getConfiguration();
            Option option2 = Option$.MODULE$.apply(taskConfig.get(SonarTaskConfigConstants$.MODULE$.IncrementalModeGitBranchPatternField()));
            if (option2 instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(branchPattern = (String)(some = (Some)option2).value())) && stashBranch.matches(branchPattern)) {
                this.setDiffRuntimeVariables(context, taskDefinition, runtimeTaskData, sonarServerConfig, stashBranch, repoConfig);
                return;
            }
            this.info("Will not use incremental mode because branch pattern is not configured");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("Incremental mode not possible without a repository added to the plan.");
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDiffRuntimeVariables(CommonContext context, TaskDefinition taskDefinition, HashMap<String, String> runtimeTaskData, Option<SonarServerEntity> sonarServerConfig, String stashBranch, Map<String, String> repoConfig) {
        String string2;
        Option<PullRequest> option = this.pullRequestService.getPullRequest(context, taskDefinition, stashBranch, sonarServerConfig, repoConfig);
        if (option instanceof Some) {
            Some some = (Some)option;
            PullRequest pr = (PullRequest)some.value();
            this.debug(() -> IncrementalAnalysis.setDiffRuntimeVariables$$anonfun$1(pr));
            String bambooUserName = (String)BambooUserSettingsHelper$.MODULE$.getBambooUserName(taskDefinition, sonarServerConfig).getOrElse(IncrementalAnalysis::$anonfun$1);
            List changedFiles = (List)this.bitbucketHelper.callInBambooUserContext(context, repoConfig, bambooUserName, (Function2<BitbucketClient, String, List> & Serializable)(client, applicationLinkId) -> client.findChangedFiles((String)applicationLinkId, pr));
            string2 = runtimeTaskData.put(SonarConstants$.MODULE$.SonarDiffFiles(), ((AbstractIterable)changedFiles.map((Function1<Path, String> & Serializable)_$1 -> _$1.path())).mkString(","));
            return;
        } else {
            String string3;
            String noPullRequestOption;
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            this.warn(new StringBuilder(49).append("Could not determine pull request information for ").append(stashBranch).toString());
            String noPullRequestSetting = (String)taskDefinition.getConfiguration().get(SonarTaskConfigConstants$.MODULE$.IncrementalNoPullRequestField());
            Option<String> option2 = Option$.MODULE$.apply(noPullRequestSetting);
            if (!(option2 instanceof Some)) throw new IllegalStateException("No pull requests found to apply incremental mode. Have you enabled the option WHEN PULL REQUEST IS CREATED in the branches options of your plan?");
            Some some = (Some)option2;
            String string4 = noPullRequestOption = (string3 = (String)some.value());
            String string5 = SonarTaskConfigConstants$.MODULE$.IncrementalModeRunFullAnalysisField();
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                string2 = runtimeTaskData.put(SonarConstants$.MODULE$.SonarDiffFiles(), "");
                return;
            } else {
                String noPullRequestOption2;
                String string6 = noPullRequestOption2 = string3;
                String string7 = SonarTaskConfigConstants$.MODULE$.IncrementalModeSkipTaskField();
                if (string6 != null ? !string6.equals(string7) : string7 != null) throw new IllegalStateException("No pull requests found to apply incremental mode. Have you enabled the option WHEN PULL REQUEST IS CREATED in the branches options of your plan?");
                string2 = runtimeTaskData.put(SonarConstants$.MODULE$.SonarNoPullRequest(), "NO_PULL_REQUEST");
            }
        }
    }

    private static final String setDiffRuntimeVariables$$anonfun$1(PullRequest pr$1) {
        return new StringBuilder(47).append("Found pull request '").append(pr$1.id()).append("' to apply incremental mode").toString();
    }

    private static final String $anonfun$1() {
        throw new IllegalStateException("Expect Bamboo user to be configured in the task settings");
    }
}

