/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.bitbucket;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.BitbucketClient;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.BitbucketHelper;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.PullRequest;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.PullRequest$;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerEntity;
import ch.mibex.bamboo.sonar4bamboo.tasks.BambooUserSettingsHelper$;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import java.io.Serializable;
import org.apache.logging.log4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public class PullRequestService
implements Logging {
    private Logger log;
    private final CustomVariableContext customVariableContext;
    private final BitbucketHelper bitbucketHelper;

    public PullRequestService(CustomVariableContext customVariableContext, BitbucketHelper bitbucketHelper) {
        this.customVariableContext = customVariableContext;
        this.bitbucketHelper = bitbucketHelper;
        Logging.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    public Option<PullRequest> getPullRequest(CommonContext context, TaskDefinition taskDefinition, String stashBranch, Option<SonarServerEntity> sonarServerConfig, Map<String, String> repoConfig) {
        java.util.Map buildVariables = this.customVariableContext.getVariableContexts();
        Option prInfo = Option$.MODULE$.apply(buildVariables.get("repository.pr.sourceBranch")).map((Function1<VariableDefinitionContext, String> & Serializable)_$1 -> _$1.getValue()).flatMap((Function1<String, Option> & Serializable)prSourceBranch -> Option$.MODULE$.apply(buildVariables.get("repository.pr.targetBranch")).map((Function1<VariableDefinitionContext, String> & Serializable)_$2 -> _$2.getValue()).flatMap((Function1<String, Option> & Serializable)prTargetBranch -> repoConfig.get("repository.stash.projectKey").flatMap((Function1<String, Option> & Serializable)projectKey -> repoConfig.get("repository.stash.repositorySlug").flatMap((Function1<String, Option> & Serializable)repoSlug -> Option$.MODULE$.apply(buildVariables.get("repository.pr.key")).map((Function1<VariableDefinitionContext, Long> & Serializable)_$3 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$3.getValue()))).map((Function1<Object, PullRequest> & Serializable)prId -> PullRequest$.MODULE$.apply(projectKey, repoSlug, BoxesRunTime.unboxToLong(prId), prSourceBranch, prTargetBranch, PullRequest$.MODULE$.$lessinit$greater$default$6()))))));
        return prInfo.orElse(() -> this.getPullRequest$$anonfun$1(context, taskDefinition, stashBranch, sonarServerConfig, repoConfig));
    }

    private Option<PullRequest> fetchPullRequestFromBBs(CommonContext context, TaskDefinition taskDefinition, String stashBranch, Option<SonarServerEntity> sonarServerConfig, Map<String, String> repoConfig) {
        Option<String> optCommitId = this.bitbucketHelper.findCommit(context, this.customVariableContext);
        String bitbucketProjectKey = (String)repoConfig.apply("repository.stash.projectKey");
        String repositorySlug = (String)repoConfig.apply("repository.stash.repositorySlug");
        Option<String> optBambooUserName = BambooUserSettingsHelper$.MODULE$.getBambooUserName(taskDefinition, sonarServerConfig);
        Tuple2<Option<String>, Option<String>> tuple2 = Tuple2$.MODULE$.apply(optBambooUserName, optCommitId);
        if (tuple2 != null) {
            Option<String> option = tuple2._1();
            Option<String> option2 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String bambooUserName = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    String commitId = (String)some2.value();
                    return (Option)this.bitbucketHelper.callInBambooUserContext(context, repoConfig, bambooUserName, (Function2<BitbucketClient, String, Option> & Serializable)(client, applicationLinkId) -> {
                        Seq<PullRequest> prs = client.findPullRequests((String)applicationLinkId, repositorySlug, bitbucketProjectKey, stashBranch, commitId);
                        if (prs.length() > 1) {
                            this.info(new StringBuilder(56).append("Found multiple pull requests for branch ").append(stashBranch).append(" in repository ").append(bitbucketProjectKey).append("/").append(repositorySlug).toString());
                        }
                        return prs.headOption();
                    });
                }
            }
            if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                Some some = (Some)option2;
                this.info("Will not try to find a matching PR due to the missing Bamboo user in the task settings");
                return None$.MODULE$;
            }
        }
        this.info("No commit ID found for latest change to apply incremental mode");
        return None$.MODULE$;
    }

    private final Option getPullRequest$$anonfun$1(CommonContext context$1, TaskDefinition taskDefinition$1, String stashBranch$1, Option sonarServerConfig$1, Map repoConfig$4) {
        this.info("No pull request information found in build variables, will do a lookup now...");
        return this.fetchPullRequestFromBBs(context$1, taskDefinition$1, stashBranch$1, sonarServerConfig$1, repoConfig$4);
    }
}

