/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.utils;

import java.io.Serializable;
import scala.Int$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.Ordering$DeprecatedDoubleOrdering$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class Levenshtein$
implements Serializable {
    private static final int n;
    private static final int exponent;
    private static final IndexedSeq<Object> weights;
    public static final Levenshtein$ MODULE$;

    private Levenshtein$() {
    }

    static {
        MODULE$ = new Levenshtein$();
        n = 100;
        exponent = 2;
        weights = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), n).map(i -> 1.0 / package$.MODULE$.pow(Int$.MODULE$.int2double(exponent), (double)i * 0.5));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Levenshtein$.class);
    }

    public double apply(String str1, String str2, boolean reverse) {
        String string2;
        String string1 = reverse ? StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(str1)) : str1;
        String string3 = string2 = reverse ? StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(str2)) : str2;
        if (str1.length() > str2.length()) {
            return this.levenshtein(string1, string2);
        }
        if (str1.length() == str2.length()) {
            double d1 = this.levenshtein(string1, string2);
            double d2 = this.levenshtein(string2, string1);
            return Math.min(d1, d2);
        }
        return this.levenshtein(string2, string1);
    }

    public boolean apply$default$3() {
        return false;
    }

    private double levenshtein(String str1, String str2) {
        int lenStr1 = Math.min(str1.length(), n);
        int lenStr2 = Math.min(str2.length(), n);
        double[][] d = new double[lenStr1 + 1][lenStr2 + 1];
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), lenStr1).foreach(i -> {
            d$1[i][0] = BoxesRunTime.unboxToDouble(weights.apply(i - 1)) + d[i - 1][0];
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), lenStr2).foreach(j -> {
            d$2[0][j] = BoxesRunTime.unboxToDouble(weights.apply(j - 1)) + d[0][j - 1];
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), lenStr1).foreach(i -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), lenStr2).foreach(j -> {
            double weightDeletion = BoxesRunTime.unboxToDouble(weights.apply(j - 1));
            double weightInsertion = BoxesRunTime.unboxToDouble(weights.apply(j));
            double cost = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str1), i - 1) == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str2), j - 1) ? 0.0 : weightDeletion;
            d$4[i$1][j] = this.min$1(ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{d[i - 1][j] + weightInsertion, d[i][j - 1] + weightDeletion, d[i - 1][j - 1] + cost}));
        }));
        return d[lenStr1][lenStr2];
    }

    private final double min$1(Seq nums) {
        return BoxesRunTime.unboxToDouble(nums.min(Ordering$DeprecatedDoubleOrdering$.MODULE$));
    }
}

