/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bitbucket.dc;

import ch.mibex.atlassian.Logging;
import ch.mibex.bitbucket.dc.MergeStrategy;
import ch.mibex.bitbucket.dc.MergeStrategy$;
import ch.mibex.bitbucket.dc.PRMetadata;
import ch.mibex.bitbucket.dc.PullRequestRef;
import ch.mibex.bitbucket.dc.Utils$;
import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.commit.AbstractCommitCallback;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.pull.GetPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.InvalidPullRequestReviewersException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitsRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeConfig;
import com.atlassian.bitbucket.pull.PullRequestMergeStrategy;
import com.atlassian.bitbucket.pull.PullRequestOutOfDateException;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.pull.PullRequestUpdateRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ReusableBuilder;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class PullRequestService$
implements Logging,
Serializable {
    private static volatile Logger ch$mibex$atlassian$Logging$$logger;
    public static final PullRequestService$ MODULE$;

    private PullRequestService$() {
    }

    static {
        MODULE$ = new PullRequestService$();
        Logging.$init$(MODULE$);
    }

    @Override
    public Logger ch$mibex$atlassian$Logging$$logger() {
        return ch$mibex$atlassian$Logging$$logger;
    }

    @Override
    public void ch$mibex$atlassian$Logging$$logger_$eq(Logger x$1) {
        ch$mibex$atlassian$Logging$$logger = x$1;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PullRequestService$.class);
    }

    public Option<PullRequest> fetchPR(PullRequestService service, PRMetadata prRef) {
        return prRef.refToExistingPR().flatMap((Function1<PullRequestRef, Option> & Serializable)ref -> Option$.MODULE$.apply(service.getById(ref.repoId(), ref.pullRequestId())).map((Function1<PullRequest, PullRequest> & Serializable)pr -> pr));
    }

    public <T> Vector<T> findCommits(PullRequestService service, PullRequest pullRequest, Function1<Commit, T> f) {
        Object seen = HashSet$.MODULE$.empty();
        Builder buf = package$.MODULE$.Vector().newBuilder();
        service.streamCommits(new PullRequestCommitsRequest.Builder(pullRequest).build(), (CommitCallback)new AbstractCommitCallback((HashSet)seen, (ReusableBuilder)buf, f){
            private final HashSet seen$1;
            private final ReusableBuilder buf$1;
            private final Function1 f$1;
            {
                this.seen$1 = seen$2;
                this.buf$1 = buf$2;
                this.f$1 = f$2;
            }

            public boolean onCommit(Commit x) {
                if (this.seen$1.add(x.getId())) {
                    this.buf$1.addOne(this.f$1.apply(x));
                }
                return true;
            }
        });
        return (Vector)buf.result();
    }

    public Iterable<PullRequest> findOpenPullRequests(PullRequestService service, Repository repository) {
        return (Iterable)Utils$.MODULE$.page(100, Utils$.MODULE$.page$default$2(), (Function1<PageRequest, Page> & Serializable)_$1 -> service.search(new PullRequestSearchRequest.Builder().toRepositoryId(Predef$.MODULE$.int2Integer(repository.getId())).state(PullRequestState.OPEN).build(), _$1)).toList().distinctBy((Function1<PullRequest, Long> & Serializable)_$2 -> _$2.getId());
    }

    public Iterable<PullRequest> findOpenPullRequests(PullRequestService service, String commitId) {
        return (Iterable)Utils$.MODULE$.page(100, Utils$.MODULE$.page$default$2(), (Function1<PageRequest, Page> & Serializable)_$3 -> service.searchByCommit(new PullRequestCommitSearchRequest.Builder(commitId).state(PullRequestState.OPEN).build(), _$3)).toList().distinctBy((Function1<PullRequest, Long> & Serializable)_$4 -> _$4.getId());
    }

    public Tuple2<PullRequestMergeConfig, scala.collection.immutable.Set<MergeStrategy>> mergeStrategies(PullRequestService service, Repository repo) {
        GetPullRequestMergeConfigRequest configRequest = new GetPullRequestMergeConfigRequest.Builder(repo).build();
        PullRequestMergeConfig mergeConfig = service.getMergeConfig(configRequest);
        Set possibleMergeStrategies = (Set)CollectionConverters$.MODULE$.SetHasAsScala(mergeConfig.getStrategies()).asScala().filter((Function1<PullRequestMergeStrategy, Boolean> & Serializable)_$5 -> _$5.isEnabled());
        return Tuple2$.MODULE$.apply(mergeConfig, ((IterableOnceOps)possibleMergeStrategies.flatMap((Function1<PullRequestMergeStrategy, IterableOnce> & Serializable)s -> MergeStrategy$.MODULE$.fromId(s.getId()))).toSet());
    }

    public PullRequest tryToRunPRUpdateRequest(PullRequestService service, PullRequestUpdateRequest request) {
        PullRequest pullRequest;
        try {
            pullRequest = service.update(request);
        }
        catch (InvalidPullRequestReviewersException e) {
            this.error(new StringBuilder(28).append("failed to change reviewers: ").append(((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(e.getReviewerErrors()).asScala().map((Function1<Tuple2, String> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String msg = (String)tuple2._1();
                    KeyedMessage err = (KeyedMessage)tuple2._2();
                    return new StringBuilder(2).append(msg).append(": ").append(err.getLocalisedMessage()).toString();
                }
                throw new MatchError(tuple2);
            })).mkString(", ")).toString());
            throw e;
        }
        catch (PullRequestOutOfDateException e) {
            this.debug(() -> PullRequestService$.tryToRunPRUpdateRequest$$anonfun$2(e, request), (Throwable)e);
            throw e;
        }
        catch (EntityOutOfDateException e) {
            this.debug(() -> PullRequestService$.tryToRunPRUpdateRequest$$anonfun$3(request), (Throwable)e);
            throw e;
        }
        return pullRequest;
    }

    public PullRequestParticipant setReviewerStatusApiCompatible(PullRequestService service, PullRequest pullRequest, PullRequestParticipantStatus status) {
        PullRequestParticipant pullRequestParticipant;
        int repoId = pullRequest.getToRef().getRepository().getId();
        long prId = pullRequest.getId();
        try {
            pullRequestParticipant = service.setReviewerStatus(repoId, prId, status);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Class<?> builderClass = Class.forName("com.atlassian.bitbucket.pull.PullRequestParticipantStatusRequest$Builder");
            Object builder = builderClass.getConstructor(Integer.TYPE, Long.TYPE).newInstance(BoxesRunTime.boxToInteger(repoId), BoxesRunTime.boxToLong(prId));
            Object object = builderClass.getMethod("status", PullRequestParticipantStatus.class).invoke(builder, status);
            Object request = builderClass.getMethod("build", new Class[0]).invoke(builder, new Object[0]);
            Method method = service.getClass().getMethod("setReviewerStatus", Class.forName("com.atlassian.bitbucket.pull.PullRequestParticipantStatusRequest"));
            pullRequestParticipant = (PullRequestParticipant)method.invoke((Object)service, request);
        }
        return pullRequestParticipant;
    }

    private static final String tryToRunPRUpdateRequest$$anonfun$2(PullRequestOutOfDateException e$1, PullRequestUpdateRequest request$1) {
        return new StringBuilder(46).append("failed to update PR: ").append(e$1.getPullRequest().getId()).append(" with current version: ").append(e$1.getPullRequest().getVersion()).append(", ").append(new StringBuilder(32).append("update request was for version: ").append(request$1.getVersion()).toString()).toString();
    }

    private static final String tryToRunPRUpdateRequest$$anonfun$3(PullRequestUpdateRequest request$2) {
        return new StringBuilder(21).append("failed to update PR: ").append(request$2.getPullRequestId()).toString();
    }
}

